/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal.unit;

import com.liferay.batch.engine.internal.bundle.CompanyBatchEngineUnitWrapper;
import com.liferay.batch.engine.unit.BatchEngineUnit;
import com.liferay.batch.engine.unit.BatchEngineUnitProcessor;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.service.CompanyLocalService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.osgi.framework.Bundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={MultiCompanyBatchEngineUnitProcessor.class})
public class MultiCompanyBatchEngineUnitProcessor {
    @Reference
    private BatchEngineUnitProcessor _batchEngineUnitProcessor;
    private final Map<Bundle, List<BatchEngineUnit>> _bundleBatchEngineUnits = new HashMap<Bundle, List<BatchEngineUnit>>();
    private final Map<Bundle, Set<Long>> _bundleProcessedCompanies = new HashMap<Bundle, Set<Long>>();
    @Reference
    private CompanyLocalService _companyLocalService;

    public CompletableFuture<Void> processBatchEngineUnits(Company company) {
        ArrayList<CompletableFuture<Void>> completableFutures = new ArrayList<CompletableFuture<Void>>();
        for (Bundle bundle : this._bundleBatchEngineUnits.keySet()) {
            completableFutures.add(this._processBatchEngineUnits(bundle, company));
        }
        return CompletableFuture.allOf(completableFutures.toArray(new CompletableFuture[0]));
    }

    public void registerBatchEngineUnits(Bundle bundle, List<BatchEngineUnit> batchEngineUnits) {
        this._bundleBatchEngineUnits.put(bundle, batchEngineUnits);
        this._companyLocalService.forEachCompany(company -> this._processBatchEngineUnits(bundle, (Company)company));
    }

    public void unregister(Bundle bundle) {
        this._bundleBatchEngineUnits.remove(bundle);
        this._bundleProcessedCompanies.remove(bundle);
    }

    public void unregister(Company company) {
        for (Set<Long> companyIds : this._bundleProcessedCompanies.values()) {
            companyIds.remove(company.getCompanyId());
        }
    }

    @Deactivate
    protected void deactivate() {
        this._bundleBatchEngineUnits.clear();
        this._bundleProcessedCompanies.clear();
    }

    private CompletableFuture<Void> _processBatchEngineUnits(Bundle bundle, Company company) {
        Set companyIds = this._bundleProcessedCompanies.computeIfAbsent(bundle, key -> new HashSet());
        if (companyIds.contains(company.getCompanyId())) {
            return CompletableFuture.completedFuture(null);
        }
        companyIds.add(company.getCompanyId());
        return this._batchEngineUnitProcessor.processBatchEngineUnits((Collection)TransformUtil.transform((Collection)this._bundleBatchEngineUnits.get(bundle), batchEngineUnit -> new CompanyBatchEngineUnitWrapper((BatchEngineUnit)batchEngineUnit, company)));
    }
}

