/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal.strategy;

import com.liferay.batch.engine.BatchEngineTaskItemDelegate;
import com.liferay.batch.engine.action.ImportTaskPostAction;
import com.liferay.batch.engine.action.ImportTaskPreAction;
import com.liferay.batch.engine.context.ImportTaskContext;
import com.liferay.batch.engine.exception.handler.BatchEngineImportTaskExceptionHandler;
import com.liferay.batch.engine.internal.util.ErrorMessageUtil;
import com.liferay.batch.engine.model.BatchEngineImportTask;
import com.liferay.batch.engine.service.BatchEngineImportTaskErrorLocalServiceUtil;
import com.liferay.batch.engine.strategy.BatchEngineImportStrategy;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.TransactionConfig;
import com.liferay.portal.kernel.transaction.TransactionInvokerUtil;
import java.util.Collection;
import java.util.List;

public abstract class BaseBatchEngineImportStrategy
implements BatchEngineImportStrategy {
    protected final BatchEngineImportTask batchEngineImportTask;
    protected final List<BatchEngineImportTaskExceptionHandler> batchEngineImportTaskExceptionHandlers;
    protected final List<ImportTaskPostAction> importTaskPostActions;
    protected final List<ImportTaskPreAction> importTaskPreActions;
    private static final TransactionConfig _transactionConfig = TransactionConfig.Factory.create((Propagation)Propagation.REQUIRES_NEW, (Class[])new Class[]{Exception.class}, (Class[])new Class[0]);

    public BaseBatchEngineImportStrategy(BatchEngineImportTask batchEngineImportTask, List<BatchEngineImportTaskExceptionHandler> batchEngineImportTaskExceptionHandlers, List<ImportTaskPostAction> importTaskPostActions, List<ImportTaskPreAction> importTaskPreActions) {
        this.batchEngineImportTask = batchEngineImportTask;
        this.batchEngineImportTaskExceptionHandlers = batchEngineImportTaskExceptionHandlers;
        this.importTaskPostActions = importTaskPostActions;
        this.importTaskPreActions = importTaskPreActions;
    }

    public <T> void apply(BatchEngineTaskItemDelegate<T> batchEngineTaskItemDelegate, Collection<T> collection, UnsafeFunction<T, T, Exception> unsafeFunction) throws Exception {
        for (T item : collection) {
            this.importItem(batchEngineTaskItemDelegate, item, element -> {
                ImportTaskContext importTaskContext = new ImportTaskContext();
                for (ImportTaskPreAction importTaskPreAction : this.importTaskPreActions) {
                    importTaskPreAction.run(this.batchEngineImportTask, batchEngineTaskItemDelegate, importTaskContext, element);
                }
                Object persistedItem = unsafeFunction.apply(element);
                if (persistedItem == null) {
                    return null;
                }
                for (ImportTaskPostAction importTaskPostAction : this.importTaskPostActions) {
                    importTaskPostAction.run(this.batchEngineImportTask, batchEngineTaskItemDelegate, importTaskContext, element, persistedItem);
                }
                return persistedItem;
            });
        }
    }

    protected <T> void addBatchEngineImportTaskError(BatchEngineImportTask batchEngineImportTask, BatchEngineTaskItemDelegate<T> batchEngineTaskItemDelegate, T item, int itemIndex, Exception exception) {
        try {
            TransactionInvokerUtil.invoke((TransactionConfig)_transactionConfig, () -> {
                BatchEngineImportTaskErrorLocalServiceUtil.addBatchEngineImportTaskError((long)batchEngineImportTask.getCompanyId(), (long)batchEngineImportTask.getUserId(), (long)batchEngineImportTask.getBatchEngineImportTaskId(), (String)item.toString(), (int)itemIndex, (String)ErrorMessageUtil.getErrorMessage(exception, batchEngineImportTask.getUserId()));
                this.batchEngineImportTaskExceptionHandlers.forEach(batchEngineImportTaskExceptionHandler -> batchEngineImportTaskExceptionHandler.handle(batchEngineImportTask, batchEngineTaskItemDelegate, exception, item));
                return null;
            });
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    protected abstract <T> T importItem(BatchEngineTaskItemDelegate<T> var1, T var2, UnsafeFunction<T, T, Exception> var3) throws Exception;
}

