/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal.model.listener;

import com.liferay.batch.engine.model.BatchEngineExportTask;
import com.liferay.batch.engine.model.BatchEngineImportTask;
import com.liferay.batch.engine.service.BatchEngineExportTaskLocalService;
import com.liferay.batch.engine.service.BatchEngineImportTaskLocalService;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.ModelListener;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class CompanyModelListener
extends BaseModelListener<Company> {
    private static final Log _log = LogFactoryUtil.getLog(CompanyModelListener.class);
    @Reference
    private BatchEngineExportTaskLocalService _batchEngineExportTaskLocalService;
    @Reference
    private BatchEngineImportTaskLocalService _batchEngineImportTaskLocalService;

    public void onBeforeRemove(Company company) throws ModelListenerException {
        for (BatchEngineExportTask batchEngineExportTask : this._batchEngineExportTaskLocalService.getBatchEngineExportTasks(company.getCompanyId(), -1, -1)) {
            try {
                this._batchEngineExportTaskLocalService.deleteBatchEngineExportTask(batchEngineExportTask.getBatchEngineExportTaskId());
            }
            catch (PortalException portalException) {
                _log.error((Object)("Unable to delete batch engine export task " + batchEngineExportTask.getBatchEngineExportTaskId()), (Throwable)portalException);
            }
        }
        for (BatchEngineImportTask batchEngineImportTask : this._batchEngineImportTaskLocalService.getBatchEngineImportTasks(company.getCompanyId(), -1, -1)) {
            try {
                this._batchEngineImportTaskLocalService.deleteBatchEngineImportTask(batchEngineImportTask.getBatchEngineImportTaskId());
            }
            catch (PortalException portalException) {
                _log.error((Object)("Unable to delete batch engine import task " + batchEngineImportTask.getBatchEngineImportTaskId()), (Throwable)portalException);
            }
        }
    }
}

