/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal.writer;

import com.fasterxml.jackson.databind.ObjectWriter;
import com.liferay.batch.engine.internal.writer.BatchEngineExportTaskItemWriter;
import com.liferay.batch.engine.internal.writer.ObjectWriterFactory;
import com.liferay.batch.engine.unit.BatchEngineUnitConfiguration;
import com.liferay.petra.io.unsync.UnsyncPrintWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class JSONTBatchEngineExportTaskItemWriterImpl
implements BatchEngineExportTaskItemWriter {
    private boolean _itemsStarted;
    private final ObjectWriter _objectWriter;
    private final UnsyncPrintWriter _unsyncPrintWriter;

    public JSONTBatchEngineExportTaskItemWriterImpl(BatchEngineUnitConfiguration batchEngineUnitConfiguration, List<String> includeFieldNames, OutputStream outputStream) throws IOException {
        this._objectWriter = ObjectWriterFactory.getObjectWriter(includeFieldNames);
        this._unsyncPrintWriter = new UnsyncPrintWriter(outputStream);
        this._unsyncPrintWriter.write("{\"actions\":\n{\"createBatch\": {\"href\": \"");
        String endpoint = "/o/headless-batch-engine/v1.0/import-task/" + batchEngineUnitConfiguration.getClassName();
        this._unsyncPrintWriter.write(endpoint);
        this._unsyncPrintWriter.write("\", \"method\": \"POST\"}, \"deleteBatch\": {\"href\": \"");
        this._unsyncPrintWriter.write(endpoint);
        this._unsyncPrintWriter.write("\", \"method\": \"DELETE\"}, \"updateBatch\": {\"href\": \"");
        this._unsyncPrintWriter.write(endpoint);
        this._unsyncPrintWriter.write("\", \"method\": \"PUT\"}},\n\"configuration\":\n");
        this._unsyncPrintWriter.write(this._objectWriter.writeValueAsString((Object)batchEngineUnitConfiguration));
        this._unsyncPrintWriter.write(",\n\"items\": [");
    }

    @Override
    public void close() throws IOException {
        this._unsyncPrintWriter.write("]\n}");
        this._unsyncPrintWriter.flush();
        this._unsyncPrintWriter.close();
    }

    @Override
    public void write(Collection<?> items) throws Exception {
        if (this._itemsStarted) {
            this._unsyncPrintWriter.write(",");
        }
        Iterator<?> iterator = items.iterator();
        while (iterator.hasNext()) {
            Object item = iterator.next();
            this._unsyncPrintWriter.write(this._objectWriter.writeValueAsString(item));
            if (!iterator.hasNext()) continue;
            this._unsyncPrintWriter.write(",");
        }
        if (!this._itemsStarted) {
            this._itemsStarted = true;
        }
    }
}

