/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal.scheduler;

import com.liferay.batch.engine.BatchEngineExportTaskExecutor;
import com.liferay.batch.engine.BatchEngineImportTaskExecutor;
import com.liferay.batch.engine.BatchEngineTaskExecuteStatus;
import com.liferay.batch.engine.configuration.BatchEngineTaskConfiguration;
import com.liferay.batch.engine.model.BatchEngineExportTask;
import com.liferay.batch.engine.model.BatchEngineImportTask;
import com.liferay.batch.engine.service.BatchEngineExportTaskLocalService;
import com.liferay.batch.engine.service.BatchEngineImportTaskLocalService;
import com.liferay.petra.concurrent.NoticeableExecutorService;
import com.liferay.petra.executor.PortalExecutorManager;
import com.liferay.petra.function.UnsafeRunnable;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.scheduler.SchedulerJobConfiguration;
import com.liferay.portal.kernel.scheduler.TimeUnit;
import com.liferay.portal.kernel.scheduler.TriggerConfiguration;
import java.util.Date;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.batch.engine.configuration.BatchEngineTaskConfiguration"}, service={SchedulerJobConfiguration.class})
public class BatchEngineTaskOrphanScannerSchedulerJobConfiguration
implements SchedulerJobConfiguration {
    @Reference
    private BatchEngineExportTaskExecutor _batchEngineExportTaskExecutor;
    @Reference
    private BatchEngineExportTaskLocalService _batchEngineExportTaskLocalService;
    @Reference
    private BatchEngineImportTaskExecutor _batchEngineImportTaskExecutor;
    @Reference
    private BatchEngineImportTaskLocalService _batchEngineImportTaskLocalService;
    private long _orphanageThreshold;
    @Reference
    private PortalExecutorManager _portalExecutorManager;
    private TriggerConfiguration _triggerConfiguration;

    public UnsafeRunnable<Exception> getJobExecutorUnsafeRunnable() {
        return () -> {
            Date modifiedDate;
            NoticeableExecutorService noticeableExecutorService = this._portalExecutorManager.getPortalExecutor(BatchEngineTaskOrphanScannerSchedulerJobConfiguration.class.getName());
            long time = System.currentTimeMillis();
            for (BatchEngineExportTask batchEngineExportTask : this._batchEngineExportTaskLocalService.getBatchEngineExportTasks(BatchEngineTaskExecuteStatus.STARTED.toString())) {
                modifiedDate = batchEngineExportTask.getModifiedDate();
                if (time - modifiedDate.getTime() <= this._orphanageThreshold) continue;
                noticeableExecutorService.submit(() -> this._batchEngineExportTaskExecutor.execute(batchEngineExportTask));
            }
            for (BatchEngineImportTask batchEngineImportTask : this._batchEngineImportTaskLocalService.getBatchEngineImportTasks(BatchEngineTaskExecuteStatus.STARTED.toString())) {
                modifiedDate = batchEngineImportTask.getModifiedDate();
                if (time - modifiedDate.getTime() <= this._orphanageThreshold) continue;
                noticeableExecutorService.submit(() -> this._batchEngineImportTaskExecutor.execute(batchEngineImportTask));
            }
        };
    }

    public TriggerConfiguration getTriggerConfiguration() {
        return this._triggerConfiguration;
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        BatchEngineTaskConfiguration batchEngineTaskConfiguration = (BatchEngineTaskConfiguration)ConfigurableUtil.createConfigurable(BatchEngineTaskConfiguration.class, properties);
        this._triggerConfiguration = TriggerConfiguration.createTriggerConfiguration((int)batchEngineTaskConfiguration.orphanScanInterval(), (TimeUnit)TimeUnit.MINUTE);
        this._orphanageThreshold = (long)batchEngineTaskConfiguration.orphanageThreshold() * 60000L;
    }

    @Deactivate
    protected void deactivate() {
        NoticeableExecutorService executorService = this._portalExecutorManager.getPortalExecutor(BatchEngineTaskOrphanScannerSchedulerJobConfiguration.class.getName(), false);
        if (executorService != null) {
            executorService.shutdownNow();
        }
    }
}

