/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal.item;

import com.liferay.batch.engine.BatchEngineTaskItemDelegate;
import com.liferay.batch.engine.BatchEngineTaskOperation;
import com.liferay.batch.engine.jaxrs.uri.BatchEngineUriInfo;
import com.liferay.batch.engine.pagination.Page;
import com.liferay.batch.engine.pagination.Pagination;
import com.liferay.batch.engine.strategy.BatchEngineImportStrategy;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.filter.ExpressionConvert;
import com.liferay.portal.odata.filter.FilterParser;
import com.liferay.portal.odata.filter.FilterParserProvider;
import com.liferay.portal.odata.sort.SortField;
import com.liferay.portal.odata.sort.SortParser;
import com.liferay.portal.odata.sort.SortParserProvider;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.UriInfo;

public class BatchEngineTaskItemDelegateExecutor {
    private final BatchEngineTaskItemDelegate<Object> _batchEngineTaskItemDelegate;
    private final Company _company;
    private final ExpressionConvert<Filter> _expressionConvert;
    private final FilterParserProvider _filterParserProvider;
    private final Map<String, Serializable> _parameters;
    private final SortParserProvider _sortParserProvider;
    private final User _user;

    public BatchEngineTaskItemDelegateExecutor(BatchEngineTaskItemDelegate<?> batchEngineTaskItemDelegate, Company company, ExpressionConvert<Filter> expressionConvert, FilterParserProvider filterParserProvider, Map<String, Serializable> parameters, SortParserProvider sortParserProvider, User user) {
        this._batchEngineTaskItemDelegate = batchEngineTaskItemDelegate;
        this._company = company;
        this._expressionConvert = expressionConvert;
        this._filterParserProvider = filterParserProvider;
        this._parameters = parameters;
        this._sortParserProvider = sortParserProvider;
        this._user = user;
    }

    public Page<?> getItems(int page, int pageSize) throws Exception {
        this._setContextFields(this._batchEngineTaskItemDelegate);
        return this._batchEngineTaskItemDelegate.read(this._getFilter(), Pagination.of((int)page, (int)pageSize), this._getSorts(), this._getFilteredParameters(), (String)((Object)this._parameters.get("search")));
    }

    public void saveItems(BatchEngineImportStrategy batchEngineImportStrategy, BatchEngineTaskOperation batchEngineTaskOperation, Collection<Object> items) throws Exception {
        this._setContextFields(this._batchEngineTaskItemDelegate);
        this._batchEngineTaskItemDelegate.setBatchEngineImportStrategy(batchEngineImportStrategy);
        if (batchEngineTaskOperation == BatchEngineTaskOperation.CREATE) {
            this._batchEngineTaskItemDelegate.create(items, this._parameters);
        } else if (batchEngineTaskOperation == BatchEngineTaskOperation.DELETE) {
            this._batchEngineTaskItemDelegate.delete(items, this._parameters);
        } else {
            this._batchEngineTaskItemDelegate.update(items, this._parameters);
        }
    }

    private Filter _getFilter() throws Exception {
        String filterString = (String)((Object)this._parameters.get("filter"));
        if (Validator.isNull((String)filterString)) {
            return null;
        }
        EntityModel entityModel = this._batchEngineTaskItemDelegate.getEntityModel(this._toMultivaluedMap(this._parameters));
        if (entityModel == null) {
            return null;
        }
        FilterParser filterParser = this._filterParserProvider.provide(entityModel);
        com.liferay.portal.odata.filter.Filter oDataFilter = new com.liferay.portal.odata.filter.Filter(filterParser.parse(filterString));
        return (Filter)this._expressionConvert.convert(oDataFilter.getExpression(), LocaleUtil.fromLanguageId((String)this._user.getLanguageId()), entityModel);
    }

    private Map<String, Serializable> _getFilteredParameters() {
        HashMap<String, Serializable> filteredParameters = new HashMap<String, Serializable>(this._parameters);
        filteredParameters.remove("filter");
        filteredParameters.remove("search");
        filteredParameters.remove("sort");
        return filteredParameters;
    }

    private Sort[] _getSorts() throws Exception {
        String sortString = (String)((Object)this._parameters.get("sort"));
        if (Validator.isNull((String)sortString)) {
            return null;
        }
        EntityModel entityModel = this._batchEngineTaskItemDelegate.getEntityModel(this._toMultivaluedMap(this._parameters));
        if (entityModel == null) {
            return null;
        }
        SortParser sortParser = this._sortParserProvider.provide(entityModel);
        if (sortParser == null) {
            return null;
        }
        com.liferay.portal.odata.sort.Sort oDataSort = new com.liferay.portal.odata.sort.Sort(sortParser.parse(sortString));
        List sortFields = oDataSort.getSortFields();
        Sort[] sorts = new Sort[sortFields.size()];
        for (int i = 0; i < sortFields.size(); ++i) {
            SortField sortField = (SortField)sortFields.get(i);
            sorts[i] = new Sort(sortField.getSortableFieldName(LocaleUtil.fromLanguageId((String)this._user.getLanguageId())), !sortField.isAscending());
        }
        return sorts;
    }

    private void _setContextFields(BatchEngineTaskItemDelegate<Object> batchEngineTaskItemDelegate) {
        batchEngineTaskItemDelegate.setContextCompany(this._company);
        BatchEngineUriInfo.Builder builder = new BatchEngineUriInfo.Builder();
        for (Map.Entry<String, Serializable> entry : this._parameters.entrySet()) {
            builder.queryParameter(entry.getKey(), String.valueOf(entry.getValue()));
        }
        batchEngineTaskItemDelegate.setContextUriInfo((UriInfo)builder.build());
        batchEngineTaskItemDelegate.setContextUser(this._user);
        batchEngineTaskItemDelegate.setLanguageId(this._user.getLanguageId());
    }

    private Map<String, List<String>> _toMultivaluedMap(Map<String, Serializable> parameterMap) {
        HashMap<String, List<String>> multivaluedMap = new HashMap<String, List<String>>();
        parameterMap.forEach((key, value) -> multivaluedMap.put((String)key, Collections.singletonList(String.valueOf(value))));
        return multivaluedMap;
    }
}

