/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.internal.util;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.asset.kernel.model.ClassType;
import com.liferay.asset.kernel.model.ClassTypeReader;
import com.liferay.asset.kernel.model.NullClassTypeReader;
import com.liferay.asset.kernel.search.AssetSearcherFactory;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.asset.kernel.service.AssetTagLocalService;
import com.liferay.asset.kernel.service.persistence.AssetEntryQuery;
import com.liferay.asset.util.AssetHelper;
import com.liferay.asset.util.AssetPublisherAddItemHolder;
import com.liferay.dynamic.data.mapping.util.DDMIndexer;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletBag;
import com.liferay.portal.kernel.portlet.PortletBagPool;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.BaseSearcher;
import com.liferay.portal.kernel.search.BooleanClause;
import com.liferay.portal.kernel.search.BooleanClauseFactoryUtil;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchContextFactory;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.SortFactoryUtil;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.hits.SearchHit;
import com.liferay.portal.search.hits.SearchHits;
import com.liferay.portal.search.legacy.searcher.SearchRequestBuilderFactory;
import com.liferay.portal.search.searcher.SearchResponse;
import com.liferay.portal.search.searcher.Searcher;
import com.liferay.portal.search.sort.FieldSort;
import com.liferay.portal.search.sort.SortOrder;
import com.liferay.portal.search.sort.Sorts;
import jakarta.portlet.PortletMode;
import jakarta.portlet.PortletRequest;
import jakarta.portlet.PortletURL;
import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TimeZone;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={AssetHelper.class})
public class AssetHelperImpl
implements AssetHelper {
    private static final Log _log = LogFactoryUtil.getLog(AssetHelperImpl.class);
    @Reference
    private AssetCategoryLocalService _assetCategoryLocalService;
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private AssetSearcherFactory _assetSearcherFactory;
    @Reference
    private AssetTagLocalService _assetTagLocalService;
    @Reference
    private DDMIndexer _ddmIndexer;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private PortletLocalService _portletLocalService;
    @Reference
    private Searcher _searcher;
    @Reference
    private SearchRequestBuilderFactory _searchRequestBuilderFactory;
    @Reference
    private Sorts _sorts;

    public Set<String> addLayoutTags(HttpServletRequest httpServletRequest, List<AssetTag> assetTags) {
        HashSet<String> tagNames = (HashSet<String>)httpServletRequest.getAttribute("ASSET_LAYOUT_TAG_NAMES");
        if (tagNames == null) {
            tagNames = new HashSet<String>();
            httpServletRequest.setAttribute("ASSET_LAYOUT_TAG_NAMES", tagNames);
        }
        for (AssetTag assetTag : assetTags) {
            tagNames.add(assetTag.getName());
        }
        return tagNames;
    }

    public PortletURL getAddPortletURL(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, long groupId, String className, long classTypeId, long[] allAssetCategoryIds, String[] allAssetTagNames, String redirect) throws Exception {
        PortletURL addPortletURL;
        ThemeDisplay themeDisplay = (ThemeDisplay)liferayPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)className);
        if (assetRendererFactory == null || !assetRendererFactory.hasAddPermission(themeDisplay.getPermissionChecker(), groupId, classTypeId)) {
            return null;
        }
        if (groupId > 0L) {
            liferayPortletRequest.setAttribute("ASSET_RENDERER_FACTORY_GROUP", (Object)this._groupLocalService.fetchGroup(groupId));
        }
        if ((addPortletURL = assetRendererFactory.getURLAdd(liferayPortletRequest, liferayPortletResponse, classTypeId)) == null) {
            return null;
        }
        if (redirect != null) {
            addPortletURL.setParameter("redirect", redirect);
        }
        Layout layout = themeDisplay.getLayout();
        addPortletURL.setParameter("backURLTitle", layout.getName(themeDisplay.getLocale()));
        String referringPortletResource = ParamUtil.getString((PortletRequest)liferayPortletRequest, (String)"portletResource");
        if (Validator.isNotNull((String)referringPortletResource)) {
            addPortletURL.setParameter("referringPortletResource", referringPortletResource);
        } else {
            PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
            addPortletURL.setParameter("referringPortletResource", portletDisplay.getId());
            if (allAssetCategoryIds != null) {
                HashMap<Long, Object> assetVocabularyAssetCategoryIds = new HashMap<Long, Object>();
                for (long assetCategoryId : allAssetCategoryIds) {
                    AssetCategory assetCategory = this._assetCategoryLocalService.fetchAssetCategory(assetCategoryId);
                    if (assetCategory == null) continue;
                    long assetVocabularyId = assetCategory.getVocabularyId();
                    if (assetVocabularyAssetCategoryIds.containsKey(assetVocabularyId)) {
                        String assetCategoryIds = (String)assetVocabularyAssetCategoryIds.get(assetVocabularyId);
                        assetVocabularyAssetCategoryIds.put(assetVocabularyId, assetCategoryIds + "," + assetCategoryId);
                        continue;
                    }
                    assetVocabularyAssetCategoryIds.put(assetVocabularyId, String.valueOf(assetCategoryId));
                }
                Object object = assetVocabularyAssetCategoryIds.entrySet().iterator();
                while (object.hasNext()) {
                    Map.Entry entry = (Map.Entry)object.next();
                    long assetVocabularyId = (Long)entry.getKey();
                    String assetCategoryIds = (String)entry.getValue();
                    addPortletURL.setParameter("assetCategoryIds_" + assetVocabularyId, assetCategoryIds);
                }
            }
            if (allAssetTagNames != null) {
                addPortletURL.setParameter("assetTagNames", StringUtil.merge((Object[])allAssetTagNames));
            }
        }
        addPortletURL.setPortletMode(PortletMode.VIEW);
        return addPortletURL;
    }

    public String getAddURLPopUp(long groupId, long plid, PortletURL addPortletURL, boolean addDisplayPageParameter, Layout layout) {
        addPortletURL.setParameter("groupId", String.valueOf(groupId));
        if (addDisplayPageParameter && layout != null) {
            addPortletURL.setParameter("layoutUuid", layout.getUuid());
        }
        if (addPortletURL instanceof LiferayPortletURL) {
            LiferayPortletURL liferayPortletURL = (LiferayPortletURL)addPortletURL;
            liferayPortletURL.setRefererPlid(plid);
            return liferayPortletURL.toString();
        }
        return HttpComponentsUtil.addParameter((String)addPortletURL.toString(), (String)"refererPlid", (long)plid);
    }

    public List<AssetEntry> getAssetEntries(Hits hits) {
        if (hits.getDocs() == null) {
            return Collections.emptyList();
        }
        ArrayList<AssetEntry> assetEntries = new ArrayList<AssetEntry>();
        for (Document document : hits.getDocs()) {
            long classPK;
            String className = GetterUtil.getString((String)document.get("entryClassName"));
            AssetEntry assetEntry = this._assetEntryLocalService.fetchEntry(className, classPK = GetterUtil.getLong((String)document.get("entryClassPK")));
            if (assetEntry == null) continue;
            assetEntries.add(assetEntry);
        }
        return assetEntries;
    }

    public List<AssetEntry> getAssetEntries(SearchHits searchHits) {
        if (searchHits.getTotalHits() <= 0L) {
            return Collections.emptyList();
        }
        ArrayList<AssetEntry> assetEntries = new ArrayList<AssetEntry>();
        for (SearchHit searchHit : searchHits.getSearchHits()) {
            long classPK;
            com.liferay.portal.search.document.Document document = searchHit.getDocument();
            String className = GetterUtil.getString((String)document.getString("entryClassName"));
            AssetEntry assetEntry = this._assetEntryLocalService.fetchEntry(className, classPK = GetterUtil.getLong((String)document.getString("entryClassPK")));
            if (assetEntry == null) continue;
            assetEntries.add(assetEntry);
        }
        return assetEntries;
    }

    public String getAssetKeywords(String className, long classPK) {
        ArrayList keywords = new ArrayList();
        keywords.addAll(ListUtil.toList((List)this._assetTagLocalService.getTags(className, classPK), (Accessor)AssetTag.NAME_ACCESSOR));
        keywords.addAll(ListUtil.toList((List)this._assetCategoryLocalService.getCategories(className, classPK), (Accessor)AssetCategory.NAME_ACCESSOR));
        return StringUtil.merge(keywords);
    }

    public String getAssetKeywords(String className, long classPK, Locale locale) {
        ArrayList keywords = new ArrayList();
        keywords.addAll(ListUtil.toList((List)this._assetTagLocalService.getTags(className, classPK), (Accessor)AssetTag.NAME_ACCESSOR));
        keywords.addAll(ListUtil.toList((List)this._assetCategoryLocalService.getCategories(className, classPK), assetCategory -> assetCategory.getTitle(locale)));
        return StringUtil.merge(keywords);
    }

    public List<AssetPublisherAddItemHolder> getAssetPublisherAddItemHolders(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, long groupId, long[] classNameIds, long[] classTypeIds, long[] allAssetCategoryIds, String[] allAssetTagNames, String redirect) throws Exception {
        ArrayList<AssetPublisherAddItemHolder> assetPublisherAddItemHolders = new ArrayList<AssetPublisherAddItemHolder>();
        ThemeDisplay themeDisplay = (ThemeDisplay)liferayPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Locale locale = themeDisplay.getLocale();
        for (long classNameId : classNameIds) {
            PortletURL addPortletURL;
            PortletBag portletBag;
            Portlet portlet;
            String className = this._portal.getClassName(classNameId);
            AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)className);
            if (assetRendererFactory == null || Validator.isNull((String)assetRendererFactory.getPortletId()) || !(portlet = this._portletLocalService.getPortletById(themeDisplay.getCompanyId(), assetRendererFactory.getPortletId())).isActive() || (portletBag = PortletBagPool.get((String)portlet.getRootPortletId())) == null) continue;
            ResourceBundle resourceBundle = portletBag.getResourceBundle(locale);
            ClassTypeReader classTypeReader = assetRendererFactory.getClassTypeReader();
            List classTypes = Collections.emptyList();
            if (!(classTypeReader instanceof NullClassTypeReader)) {
                classTypes = classTypeReader.getAvailableClassTypes(this._portal.getCurrentAndAncestorSiteGroupIds(groupId), themeDisplay.getLocale());
            }
            if (classTypes.isEmpty() && (addPortletURL = this.getAddPortletURL(liferayPortletRequest, liferayPortletResponse, groupId, className, 0L, allAssetCategoryIds, allAssetTagNames, redirect)) != null) {
                assetPublisherAddItemHolders.add(new AssetPublisherAddItemHolder(portlet.getPortletId(), className, resourceBundle, locale, addPortletURL));
            }
            for (ClassType classType : classTypes) {
                PortletURL addPortletURL2;
                long classTypeId = classType.getClassTypeId();
                if (!ArrayUtil.contains((long[])classTypeIds, (long)classTypeId) && classTypeIds.length != 0 || (addPortletURL2 = this.getAddPortletURL(liferayPortletRequest, liferayPortletResponse, groupId, className, classTypeId, allAssetCategoryIds, allAssetTagNames, redirect)) == null) continue;
                assetPublisherAddItemHolders.add(new AssetPublisherAddItemHolder(portlet.getPortletId(), classType.getName(), resourceBundle, locale, addPortletURL2));
            }
        }
        if (assetPublisherAddItemHolders.size() <= 1) {
            return assetPublisherAddItemHolders;
        }
        assetPublisherAddItemHolders.sort(null);
        return assetPublisherAddItemHolders;
    }

    public boolean isValidWord(String word) {
        char[] wordCharArray;
        if (Validator.isBlank((String)word)) {
            return false;
        }
        for (char c : wordCharArray = word.toCharArray()) {
            for (char invalidChar : AssetHelper.INVALID_CHARACTERS) {
                if (c != invalidChar) continue;
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Word ", word, " is not valid because ", Character.valueOf(c), " is not allowed"}));
                }
                return false;
            }
        }
        return true;
    }

    public Hits search(HttpServletRequest httpServletRequest, AssetEntryQuery assetEntryQuery, int start, int end) throws Exception {
        SearchContext searchContext = SearchContextFactory.getInstance((HttpServletRequest)httpServletRequest);
        return this.search(searchContext, assetEntryQuery, start, end);
    }

    public Hits search(SearchContext searchContext, AssetEntryQuery assetEntryQuery, int start, int end) throws Exception {
        this._prepareSearchContext(searchContext, assetEntryQuery, start, end);
        BaseSearcher baseSearcher = this._assetSearcherFactory.createBaseSearcher(assetEntryQuery);
        return baseSearcher.search(searchContext);
    }

    public SearchHits search(SearchContext searchContext, List<AssetEntryQuery> assetEntryQueries, int start, int end) throws Exception {
        this._prepareSearchContext(assetEntryQueries, end, searchContext, start);
        SearchResponse searchResponse = this._searcher.search(this._searchRequestBuilderFactory.builder(searchContext).emptySearchEnabled(true).fields(new String[]{"entryClassName", "entryClassPK", "uid"}).highlightEnabled(false).sorts(this._getSearchSorts(assetEntryQueries.get(0), searchContext.getLocale())).build());
        return searchResponse.getSearchHits();
    }

    public BaseModelSearchResult<AssetEntry> searchAssetEntries(AssetEntryQuery assetEntryQuery, long[] assetCategoryIds, String[] assetTagNames, Map<String, Serializable> attributes, long companyId, String keywords, Layout layout, Locale locale, long scopeGroupId, TimeZone timeZone, long userId, int start, int end) throws Exception {
        SearchContext searchContext = SearchContextFactory.getInstance((long[])assetCategoryIds, (String[])assetTagNames, attributes, (long)companyId, (String)keywords, (Layout)layout, (Locale)locale, (long)scopeGroupId, (TimeZone)timeZone, (long)userId);
        return this.searchAssetEntries(searchContext, assetEntryQuery, start, end);
    }

    public BaseModelSearchResult<AssetEntry> searchAssetEntries(HttpServletRequest httpServletRequest, AssetEntryQuery assetEntryQuery, int start, int end) throws Exception {
        SearchContext searchContext = SearchContextFactory.getInstance((HttpServletRequest)httpServletRequest);
        return this.searchAssetEntries(searchContext, assetEntryQuery, start, end);
    }

    public BaseModelSearchResult<AssetEntry> searchAssetEntries(SearchContext searchContext, AssetEntryQuery assetEntryQuery, int start, int end) throws Exception {
        this._prepareSearchContext(searchContext, assetEntryQuery, start, end);
        BaseSearcher baseSearcher = this._assetSearcherFactory.createBaseSearcher(assetEntryQuery);
        Hits hits = baseSearcher.search(searchContext);
        return new BaseModelSearchResult(this.getAssetEntries(hits), hits.getLength());
    }

    public long searchCount(SearchContext searchContext, AssetEntryQuery assetEntryQuery) throws Exception {
        this._prepareSearchContext(searchContext, assetEntryQuery, -1, -1);
        BaseSearcher baseSearcher = this._assetSearcherFactory.createBaseSearcher(assetEntryQuery);
        return baseSearcher.searchCount(searchContext);
    }

    public long searchCount(SearchContext searchContext, List<AssetEntryQuery> assetEntryQueries, int start, int end) throws Exception {
        this._prepareSearchContext(assetEntryQueries, end, searchContext, start);
        SearchResponse searchResponse = this._searcher.search(this._searchRequestBuilderFactory.builder(searchContext).emptySearchEnabled(true).highlightEnabled(false).sorts(this._getSearchSorts(assetEntryQueries.get(0), searchContext.getLocale())).build());
        return searchResponse.getCount();
    }

    private String _getOrderByCol(String sortField, Locale locale) {
        if (sortField.equals("modifiedDate")) {
            sortField = "modified";
        } else if (sortField.equals("title")) {
            sortField = Field.getSortableFieldName((String)"localized_title_".concat(LocaleUtil.toLanguageId((Locale)locale)));
        }
        return sortField;
    }

    private com.liferay.portal.search.sort.Sort _getSearchSort(String orderByType, String sortField, Locale locale) throws Exception {
        if (sortField.startsWith("ddm__")) {
            SortOrder sortOrder = SortOrder.ASC;
            if (Validator.isNotNull((String)orderByType) && !StringUtil.equalsIgnoreCase((String)orderByType, (String)"asc")) {
                sortOrder = SortOrder.DESC;
            }
            return this._ddmIndexer.createDDMStructureFieldSort(sortField, locale, sortOrder);
        }
        Sort sort = SortFactoryUtil.getSort(AssetEntry.class, (int)this._getSortType(sortField), (String)this._getOrderByCol(sortField, locale), (boolean)true, (String)orderByType);
        FieldSort fieldSort = this._sorts.field(sort.getFieldName());
        if (sort.isReverse()) {
            fieldSort.setSortOrder(SortOrder.DESC);
        }
        return fieldSort;
    }

    private com.liferay.portal.search.sort.Sort[] _getSearchSorts(AssetEntryQuery assetEntryQuery, Locale locale) throws Exception {
        com.liferay.portal.search.sort.Sort sort1 = this._getSearchSort(assetEntryQuery.getOrderByType1(), assetEntryQuery.getOrderByCol1(), locale);
        com.liferay.portal.search.sort.Sort sort2 = this._getSearchSort(assetEntryQuery.getOrderByType2(), assetEntryQuery.getOrderByCol2(), locale);
        return new com.liferay.portal.search.sort.Sort[]{sort1, sort2};
    }

    private int _getSortType(String fieldType) {
        int sortType = 3;
        if (fieldType.equals("createDate") || fieldType.equals("expirationDate") || fieldType.equals("publishDate") || fieldType.equals("modifiedDate")) {
            sortType = 6;
        } else if (fieldType.equals("priority")) {
            sortType = 7;
        } else if (fieldType.equals("viewCount")) {
            sortType = 4;
        }
        return sortType;
    }

    private void _prepareSearchContext(List<AssetEntryQuery> assetEntryQueries, int end, SearchContext searchContext, int start) throws Exception {
        for (AssetEntryQuery assetEntryQuery : assetEntryQueries) {
            SearchContext assetEntryQuerySearchContext = new SearchContext();
            this._prepareSearchContext(assetEntryQuerySearchContext, assetEntryQuery, start, end);
            long[] groupIds = searchContext.getGroupIds();
            if (ArrayUtil.isEmpty((long[])groupIds)) {
                groupIds = new long[]{};
            }
            searchContext.setGroupIds(ArrayUtil.append((long[][])new long[][]{groupIds, assetEntryQuerySearchContext.getGroupIds()}));
            BaseSearcher baseSearcher = this._assetSearcherFactory.createBaseSearcher(assetEntryQuery);
            BooleanQuery booleanQuery = baseSearcher.getFullQuery(assetEntryQuerySearchContext);
            Object[] booleanClauses = searchContext.getBooleanClauses();
            if (booleanClauses == null) {
                searchContext.setBooleanClauses(new BooleanClause[]{BooleanClauseFactoryUtil.create((Query)booleanQuery, (String)BooleanClauseOccur.SHOULD.getName())});
                continue;
            }
            searchContext.setBooleanClauses((BooleanClause[])ArrayUtil.append((Object[])booleanClauses, (Object)BooleanClauseFactoryUtil.create((Query)booleanQuery, (String)BooleanClauseOccur.SHOULD.getName())));
        }
        searchContext.setEnd(end);
        searchContext.setStart(start);
    }

    private void _prepareSearchContext(SearchContext searchContext, AssetEntryQuery assetEntryQuery, int start, int end) throws Exception {
        String paginationType;
        Layout layout = assetEntryQuery.getLayout();
        if (layout != null) {
            searchContext.setAttribute("layoutUuid", (Serializable)((Object)layout.getUuid()));
        }
        String ddmStructureFieldName = (String)((Object)assetEntryQuery.getAttribute("ddmStructureFieldName"));
        Serializable ddmStructureFieldValue = assetEntryQuery.getAttribute("ddmStructureFieldValue");
        if (Validator.isNotNull((String)ddmStructureFieldName) && Validator.isNotNull((Object)ddmStructureFieldValue)) {
            searchContext.setAttribute("ddmStructureFieldName", (Serializable)((Object)ddmStructureFieldName));
            searchContext.setAttribute("ddmStructureFieldValue", ddmStructureFieldValue);
        }
        if (GetterUtil.getBoolean((Object)assetEntryQuery.getAttribute("headOrShowNonindexable"))) {
            searchContext.setAttribute("headOrShowNonindexable", (Serializable)Boolean.TRUE);
        }
        if (!(paginationType = GetterUtil.getString((String)assetEntryQuery.getPaginationType(), (String)"more")).equals("none") && !paginationType.equals("simple")) {
            searchContext.setAttribute("paginationType", (Serializable)((Object)paginationType));
        }
        if (GetterUtil.getBoolean((Object)assetEntryQuery.getAttribute("showNonindexable"))) {
            searchContext.setAttribute("showNonindexable", (Serializable)Boolean.TRUE);
        }
        searchContext.setClassTypeIds(assetEntryQuery.getClassTypeIds());
        searchContext.setEnd(end);
        searchContext.setGroupIds(ArrayUtil.clone((long[])assetEntryQuery.getGroupIds()));
        searchContext.setIncludeInternalAssetCategories(true);
        if (Validator.isNull((String)assetEntryQuery.getKeywords())) {
            QueryConfig queryConfig = searchContext.getQueryConfig();
            queryConfig.setScoreEnabled(false);
        } else {
            searchContext.setLike(true);
        }
        this._searchRequestBuilderFactory.builder(searchContext).emptySearchEnabled(true).sorts(this._getSearchSorts(assetEntryQuery, searchContext.getLocale()));
        searchContext.setStart(start);
    }
}

