/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.internal.service;

import com.liferay.asset.category.property.model.AssetCategoryPropertyTable;
import com.liferay.asset.entry.rel.model.AssetEntryAssetCategoryRelTable;
import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetCategoryTable;
import com.liferay.asset.kernel.model.AssetEntryTable;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.petra.sql.dsl.Column;
import com.liferay.petra.sql.dsl.DSLFunctionFactoryUtil;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.sql.dsl.query.GroupByStep;
import com.liferay.petra.sql.dsl.query.JoinStep;
import com.liferay.portal.dao.orm.custom.sql.CustomSQL;
import com.liferay.portal.kernel.security.permission.InlineSQLHelperUtil;
import com.liferay.portal.kernel.service.ServiceWrapper;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ServiceWrapper.class})
public class AssetCategoryLocalServiceWrapper
extends com.liferay.asset.kernel.service.AssetCategoryLocalServiceWrapper {
    @Reference
    private AssetCategoryLocalService _assetCategoryLocalService;
    @Reference
    private CustomSQL _customSQL;

    public List<AssetCategory> getCategories(long classNameId, long classPK, int start, int end) {
        JoinStep joinStep = DSLQueryFactoryUtil.select((Table)AssetCategoryTable.INSTANCE).from((Table)AssetEntryTable.INSTANCE);
        return (List)this._assetCategoryLocalService.dslQuery(this._getGroupByStep(classNameId, classPK, joinStep).limit(start, end));
    }

    public int getCategoriesCount(long classNameId, long classPK) {
        JoinStep joinStep = DSLQueryFactoryUtil.count().from((Table)AssetEntryTable.INSTANCE);
        return this._assetCategoryLocalService.dslQueryCount((DSLQuery)this._getGroupByStep(classNameId, classPK, joinStep));
    }

    public List<AssetCategory> search(long groupId, String name, String[] categoryProperties, int start, int end) {
        JoinStep joinStep = DSLQueryFactoryUtil.select((Table)AssetCategoryTable.INSTANCE).from((Table)AssetCategoryTable.INSTANCE);
        if (ArrayUtil.isNotEmpty((Object[])categoryProperties)) {
            for (int i = 0; i < categoryProperties.length; ++i) {
                AssetCategoryPropertyTable assetCategoryPropertyTableAlias = (AssetCategoryPropertyTable)AssetCategoryPropertyTable.INSTANCE.as("assetCategoryProperty" + i);
                String categoryProperty = categoryProperties[i];
                Predicate predicate = assetCategoryPropertyTableAlias.categoryId.eq((Expression)AssetCategoryTable.INSTANCE.categoryId);
                String[] categoryPropertyArray = StringUtil.split((String)categoryProperty, (String)"_KEY_VALUE_");
                if (categoryPropertyArray.length <= 1) {
                    categoryPropertyArray = StringUtil.split((String)categoryProperty, (char)':');
                }
                String key = "";
                if (categoryPropertyArray.length > 0) {
                    key = GetterUtil.getString((String)categoryPropertyArray[0]);
                }
                String value = "";
                if (categoryPropertyArray.length > 1) {
                    value = GetterUtil.getString((String)categoryPropertyArray[1]);
                }
                predicate = predicate.and((Expression)Predicate.withParentheses((Predicate)Predicate.and((Predicate)assetCategoryPropertyTableAlias.key.eq((Object)key), (Predicate)assetCategoryPropertyTableAlias.value.eq((Object)value))));
                joinStep = joinStep.innerJoinON((Table)assetCategoryPropertyTableAlias, predicate);
            }
        }
        return (List)this._assetCategoryLocalService.dslQuery(joinStep.where(() -> {
            Predicate predicate = AssetCategoryTable.INSTANCE.groupId.eq((Object)groupId);
            if (Validator.isNotNull((String)name)) {
                return Predicate.withParentheses((Predicate)predicate.and((Expression)this._customSQL.getKeywordsPredicate(DSLFunctionFactoryUtil.lower((Expression)AssetCategoryTable.INSTANCE.name), this._customSQL.keywords(name, true))));
            }
            return predicate;
        }).limit(start, end));
    }

    private GroupByStep _getGroupByStep(long classNameId, long classPK, JoinStep joinStep) {
        return joinStep.innerJoinON((Table)AssetEntryAssetCategoryRelTable.INSTANCE, AssetEntryAssetCategoryRelTable.INSTANCE.assetEntryId.eq((Expression)AssetEntryTable.INSTANCE.entryId)).innerJoinON((Table)AssetCategoryTable.INSTANCE, AssetCategoryTable.INSTANCE.categoryId.eq((Expression)AssetEntryAssetCategoryRelTable.INSTANCE.assetCategoryId)).where(AssetEntryTable.INSTANCE.classNameId.eq((Object)classNameId).and((Expression)AssetEntryTable.INSTANCE.classPK.eq((Object)classPK)).and((Expression)InlineSQLHelperUtil.getPermissionWherePredicate(AssetCategory.class, (Column)AssetCategoryTable.INSTANCE.categoryId, (long[])new long[0])));
    }
}

