/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.internal.info.renderer;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.info.item.renderer.InfoItemRenderer;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;

public abstract class BaseAssetEntryInfoItemRenderer
implements InfoItemRenderer<AssetEntry> {
    public void render(AssetEntry assetEntry, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        try {
            AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)assetEntry.getClassName());
            httpServletRequest.setAttribute("ASSET_RENDERER_FACTORY", (Object)assetRendererFactory);
            AssetRenderer assetRenderer = assetRendererFactory.getAssetRenderer(assetEntry.getClassPK());
            httpServletRequest.setAttribute("ASSET_RENDERER", (Object)assetRenderer);
            assetRenderer.include(httpServletRequest, httpServletResponse, this.getTemplate());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    protected abstract String getTemplate();
}

