/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.internal.info.collection.provider;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.search.AssetSearcherFactory;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.asset.kernel.service.persistence.AssetEntryQuery;
import com.liferay.asset.util.AssetHelper;
import com.liferay.asset.util.comparator.AssetRendererFactoryTypeNameComparator;
import com.liferay.info.collection.provider.CollectionQuery;
import com.liferay.info.collection.provider.ConfigurableInfoCollectionProvider;
import com.liferay.info.collection.provider.RelatedInfoItemCollectionProvider;
import com.liferay.info.field.InfoField;
import com.liferay.info.field.InfoFieldSet;
import com.liferay.info.field.InfoFieldSetEntry;
import com.liferay.info.field.type.CategoriesInfoFieldType;
import com.liferay.info.field.type.InfoFieldType;
import com.liferay.info.field.type.MultiselectInfoFieldType;
import com.liferay.info.field.type.OptionInfoFieldType;
import com.liferay.info.field.type.SelectInfoFieldType;
import com.liferay.info.form.InfoForm;
import com.liferay.info.localized.InfoLocalizedValue;
import com.liferay.info.localized.bundle.ModelResourceLocalizedValue;
import com.liferay.info.localized.bundle.ResourceBundleInfoLocalizedValue;
import com.liferay.info.pagination.InfoPage;
import com.liferay.info.pagination.Pagination;
import com.liferay.item.selector.ItemSelector;
import com.liferay.item.selector.ItemSelectorCriterion;
import com.liferay.item.selector.ItemSelectorReturnType;
import com.liferay.item.selector.criteria.InfoItemItemSelectorReturnType;
import com.liferay.item.selector.criteria.info.item.criterion.InfoItemItemSelectorCriterion;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.RequestBackedPortletURLFactoryUtil;
import com.liferay.portal.kernel.portlet.url.builder.PortletURLBuilder;
import com.liferay.portal.kernel.search.BaseSearcher;
import com.liferay.portal.kernel.search.BooleanClause;
import com.liferay.portal.kernel.search.BooleanClauseFactoryUtil;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchContextFactory;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermsFilter;
import com.liferay.portal.kernel.search.generic.BooleanQueryImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.KeyValuePair;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.kernel.util.Validator;
import jakarta.portlet.PortletURL;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"item.class.name=com.liferay.asset.kernel.model.AssetEntry"}, service={RelatedInfoItemCollectionProvider.class})
public class AssetEntriesWithSameAssetCategoryRelatedInfoItemCollectionProvider
implements ConfigurableInfoCollectionProvider<AssetEntry>,
RelatedInfoItemCollectionProvider<AssetEntry, AssetEntry> {
    private static final Log _log = LogFactoryUtil.getLog(AssetEntriesWithSameAssetCategoryRelatedInfoItemCollectionProvider.class);
    @Reference
    private AssetCategoryLocalService _assetCategoryLocalService;
    @Reference
    private AssetHelper _assetHelper;
    @Reference
    private AssetSearcherFactory _assetSearcherFactory;
    @Reference
    private ItemSelector _itemSelector;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Language _language;
    @Reference
    private Portal _portal;

    public InfoPage<AssetEntry> getCollectionInfoPage(CollectionQuery collectionQuery) {
        Object relatedItem = collectionQuery.getRelatedItem();
        if (!(relatedItem instanceof AssetEntry)) {
            return InfoPage.of(Collections.emptyList(), (Pagination)collectionQuery.getPagination(), (int)0);
        }
        AssetEntry assetEntry = (AssetEntry)relatedItem;
        if (ArrayUtil.isEmpty((long[])assetEntry.getCategoryIds())) {
            return InfoPage.of(Collections.emptyList(), (Pagination)collectionQuery.getPagination(), (int)0);
        }
        SearchContext searchContext = this._getSearchContext();
        try {
            BooleanFilter assetCategoryIdsBooleanFilter = this._getAssetCategoryIdsBooleanFilter(assetEntry, collectionQuery, searchContext);
            if (!assetCategoryIdsBooleanFilter.hasClauses()) {
                return InfoPage.of(Collections.emptyList(), (Pagination)collectionQuery.getPagination(), (int)0);
            }
            BooleanQueryImpl booleanQueryImpl = new BooleanQueryImpl();
            booleanQueryImpl.setPreBooleanFilter(assetCategoryIdsBooleanFilter);
            searchContext.setBooleanClauses(new BooleanClause[]{this._getAssetEntryIdBooleanClause(assetEntry), BooleanClauseFactoryUtil.create((Query)booleanQueryImpl, (String)BooleanClauseOccur.MUST.getName())});
            AssetEntryQuery assetEntryQuery = this._getAssetEntryQuery(collectionQuery);
            Hits hits = this._assetHelper.search(searchContext, assetEntryQuery, assetEntryQuery.getStart(), assetEntryQuery.getEnd());
            Long count = this._assetHelper.searchCount(searchContext, assetEntryQuery);
            return InfoPage.of((List)this._assetHelper.getAssetEntries(hits), (Pagination)collectionQuery.getPagination(), (int)count.intValue());
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to get asset entries", (Throwable)exception);
            return InfoPage.of(Collections.emptyList(), (Pagination)collectionQuery.getPagination(), (int)0);
        }
    }

    public String getCollectionItemClassName() {
        return AssetEntry.class.getName();
    }

    public InfoForm getConfigurationInfoForm() {
        return InfoForm.builder().infoFieldSetEntry(InfoFieldSet.builder().infoFieldSetEntry((InfoFieldSetEntry)this._getItemTypesInfoField()).descriptionInfoLocalizedValue(InfoLocalizedValue.localize(this.getClass(), (String)"by-filtering,-you-can-narrow-down-the-results-that-appear-on-the-page")).labelInfoLocalizedValue(InfoLocalizedValue.localize(this.getClass(), (String)"filter")).name("filter").build()).infoFieldSetEntry(InfoFieldSet.builder().infoFieldSetEntry((InfoFieldSetEntry)InfoField.builder().infoFieldType((InfoFieldType)SelectInfoFieldType.INSTANCE).namespace("").name("assetCategoryRule").attribute(SelectInfoFieldType.INLINE, (Object)true).attribute(SelectInfoFieldType.OPTIONS, (Object)ListUtil.fromArray((Object[])new OptionInfoFieldType[]{new OptionInfoFieldType(true, (InfoLocalizedValue)new ResourceBundleInfoLocalizedValue(this.getClass(), "not-selected"), ""), new OptionInfoFieldType((InfoLocalizedValue)new ResourceBundleInfoLocalizedValue(this.getClass(), "any-category-of-the-same-vocabulary"), "anyAssetCategoryOfTheSameAssetVocabulary"), new OptionInfoFieldType((InfoLocalizedValue)new ResourceBundleInfoLocalizedValue(this.getClass(), "a-specific-category"), "specificAssetCategory")})).labelInfoLocalizedValue(InfoLocalizedValue.localize(this.getClass(), (String)"and-contains")).localizable(true).build()).infoFieldSetEntry((InfoFieldSetEntry)InfoField.builder().infoFieldType((InfoFieldType)CategoriesInfoFieldType.INSTANCE).namespace("").name("specificAssetCategoryJSONObject").attribute(CategoriesInfoFieldType.DEPENDENCY, (Object)new KeyValuePair("assetCategoryRule", "specificAssetCategory")).attribute(CategoriesInfoFieldType.INFO_ITEM_SELECTOR_URL, (Object)this._getItemSelectorURL()).labelInfoLocalizedValue(InfoLocalizedValue.localize(this.getClass(), (String)"category")).localizable(false).build()).descriptionInfoLocalizedValue(InfoLocalizedValue.localize(this.getClass(), (String)"you-can-also-add-a-rule-for-more-accurate-results")).labelInfoLocalizedValue(InfoLocalizedValue.localize(this.getClass(), (String)"advanced-rule")).name("advanced-rule").build()).build();
    }

    public String getLabel(Locale locale) {
        return this._language.get(locale, "items-with-same-categories");
    }

    public Class<?> getSourceItemClass() {
        return AssetEntry.class;
    }

    private BooleanFilter _getAnyAssetCategoryOfTheSameAssetVocabularyBooleanFilter(AssetEntry assetEntry, SearchContext searchContext) throws Exception {
        HashMap<Long, List> assetEntryAssetVocabulariesMap = new HashMap<Long, List>();
        HashMap<Long, List> otherAssetCategoriesAssetVocabulariesMap = new HashMap<Long, List>();
        for (long assetEntryAssetCategoryId : assetEntry.getCategoryIds()) {
            AssetCategory assetCategory = this._assetCategoryLocalService.fetchAssetCategory(assetEntryAssetCategoryId);
            if (assetCategory == null) continue;
            List assetCategoryIds = assetEntryAssetVocabulariesMap.computeIfAbsent(assetCategory.getVocabularyId(), key -> new ArrayList());
            assetCategoryIds.add(assetEntryAssetCategoryId);
            if (otherAssetCategoriesAssetVocabulariesMap.containsKey(assetCategory.getVocabularyId())) continue;
            otherAssetCategoriesAssetVocabulariesMap.put(assetCategory.getVocabularyId(), ListUtil.filter((List)ListUtil.toList((List)this._assetCategoryLocalService.getVocabularyCategories(assetCategory.getVocabularyId(), -1, -1, null), (Accessor)AssetCategory.CATEGORY_ID_ACCESSOR), categoryId -> !ArrayUtil.contains((long[])assetEntry.getCategoryIds(), (long)categoryId)));
        }
        ArrayList<BooleanFilter> booleanFilters = new ArrayList<BooleanFilter>();
        for (Map.Entry entry : assetEntryAssetVocabulariesMap.entrySet()) {
            Long assetVocabularyId = (Long)entry.getKey();
            List otherAssetCategoryIds = (List)otherAssetCategoriesAssetVocabulariesMap.get(assetVocabularyId);
            if (ListUtil.isEmpty((List)otherAssetCategoryIds)) continue;
            Iterator iterator = ((List)entry.getValue()).iterator();
            while (iterator.hasNext()) {
                long assetCategoryId = (Long)iterator.next();
                booleanFilters.add(this._getAssetSearcherPreBooleanFilter(new long[]{assetCategoryId}, ArrayUtil.toLongArray((Collection)otherAssetCategoryIds), searchContext));
            }
        }
        BooleanFilter assetCategoryIdsBooleanFilter = new BooleanFilter();
        for (BooleanFilter booleanFilter : booleanFilters) {
            assetCategoryIdsBooleanFilter.add((Filter)booleanFilter, BooleanClauseOccur.SHOULD);
        }
        return assetCategoryIdsBooleanFilter;
    }

    private BooleanFilter _getAssetCategoryIdsBooleanFilter(AssetEntry assetEntry, CollectionQuery collectionQuery, SearchContext searchContext) throws Exception {
        Tuple assetCategoryRuleTuple = this._getAssetCategoryRuleTuple(collectionQuery);
        if (assetCategoryRuleTuple.getSize() == 1 && Objects.equals(assetCategoryRuleTuple.getObject(0), "anyAssetCategoryOfTheSameAssetVocabulary")) {
            return this._getAnyAssetCategoryOfTheSameAssetVocabularyBooleanFilter(assetEntry, searchContext);
        }
        if (assetCategoryRuleTuple.getSize() == 2 && Objects.equals(assetCategoryRuleTuple.getObject(0), "specificAssetCategory")) {
            return this._getAssetSearcherPreBooleanFilter(new long[]{GetterUtil.getLong((Object)assetCategoryRuleTuple.getObject(1))}, assetEntry.getCategoryIds(), searchContext);
        }
        return this._getAssetSearcherPreBooleanFilter(new long[0], assetEntry.getCategoryIds(), searchContext);
    }

    private Tuple _getAssetCategoryRuleTuple(CollectionQuery collectionQuery) {
        Map configuration = collectionQuery.getConfiguration();
        if (configuration == null || ArrayUtil.isEmpty((Object[])((Object[])configuration.get("assetCategoryRule")))) {
            return new Tuple(new Object[0]);
        }
        String[] assetCategoryRules = (String[])configuration.get("assetCategoryRule");
        String assetCategoryRule = assetCategoryRules[0];
        if (Objects.equals(assetCategoryRule, "specificAssetCategory") && ArrayUtil.isNotEmpty((Object[])((Object[])configuration.get("specificAssetCategoryJSONObject")))) {
            String[] specificAssetCategoryJSONObjects = (String[])configuration.get("specificAssetCategoryJSONObject");
            JSONObject specificAssetCategoryJSONObject = null;
            try {
                specificAssetCategoryJSONObject = this._jsonFactory.createJSONObject(specificAssetCategoryJSONObjects[0]);
            }
            catch (JSONException jsonException) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)jsonException);
                }
                return new Tuple(new Object[0]);
            }
            long specificAssetCategoryId = specificAssetCategoryJSONObject.getLong("classPK");
            if (specificAssetCategoryId <= 0L) {
                return new Tuple(new Object[0]);
            }
            AssetCategory assetCategory = this._assetCategoryLocalService.fetchAssetCategory(specificAssetCategoryId);
            if (assetCategory == null) {
                return new Tuple(new Object[0]);
            }
            return new Tuple(new Object[]{"specificAssetCategory", specificAssetCategoryId});
        }
        if (Objects.equals(assetCategoryRule, "anyAssetCategoryOfTheSameAssetVocabulary")) {
            return new Tuple(new Object[]{assetCategoryRule});
        }
        return new Tuple(new Object[0]);
    }

    private BooleanClause<Query> _getAssetEntryIdBooleanClause(AssetEntry assetEntry) {
        BooleanQueryImpl booleanQueryImpl = new BooleanQueryImpl();
        BooleanFilter assetEntryIdBooleanFilter = new BooleanFilter();
        TermsFilter assetEntryIdTermsFilter = new TermsFilter("assetEntryId");
        assetEntryIdTermsFilter.addValue(String.valueOf(assetEntry.getEntryId()));
        assetEntryIdBooleanFilter.add((Filter)assetEntryIdTermsFilter, BooleanClauseOccur.MUST_NOT);
        booleanQueryImpl.setPreBooleanFilter(assetEntryIdBooleanFilter);
        return BooleanClauseFactoryUtil.create((Query)booleanQueryImpl, (String)BooleanClauseOccur.MUST.getName());
    }

    private AssetEntryQuery _getAssetEntryQuery(CollectionQuery collectionQuery) {
        AssetEntryQuery assetEntryQuery = new AssetEntryQuery();
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        assetEntryQuery.setClassNameIds(this._getClassNameIds(collectionQuery));
        assetEntryQuery.setEnablePermissions(true);
        Pagination pagination = collectionQuery.getPagination();
        if (pagination != null) {
            assetEntryQuery.setEnd(pagination.getEnd());
        }
        assetEntryQuery.setGroupIds(new long[]{serviceContext.getScopeGroupId()});
        assetEntryQuery.setOrderByCol1("modified");
        assetEntryQuery.setOrderByType1("DESC");
        if (pagination != null) {
            assetEntryQuery.setStart(pagination.getStart());
        }
        return assetEntryQuery;
    }

    private BooleanFilter _getAssetSearcherPreBooleanFilter(long[] allCategoryIds, long[] anyCategoryIds, SearchContext searchContext) throws Exception {
        AssetEntryQuery assetEntryQuery = new AssetEntryQuery();
        assetEntryQuery.setAllCategoryIds(allCategoryIds);
        assetEntryQuery.setAnyCategoryIds(anyCategoryIds);
        BaseSearcher baseSearcher = this._assetSearcherFactory.createBaseSearcher(assetEntryQuery);
        BooleanQuery booleanQuery = baseSearcher.getFullQuery(searchContext);
        return booleanQuery.getPreBooleanFilter();
    }

    private long[] _getClassNameIds(CollectionQuery collectionQuery) {
        Map configuration = collectionQuery.getConfiguration();
        if (MapUtil.isNotEmpty((Map)configuration) && ArrayUtil.isNotEmpty((Object[])((Object[])configuration.get("item_types")))) {
            String[] itemTypes;
            ArrayList<Long> classNameIds = new ArrayList<Long>();
            for (String itemType : itemTypes = (String[])configuration.get("item_types")) {
                if (!Validator.isNotNull((String)itemType)) continue;
                classNameIds.add(this._portal.getClassNameId(itemType));
            }
            if (ListUtil.isNotEmpty(classNameIds)) {
                return ArrayUtil.toArray((Long[])classNameIds.toArray(new Long[0]));
            }
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        return AssetRendererFactoryRegistryUtil.getIndexableClassNameIds((long)serviceContext.getCompanyId(), (boolean)true);
    }

    private String _getItemSelectorURL() {
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext == null) {
            return null;
        }
        HttpServletRequest httpServletRequest = serviceContext.getRequest();
        if (httpServletRequest == null) {
            return null;
        }
        InfoItemItemSelectorCriterion itemSelectorCriterion = new InfoItemItemSelectorCriterion();
        itemSelectorCriterion.setDesiredItemSelectorReturnTypes(new ItemSelectorReturnType[]{new InfoItemItemSelectorReturnType()});
        itemSelectorCriterion.setItemType(AssetCategory.class.getName());
        String namespace = "";
        LiferayPortletResponse liferayPortletResponse = serviceContext.getLiferayPortletResponse();
        if (liferayPortletResponse != null) {
            namespace = liferayPortletResponse.getNamespace();
        }
        return PortletURLBuilder.create((PortletURL)this._itemSelector.getItemSelectorURL(RequestBackedPortletURLFactoryUtil.create((HttpServletRequest)httpServletRequest), namespace + "selectInfoItem", new ItemSelectorCriterion[]{itemSelectorCriterion})).buildString();
    }

    private InfoField _getItemTypesInfoField() {
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        List assetRendererFactories = ListUtil.filter((List)AssetRendererFactoryRegistryUtil.getAssetRendererFactories((long)serviceContext.getCompanyId(), (boolean)true), assetRendererFactory -> {
            if (!assetRendererFactory.isCategorizable()) {
                return false;
            }
            Indexer indexer = IndexerRegistryUtil.getIndexer((String)this._portal.getClassName(assetRendererFactory.getClassNameId()));
            return indexer != null;
        });
        assetRendererFactories.sort(new AssetRendererFactoryTypeNameComparator(serviceContext.getLocale()));
        InfoField.FinalStep finalStep = InfoField.builder().infoFieldType((InfoFieldType)MultiselectInfoFieldType.INSTANCE).namespace("").name("item_types").attribute(MultiselectInfoFieldType.OPTIONS, (Object)TransformUtil.transform((Collection)assetRendererFactories, assetRendererFactory -> new OptionInfoFieldType((InfoLocalizedValue)new ModelResourceLocalizedValue(assetRendererFactory.getClassName()), assetRendererFactory.getClassName()))).labelInfoLocalizedValue(InfoLocalizedValue.localize(this.getClass(), (String)"item-type")).localizable(true);
        return finalStep.build();
    }

    private SearchContext _getSearchContext() {
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        ThemeDisplay themeDisplay = serviceContext.getThemeDisplay();
        return SearchContextFactory.getInstance((long[])new long[0], (String[])new String[0], (Map)HashMapBuilder.put((Object)"status", (Object)0).put((Object)"head", (Object)true).build(), (long)serviceContext.getCompanyId(), null, (Layout)themeDisplay.getLayout(), null, (long)serviceContext.getScopeGroupId(), null, (long)serviceContext.getUserId());
    }
}

