/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.link.service.impl;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetEntryTable;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.asset.link.constants.AssetLinkConstants;
import com.liferay.asset.link.exception.NoSuchLinkException;
import com.liferay.asset.link.model.AssetLink;
import com.liferay.asset.link.model.AssetLinkModel;
import com.liferay.asset.link.model.AssetLinkTable;
import com.liferay.asset.link.model.adapter.StagedAssetLink;
import com.liferay.asset.link.service.base.AssetLinkLocalServiceBaseImpl;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.sql.dsl.query.GroupByStep;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.mass.delete.MassDeleteCacheThreadLocal;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.SystemEventLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.model.adapter.util.ModelAdapterUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.asset.link.model.AssetLink"}, service={AopService.class})
public class AssetLinkLocalServiceImpl
extends AssetLinkLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(AssetLinkLocalServiceImpl.class);
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private SystemEventLocalService _systemEventLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public AssetLink addLink(long userId, long entryId1, long entryId2, int type, int weight) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        Date date = new Date();
        long linkId1 = this.counterLocalService.increment();
        AssetLink link1 = this.assetLinkPersistence.create(linkId1);
        link1.setCompanyId(user.getCompanyId());
        link1.setUserId(user.getUserId());
        link1.setUserName(user.getFullName());
        link1.setCreateDate(date);
        link1.setEntryId1(entryId1);
        link1.setEntryId2(entryId2);
        link1.setType(type);
        link1.setWeight(weight);
        link1 = (AssetLink)this.assetLinkPersistence.update((BaseModel)link1);
        if (AssetLinkConstants.isTypeBi((int)type)) {
            long linkId2 = this.counterLocalService.increment();
            AssetLink link2 = this.assetLinkPersistence.create(linkId2);
            link2.setCompanyId(user.getCompanyId());
            link2.setUserId(user.getUserId());
            link2.setUserName(user.getFullName());
            link2.setCreateDate(date);
            link2.setEntryId1(entryId2);
            link2.setEntryId2(entryId1);
            link2.setType(type);
            link2.setWeight(weight);
            this.assetLinkPersistence.update((BaseModel)link2);
        }
        return link1;
    }

    @Override
    public AssetLink deleteAssetLink(AssetLink assetLink) {
        AssetLink deletedAssetLink = super.deleteAssetLink(assetLink);
        this._addDeletionSystemEvent(assetLink);
        return deletedAssetLink;
    }

    @Override
    public AssetLink deleteAssetLink(long linkId) throws PortalException {
        AssetLink assetLink = super.deleteAssetLink(linkId);
        this._addDeletionSystemEvent(assetLink);
        return assetLink;
    }

    public void deleteGroupLinks(long groupId) {
        for (AssetLink assetLink : this.getLinks(groupId, null, null, -1, -1)) {
            this.deleteAssetLink(assetLink);
        }
    }

    public void deleteLink(AssetLink link) {
        block3: {
            if (AssetLinkConstants.isTypeBi((int)link.getType())) {
                try {
                    AssetLink assetLink = this.assetLinkPersistence.findByE_E_T(link.getEntryId2(), link.getEntryId1(), link.getType());
                    this.deleteAssetLink(assetLink);
                }
                catch (NoSuchLinkException noSuchLinkException) {
                    if (!_log.isWarnEnabled()) break block3;
                    _log.warn((Object)"Unable to delete asset link", (Throwable)noSuchLinkException);
                }
            }
        }
        this.assetLinkPersistence.remove((BaseModel)link);
        this._addDeletionSystemEvent(link);
    }

    public void deleteLink(long linkId) throws PortalException {
        AssetLink link = this.assetLinkPersistence.findByPrimaryKey(linkId);
        this.deleteLink(link);
    }

    public void deleteLinks(long entryId) {
        Map leftPartitionAssetLinks = (Map)MassDeleteCacheThreadLocal.getMassDeleteCache((String)StringBundler.concat((Object[])new Object[]{AssetLinkLocalServiceImpl.class.getName(), ".deleteLinks#left#", entryId}), () -> MapUtil.toPartitionMap((List)this.assetLinkPersistence.findAll(), AssetLinkModel::getEntryId1));
        if (leftPartitionAssetLinks == null) {
            for (AssetLink link : this.assetLinkPersistence.findByEntryId1(entryId)) {
                this.deleteLink(link);
            }
            for (AssetLink link : this.assetLinkPersistence.findByEntryId2(entryId)) {
                this.deleteLink(link);
            }
            return;
        }
        HashSet<AssetLink> deletedAssetLinks = new HashSet<AssetLink>();
        List leftAssetLinks = (List)leftPartitionAssetLinks.remove(entryId);
        ListUtil.isNotEmptyForEach((List)leftAssetLinks, leftAssetLink -> {
            this.assetLinkPersistence.remove((BaseModel)leftAssetLink);
            deletedAssetLinks.add((AssetLink)leftAssetLink);
        });
        Map rightPartitionAssetLinks = (Map)MassDeleteCacheThreadLocal.getMassDeleteCache((String)StringBundler.concat((Object[])new Object[]{AssetLinkLocalServiceImpl.class.getName(), ".deleteLinks#right#", entryId}), () -> MapUtil.toPartitionMap((List)this.assetLinkPersistence.findAll(), AssetLinkModel::getEntryId2));
        List rightAssetLinks = (List)rightPartitionAssetLinks.remove(entryId);
        if (rightAssetLinks != null) {
            for (AssetLink rightAssetLink : rightAssetLinks) {
                if (!deletedAssetLinks.add(rightAssetLink)) continue;
                this.assetLinkPersistence.remove((BaseModel)rightAssetLink);
            }
        }
        for (AssetLink deletedAssetLink : deletedAssetLinks) {
            leftPartitionAssetLinks.computeIfPresent(deletedAssetLink.getEntryId1(), (key, assetLinks) -> {
                assetLinks.remove(deletedAssetLink);
                if (assetLinks.isEmpty()) {
                    return null;
                }
                return assetLinks;
            });
            rightPartitionAssetLinks.computeIfPresent(deletedAssetLink.getEntryId2(), (key, assetLinks) -> {
                assetLinks.remove(deletedAssetLink);
                if (assetLinks.isEmpty()) {
                    return null;
                }
                return assetLinks;
            });
        }
    }

    public void deleteLinks(long entryId1, long entryId2) {
        List links = this.assetLinkPersistence.findByE_E(entryId1, entryId2);
        for (AssetLink link : links) {
            this.deleteLink(link);
        }
    }

    public List<AssetLink> getDirectLinks(long entryId) {
        return this.getDirectLinks(entryId, true);
    }

    public List<AssetLink> getDirectLinks(long entryId, boolean excludeInvisibleLinks) {
        List assetLinks = this.assetLinkPersistence.findByEntryId1(entryId);
        return this._filterAssetLinks(assetLinks, excludeInvisibleLinks);
    }

    public List<AssetLink> getDirectLinks(long entryId, int typeId) {
        return this.getDirectLinks(entryId, typeId, true);
    }

    public List<AssetLink> getDirectLinks(long entryId, int typeId, boolean excludeInvisibleLinks) {
        List assetLinks = this.assetLinkPersistence.findByE1_T(entryId, typeId);
        return this._filterAssetLinks(assetLinks, excludeInvisibleLinks);
    }

    public List<AssetLink> getLinks(long entryId) {
        List e1AssetLinks = this.assetLinkPersistence.findByEntryId1(entryId);
        List e2AssetLinks = this.assetLinkPersistence.findByEntryId2(entryId);
        ArrayList<AssetLink> assetLinks = new ArrayList<AssetLink>(e1AssetLinks.size() + e2AssetLinks.size());
        assetLinks.addAll(e1AssetLinks);
        assetLinks.addAll(e2AssetLinks);
        return assetLinks;
    }

    public List<AssetLink> getLinks(long groupId, Date startDate, Date endDate, int start, int end) {
        GroupByStep dslQuery = DSLQueryFactoryUtil.select((Expression[])new Expression[]{AssetEntryTable.INSTANCE.entryId}).from((Table)AssetEntryTable.INSTANCE).where(AssetEntryTable.INSTANCE.groupId.eq((Object)groupId).and(() -> {
            if (startDate == null && endDate == null) {
                return null;
            }
            if (startDate != null && endDate == null) {
                return AssetLinkTable.INSTANCE.createDate.gt((Object)startDate);
            }
            if (startDate == null) {
                return AssetLinkTable.INSTANCE.createDate.lt((Object)startDate);
            }
            return AssetLinkTable.INSTANCE.createDate.gt((Object)startDate).and((Expression)AssetLinkTable.INSTANCE.createDate.lt((Object)startDate));
        }));
        return (List)this.assetLinkPersistence.dslQuery(DSLQueryFactoryUtil.select((Table)AssetLinkTable.INSTANCE).from((Table)AssetLinkTable.INSTANCE).where(AssetLinkTable.INSTANCE.entryId1.in((DSLQuery)dslQuery).or((Expression)AssetLinkTable.INSTANCE.entryId2.in((DSLQuery)dslQuery))).limit(start, end));
    }

    public List<AssetLink> getLinks(long entryId, int typeId) {
        List e1AssetLinks = this.assetLinkPersistence.findByE1_T(entryId, typeId);
        List e2AssetLinks = this.assetLinkPersistence.findByE2_T(entryId, typeId);
        ArrayList<AssetLink> assetLinks = new ArrayList<AssetLink>(e1AssetLinks.size() + e2AssetLinks.size());
        assetLinks.addAll(e1AssetLinks);
        assetLinks.addAll(e2AssetLinks);
        return assetLinks;
    }

    public List<AssetLink> getLinks(long classNameId, long classPK) {
        AssetEntry assetEntry = this._assetEntryLocalService.fetchEntry(classNameId, classPK);
        if (assetEntry == null) {
            return Collections.emptyList();
        }
        return (List)this.assetLinkPersistence.dslQuery((DSLQuery)DSLQueryFactoryUtil.select((Table)AssetLinkTable.INSTANCE).from((Table)AssetLinkTable.INSTANCE).where(AssetLinkTable.INSTANCE.entryId1.eq((Object)assetEntry.getEntryId()).or((Expression)AssetLinkTable.INSTANCE.entryId2.eq((Object)assetEntry.getEntryId()))));
    }

    public List<AssetLink> getReverseLinks(long entryId, int typeId) {
        return this.assetLinkPersistence.findByE2_T(entryId, typeId);
    }

    public AssetLink updateLink(long userId, long entryId1, long entryId2, int typeId, int weight) throws PortalException {
        AssetLink assetLink = this.assetLinkPersistence.fetchByE_E_T(entryId1, entryId2, typeId);
        if (assetLink == null) {
            return this.addLink(userId, entryId1, entryId2, typeId, weight);
        }
        assetLink.setWeight(weight);
        return (AssetLink)this.assetLinkPersistence.update((BaseModel)assetLink);
    }

    public void updateLinks(long userId, long entryId, long[] linkEntryIds, int typeId) throws PortalException {
        if (linkEntryIds == null) {
            return;
        }
        List<AssetLink> assetLinks = this.getLinks(entryId, typeId);
        for (AssetLink assetLink : assetLinks) {
            if ((assetLink.getEntryId1() != entryId || ArrayUtil.contains((long[])linkEntryIds, (long)assetLink.getEntryId2())) && (assetLink.getEntryId2() != entryId || ArrayUtil.contains((long[])linkEntryIds, (long)assetLink.getEntryId1()))) continue;
            this.deleteAssetLink(assetLink);
        }
        for (Object assetLinkEntryId : (Object)linkEntryIds) {
            AssetLink link;
            if (assetLinkEntryId == entryId || (link = this.assetLinkPersistence.fetchByE_E_T(entryId, (long)assetLinkEntryId, typeId)) != null) continue;
            this.addLink(userId, entryId, (long)assetLinkEntryId, typeId, 0);
        }
    }

    private void _addDeletionSystemEvent(AssetLink assetLink) {
        AssetEntry assetEntry = this._assetEntryLocalService.fetchEntry(assetLink.getEntryId1());
        if (assetEntry == null) {
            return;
        }
        StagedAssetLink stagedAssetLink = (StagedAssetLink)ModelAdapterUtil.adapt((Object)assetLink, AssetLink.class, StagedAssetLink.class);
        StagedModelType stagedModelType = stagedAssetLink.getStagedModelType();
        try {
            this._systemEventLocalService.addSystemEvent(0L, assetEntry.getGroupId(), "", stagedModelType.getClassName(), stagedAssetLink.getPrimaryKey(), stagedAssetLink.getUuid(), null, 1, "");
        }
        catch (PortalException portalException) {
            throw new RuntimeException(portalException);
        }
    }

    private List<AssetLink> _filterAssetLinks(List<AssetLink> assetLinks, boolean excludeInvisibleLinks) {
        if (assetLinks.isEmpty() || !excludeInvisibleLinks) {
            return assetLinks;
        }
        List filteredAssetLinks = TransformUtil.transform(assetLinks, assetLink -> {
            AssetEntry assetEntry = this._assetEntryLocalService.fetchEntry(assetLink.getEntryId2());
            if (assetEntry != null && assetEntry.isVisible()) {
                return assetLink;
            }
            return null;
        });
        return Collections.unmodifiableList(filteredAssetLinks);
    }
}

