/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.link.internal.exportimport.staged.model.repository;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.asset.link.internal.exportimport.staged.model.repository.StagedAssetLinkStagedModelRepositoryUtil;
import com.liferay.asset.link.model.AssetLink;
import com.liferay.asset.link.model.adapter.StagedAssetLink;
import com.liferay.asset.link.service.AssetLinkLocalService;
import com.liferay.asset.util.StagingAssetEntryHelper;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.staged.model.repository.StagedModelRepository;
import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.OrderFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.dao.orm.ProjectionFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.model.adapter.util.ModelAdapterUtil;
import java.util.Collections;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.asset.link.model.adapter.StagedAssetLink"}, service={StagedModelRepository.class})
public class StagedAssetLinkStagedModelRepository
implements StagedModelRepository<StagedAssetLink> {
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private AssetLinkLocalService _assetLinkLocalService;
    @Reference
    private StagingAssetEntryHelper _stagingAssetEntryHelper;

    public StagedAssetLink addStagedModel(PortletDataContext portletDataContext, StagedAssetLink stagedAssetLink) throws PortalException {
        AssetEntry assetEntry1 = this._stagingAssetEntryHelper.fetchAssetEntry(portletDataContext.getScopeGroupId(), stagedAssetLink.getEntry1Uuid());
        AssetEntry assetEntry2 = this._stagingAssetEntryHelper.fetchAssetEntry(portletDataContext.getScopeGroupId(), stagedAssetLink.getEntry2Uuid());
        if (assetEntry1 == null || assetEntry2 == null) {
            return null;
        }
        AssetLink assetLink = this._assetLinkLocalService.addLink(portletDataContext.getUserId(stagedAssetLink.getUserUuid()), assetEntry1.getEntryId(), assetEntry2.getEntryId(), stagedAssetLink.getType(), stagedAssetLink.getWeight());
        return (StagedAssetLink)ModelAdapterUtil.adapt((Object)assetLink, AssetLink.class, StagedAssetLink.class);
    }

    public void deleteStagedModel(StagedAssetLink stagedAssetLink) throws PortalException {
        this._assetLinkLocalService.deleteLink((AssetLink)stagedAssetLink);
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        StagedAssetLink stagedAssetLink = StagedAssetLinkStagedModelRepositoryUtil.fetchExistingAssetLink(groupId, this._parseAssetEntry1Uuid(uuid), this._parseAssetEntry2Uuid(uuid));
        if (stagedAssetLink != null) {
            this.deleteStagedModel(stagedAssetLink);
        }
    }

    public void deleteStagedModels(PortletDataContext portletDataContext) throws PortalException {
        this._assetLinkLocalService.deleteGroupLinks(portletDataContext.getScopeGroupId());
    }

    public StagedAssetLink fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return null;
    }

    public List<StagedAssetLink> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        DynamicQuery dynamicQuery = this._getAssetLinkDynamicQuery(companyId, 0L, this._parseAssetEntry1Uuid(uuid), this._parseAssetEntry2Uuid(uuid));
        dynamicQuery.addOrder(OrderFactoryUtil.desc((String)"linkId"));
        List assetLinks = this._assetLinkLocalService.dynamicQuery(dynamicQuery);
        if (ListUtil.isNotEmpty((List)assetLinks)) {
            return ModelAdapterUtil.adapt((List)assetLinks, AssetLink.class, StagedAssetLink.class);
        }
        return Collections.emptyList();
    }

    public ExportActionableDynamicQuery getExportActionableDynamicQuery(PortletDataContext portletDataContext) {
        return new ExportActionableDynamicQuery();
    }

    public StagedAssetLink getStagedModel(long assetLinkId) throws PortalException {
        return (StagedAssetLink)ModelAdapterUtil.adapt((Object)this._assetLinkLocalService.getAssetLink(assetLinkId), AssetLink.class, StagedAssetLink.class);
    }

    public StagedAssetLink saveStagedModel(StagedAssetLink stagedAssetLink) throws PortalException {
        AssetLink assetLink = this._assetLinkLocalService.updateAssetLink((AssetLink)stagedAssetLink);
        return (StagedAssetLink)ModelAdapterUtil.adapt((Object)assetLink, AssetLink.class, StagedAssetLink.class);
    }

    public StagedAssetLink updateStagedModel(PortletDataContext portletDataContext, StagedAssetLink stagedAssetLink) throws PortalException {
        AssetLink assetLink = this._assetLinkLocalService.updateLink(portletDataContext.getUserId(stagedAssetLink.getUserUuid()), stagedAssetLink.getEntryId1(), stagedAssetLink.getEntryId2(), stagedAssetLink.getType(), stagedAssetLink.getWeight());
        return (StagedAssetLink)ModelAdapterUtil.adapt((Object)assetLink, AssetLink.class, StagedAssetLink.class);
    }

    private DynamicQuery _getAssetLinkDynamicQuery(long companyId, long groupId, String assetEntry1Uuid, String assetEntry2Uuid) {
        Projection entryIdProjection = ProjectionFactoryUtil.property((String)"entryId");
        DynamicQuery assetEntry1DynamicQuery = this._assetEntryLocalService.dynamicQuery();
        assetEntry1DynamicQuery.setProjection(entryIdProjection);
        Property classUuidProperty = PropertyFactoryUtil.forName((String)"classUuid");
        assetEntry1DynamicQuery.add(classUuidProperty.eq((Object)assetEntry1Uuid));
        DynamicQuery assetEntry2DynamicQuery = this._assetEntryLocalService.dynamicQuery();
        assetEntry2DynamicQuery.setProjection(entryIdProjection);
        assetEntry2DynamicQuery.add(classUuidProperty.eq((Object)assetEntry2Uuid));
        DynamicQuery dynamicQuery = this._assetLinkLocalService.dynamicQuery();
        Property entryId1IdProperty = PropertyFactoryUtil.forName((String)"entryId1");
        dynamicQuery.add(entryId1IdProperty.eq(assetEntry1DynamicQuery));
        Property entryId2IdProperty = PropertyFactoryUtil.forName((String)"entryId2");
        dynamicQuery.add(entryId2IdProperty.eq(assetEntry2DynamicQuery));
        if (companyId > 0L) {
            Property companyIdProperty = PropertyFactoryUtil.forName((String)"companyId");
            Criterion companyIdCriterion = companyIdProperty.eq((Object)companyId);
            assetEntry1DynamicQuery.add(companyIdCriterion);
            assetEntry2DynamicQuery.add(companyIdCriterion);
            dynamicQuery.add(companyIdCriterion);
        }
        if (groupId > 0L) {
            Property groupIdProperty = PropertyFactoryUtil.forName((String)"groupId");
            Criterion groupIdCriterion = groupIdProperty.eq((Object)groupId);
            assetEntry1DynamicQuery.add(groupIdCriterion);
            assetEntry2DynamicQuery.add(groupIdCriterion);
        }
        return dynamicQuery;
    }

    private String _parseAssetEntry1Uuid(String uuid) {
        return uuid.substring(0, uuid.indexOf("#"));
    }

    private String _parseAssetEntry2Uuid(String uuid) {
        return uuid.substring(uuid.indexOf("#") + 1);
    }
}

