/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.entry.rel.service.impl;

import com.liferay.asset.entry.rel.model.AssetEntryAssetCategoryRel;
import com.liferay.asset.entry.rel.model.AssetEntryAssetCategoryRelModel;
import com.liferay.asset.entry.rel.model.AssetEntryAssetCategoryRelTable;
import com.liferay.asset.entry.rel.service.base.AssetEntryAssetCategoryRelLocalServiceBaseImpl;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetEntryTable;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.sql.dsl.query.GroupByStep;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.mass.delete.MassDeleteCacheThreadLocal;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistry;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.asset.entry.rel.model.AssetEntryAssetCategoryRel"}, service={AopService.class})
public class AssetEntryAssetCategoryRelLocalServiceImpl
extends AssetEntryAssetCategoryRelLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(AssetEntryAssetCategoryRelLocalServiceImpl.class);
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private IndexerRegistry _indexerRegistry;

    public AssetEntryAssetCategoryRel addAssetEntryAssetCategoryRel(long assetEntryId, long assetCategoryId) {
        return this.assetEntryAssetCategoryRelLocalService.addAssetEntryAssetCategoryRel(assetEntryId, assetCategoryId, 0);
    }

    public AssetEntryAssetCategoryRel addAssetEntryAssetCategoryRel(long assetEntryId, long assetCategoryId, int priority) {
        long assetEntryAssetCategoryRelId = this.counterLocalService.increment();
        AssetEntryAssetCategoryRel assetEntryAssetCategoryRel = this.assetEntryAssetCategoryRelPersistence.create(assetEntryAssetCategoryRelId);
        assetEntryAssetCategoryRel.setAssetEntryId(assetEntryId);
        assetEntryAssetCategoryRel.setAssetCategoryId(assetCategoryId);
        assetEntryAssetCategoryRel.setPriority(priority);
        return (AssetEntryAssetCategoryRel)this.assetEntryAssetCategoryRelPersistence.update((BaseModel)assetEntryAssetCategoryRel);
    }

    public void deleteAssetEntryAssetCategoryRel(long assetEntryId, long assetCategoryId) {
        AssetEntryAssetCategoryRel assetEntryAssetCategoryRel = this.assetEntryAssetCategoryRelPersistence.fetchByA_A(assetEntryId, assetCategoryId);
        if (assetEntryAssetCategoryRel != null) {
            this.assetEntryAssetCategoryRelPersistence.remove((BaseModel)assetEntryAssetCategoryRel);
        }
        this._reindex(this._assetEntryLocalService.fetchEntry(assetEntryId));
    }

    public void deleteAssetEntryAssetCategoryRelByAssetCategoryId(long assetCategoryId) {
        List assetEntryAssetCategoryRels = this.assetEntryAssetCategoryRelPersistence.findByAssetCategoryId(assetCategoryId);
        assetEntryAssetCategoryRels.forEach(assetEntryAssetCategoryRel -> {
            this.assetEntryAssetCategoryRelPersistence.remove((BaseModel)assetEntryAssetCategoryRel);
            this._reindex(this._assetEntryLocalService.fetchEntry(assetEntryAssetCategoryRel.getAssetEntryId()));
        });
    }

    public void deleteAssetEntryAssetCategoryRelByAssetEntry(AssetEntry assetEntry) {
        Map partitionAssetEntryAssetCategoryRels = (Map)MassDeleteCacheThreadLocal.getMassDeleteCache((String)(AssetEntryAssetCategoryRelLocalServiceImpl.class.getName() + ".deleteAssetEntryAssetCategoryRelByAssetEntry"), () -> MapUtil.toPartitionMap((List)this.assetEntryAssetCategoryRelPersistence.findAll(), AssetEntryAssetCategoryRelModel::getAssetEntryId));
        if (partitionAssetEntryAssetCategoryRels == null) {
            this.assetEntryAssetCategoryRelPersistence.removeByAssetEntryId(assetEntry.getEntryId());
        } else {
            List assetEntryAssetCategoryRels = (List)partitionAssetEntryAssetCategoryRels.remove(assetEntry.getEntryId());
            ListUtil.isNotEmptyForEach((List)assetEntryAssetCategoryRels, assetEntryAssetCategoryRel -> this.assetEntryAssetCategoryRelPersistence.remove((BaseModel)assetEntryAssetCategoryRel));
        }
        this._reindex(assetEntry);
    }

    public void deleteAssetEntryAssetCategoryRelByAssetEntryId(long assetEntryId) {
        AssetEntry assetEntry = this._assetEntryLocalService.fetchAssetEntry(assetEntryId);
        if (assetEntry != null) {
            this.deleteAssetEntryAssetCategoryRelByAssetEntry(assetEntry);
        }
    }

    public AssetEntryAssetCategoryRel fetchAssetEntryAssetCategoryRel(long assetEntryId, long assetCategoryId) {
        return this.assetEntryAssetCategoryRelPersistence.fetchByA_A(assetEntryId, assetCategoryId);
    }

    public long[] getAssetCategoryPrimaryKeys(long assetEntryId) {
        List<AssetEntryAssetCategoryRel> assetEntryAssetCategoryRels = this.getAssetEntryAssetCategoryRelsByAssetEntryId(assetEntryId);
        return ListUtil.toLongArray(assetEntryAssetCategoryRels, AssetEntryAssetCategoryRelModel::getAssetCategoryId);
    }

    public List<AssetEntryAssetCategoryRel> getAssetEntryAssetCategoryRelsByAssetCategoryId(long assetCategoryId) {
        return this.assetEntryAssetCategoryRelPersistence.findByAssetCategoryId(assetCategoryId);
    }

    public List<AssetEntryAssetCategoryRel> getAssetEntryAssetCategoryRelsByAssetCategoryId(long assetCategoryId, int start, int end) {
        return this.assetEntryAssetCategoryRelPersistence.findByAssetCategoryId(assetCategoryId, start, end);
    }

    public List<AssetEntryAssetCategoryRel> getAssetEntryAssetCategoryRelsByAssetCategoryId(long assetCategoryId, int start, int end, OrderByComparator<AssetEntryAssetCategoryRel> orderByComparator) {
        return this.assetEntryAssetCategoryRelPersistence.findByAssetCategoryId(assetCategoryId, start, end, orderByComparator);
    }

    public List<AssetEntryAssetCategoryRel> getAssetEntryAssetCategoryRelsByAssetEntryId(long assetEntryId) {
        return this.assetEntryAssetCategoryRelPersistence.findByAssetEntryId(assetEntryId);
    }

    public List<AssetEntryAssetCategoryRel> getAssetEntryAssetCategoryRelsByAssetEntryId(long assetEntryId, int start, int end) {
        return this.assetEntryAssetCategoryRelPersistence.findByAssetEntryId(assetEntryId, start, end);
    }

    public List<AssetEntryAssetCategoryRel> getAssetEntryAssetCategoryRelsByAssetEntryId(long assetEntryId, int start, int end, OrderByComparator<AssetEntryAssetCategoryRel> orderByComparator) {
        return this.assetEntryAssetCategoryRelPersistence.findByAssetEntryId(assetEntryId, start, end, orderByComparator);
    }

    public int getAssetEntryAssetCategoryRelsCount(long assetEntryId) {
        return this.assetEntryAssetCategoryRelPersistence.countByAssetEntryId(assetEntryId);
    }

    public int getAssetEntryAssetCategoryRelsCountByAssetCategoryId(long assetCategoryId) {
        return this.assetEntryAssetCategoryRelPersistence.countByAssetCategoryId(assetCategoryId);
    }

    public int getAssetEntryAssetCategoryRelsCountByClassNameId(long assetCategoryId, long classNameId) {
        GroupByStep dslQuery = DSLQueryFactoryUtil.count().from((Table)AssetEntryTable.INSTANCE).innerJoinON((Table)AssetEntryAssetCategoryRelTable.INSTANCE, AssetEntryAssetCategoryRelTable.INSTANCE.assetEntryId.eq((Expression)AssetEntryTable.INSTANCE.entryId)).where(AssetEntryAssetCategoryRelTable.INSTANCE.assetCategoryId.eq((Object)assetCategoryId).and((Expression)AssetEntryTable.INSTANCE.classNameId.eq((Object)classNameId)));
        return this._assetEntryLocalService.dslQueryCount((DSLQuery)dslQuery);
    }

    public long[] getAssetEntryPrimaryKeys(long assetCategoryId) {
        List<AssetEntryAssetCategoryRel> assetEntryAssetCategoryRels = this.getAssetEntryAssetCategoryRelsByAssetCategoryId(assetCategoryId);
        return ListUtil.toLongArray(assetEntryAssetCategoryRels, AssetEntryAssetCategoryRelModel::getAssetEntryId);
    }

    private void _reindex(AssetEntry assetEntry) {
        if (assetEntry == null) {
            return;
        }
        try {
            Indexer indexer = this._indexerRegistry.getIndexer(assetEntry.getClassName());
            if (indexer == null) {
                return;
            }
            AssetRenderer assetRenderer = assetEntry.getAssetRenderer();
            if (assetRenderer == null) {
                return;
            }
            indexer.reindex(assetRenderer.getAssetObject());
        }
        catch (SearchException searchException) {
            _log.error((Object)"Unable to reindex asset entry", (Throwable)searchException);
        }
    }
}

