/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.entry.rel.service.impl;

import com.liferay.asset.entry.rel.model.AssetEntryAssetCategoryRel;
import com.liferay.asset.entry.rel.model.AssetEntryAssetCategoryRelModel;
import com.liferay.asset.entry.rel.service.base.AssetEntryAssetCategoryRelLocalServiceBaseImpl;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;
import org.osgi.service.component.annotations.Component;

@Component(property={"model.class.name=com.liferay.asset.entry.rel.model.AssetEntryAssetCategoryRel"}, service={AopService.class})
public class AssetEntryAssetCategoryRelLocalServiceImpl
extends AssetEntryAssetCategoryRelLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(AssetEntryAssetCategoryRelLocalServiceImpl.class);

    public AssetEntryAssetCategoryRel addAssetEntryAssetCategoryRel(long assetEntryId, long assetCategoryId) {
        return this.assetEntryAssetCategoryRelLocalService.addAssetEntryAssetCategoryRel(assetEntryId, assetCategoryId, 0);
    }

    public AssetEntryAssetCategoryRel addAssetEntryAssetCategoryRel(long assetEntryId, long assetCategoryId, int priority) {
        long assetEntryAssetCategoryRelId = this.counterLocalService.increment();
        AssetEntryAssetCategoryRel assetEntryAssetCategoryRel = this.assetEntryAssetCategoryRelPersistence.create(assetEntryAssetCategoryRelId);
        assetEntryAssetCategoryRel.setAssetEntryId(assetEntryId);
        assetEntryAssetCategoryRel.setAssetCategoryId(assetCategoryId);
        assetEntryAssetCategoryRel.setPriority(priority);
        return (AssetEntryAssetCategoryRel)this.assetEntryAssetCategoryRelPersistence.update((BaseModel)assetEntryAssetCategoryRel);
    }

    public void deleteAssetEntryAssetCategoryRel(long assetEntryId, long assetCategoryId) {
        AssetEntryAssetCategoryRel assetEntryAssetCategoryRel = this.assetEntryAssetCategoryRelPersistence.fetchByA_A(assetEntryId, assetCategoryId);
        if (assetEntryAssetCategoryRel != null) {
            this.assetEntryAssetCategoryRelPersistence.remove((BaseModel)assetEntryAssetCategoryRel);
        }
        this._reindex(assetEntryId);
    }

    public void deleteAssetEntryAssetCategoryRelByAssetCategoryId(long assetCategoryId) {
        List assetEntryAssetCategoryRels = this.assetEntryAssetCategoryRelPersistence.findByAssetCategoryId(assetCategoryId);
        assetEntryAssetCategoryRels.forEach(assetEntryAssetCategoryRel -> {
            this.assetEntryAssetCategoryRelPersistence.remove((BaseModel)assetEntryAssetCategoryRel);
            this._reindex(assetEntryAssetCategoryRel.getAssetEntryId());
        });
        this.assetEntryAssetCategoryRelPersistence.removeByAssetCategoryId(assetCategoryId);
    }

    public void deleteAssetEntryAssetCategoryRelByAssetEntryId(long assetEntryId) {
        this.assetEntryAssetCategoryRelPersistence.removeByAssetEntryId(assetEntryId);
        this._reindex(assetEntryId);
    }

    public AssetEntryAssetCategoryRel fetchAssetEntryAssetCategoryRel(long assetEntryId, long assetCategoryId) {
        return this.assetEntryAssetCategoryRelPersistence.fetchByA_A(assetEntryId, assetCategoryId);
    }

    public long[] getAssetCategoryPrimaryKeys(long assetEntryId) {
        List<AssetEntryAssetCategoryRel> assetEntryAssetCategoryRels = this.getAssetEntryAssetCategoryRelsByAssetEntryId(assetEntryId);
        return ListUtil.toLongArray(assetEntryAssetCategoryRels, AssetEntryAssetCategoryRelModel::getAssetCategoryId);
    }

    public List<AssetEntryAssetCategoryRel> getAssetEntryAssetCategoryRelsByAssetCategoryId(long assetCategoryId) {
        return this.assetEntryAssetCategoryRelPersistence.findByAssetCategoryId(assetCategoryId);
    }

    public List<AssetEntryAssetCategoryRel> getAssetEntryAssetCategoryRelsByAssetCategoryId(long assetCategoryId, int start, int end) {
        return this.assetEntryAssetCategoryRelPersistence.findByAssetCategoryId(assetCategoryId, start, end);
    }

    public List<AssetEntryAssetCategoryRel> getAssetEntryAssetCategoryRelsByAssetCategoryId(long assetCategoryId, int start, int end, OrderByComparator<AssetEntryAssetCategoryRel> orderByComparator) {
        return this.assetEntryAssetCategoryRelPersistence.findByAssetCategoryId(assetCategoryId, start, end, orderByComparator);
    }

    public List<AssetEntryAssetCategoryRel> getAssetEntryAssetCategoryRelsByAssetEntryId(long assetEntryId) {
        return this.assetEntryAssetCategoryRelPersistence.findByAssetEntryId(assetEntryId);
    }

    public List<AssetEntryAssetCategoryRel> getAssetEntryAssetCategoryRelsByAssetEntryId(long assetEntryId, int start, int end) {
        return this.assetEntryAssetCategoryRelPersistence.findByAssetEntryId(assetEntryId, start, end);
    }

    public List<AssetEntryAssetCategoryRel> getAssetEntryAssetCategoryRelsByAssetEntryId(long assetEntryId, int start, int end, OrderByComparator<AssetEntryAssetCategoryRel> orderByComparator) {
        return this.assetEntryAssetCategoryRelPersistence.findByAssetEntryId(assetEntryId, start, end, orderByComparator);
    }

    public int getAssetEntryAssetCategoryRelsCount(long assetEntryId) {
        return this.assetEntryAssetCategoryRelPersistence.countByAssetEntryId(assetEntryId);
    }

    public long[] getAssetEntryPrimaryKeys(long assetCategoryId) {
        List<AssetEntryAssetCategoryRel> assetEntryAssetCategoryRels = this.getAssetEntryAssetCategoryRelsByAssetCategoryId(assetCategoryId);
        return ListUtil.toLongArray(assetEntryAssetCategoryRels, AssetEntryAssetCategoryRelModel::getAssetCategoryId);
    }

    private void _reindex(long assetEntryId) {
        if (assetEntryId <= 0L) {
            return;
        }
        AssetEntry assetEntry = this.assetEntryLocalService.fetchEntry(assetEntryId);
        if (assetEntry == null) {
            return;
        }
        try {
            Indexer indexer = IndexerRegistryUtil.getIndexer((String)assetEntry.getClassName());
            if (indexer == null) {
                return;
            }
            AssetRenderer assetRenderer = assetEntry.getAssetRenderer();
            if (assetRenderer == null) {
                return;
            }
            Object assetObject = assetRenderer.getAssetObject();
            if (assetObject == null) {
                return;
            }
            indexer.reindex(assetObject);
        }
        catch (SearchException searchException) {
            _log.error((Object)"Unable to reindex asset entry", (Throwable)searchException);
        }
    }
}

