/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.display.page.internal.upgrade.v3_1_0;

import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryLocalService;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class AssetDisplayLayoutUpgradeProcess
extends UpgradeProcess {
    private final LayoutPageTemplateEntryLocalService _layoutPageTemplateEntryLocalService;

    public AssetDisplayLayoutUpgradeProcess(LayoutPageTemplateEntryLocalService layoutPageTemplateEntryLocalService) {
        this._layoutPageTemplateEntryLocalService = layoutPageTemplateEntryLocalService;
    }

    protected void doUpgrade() throws Exception {
        this._upgradeAssetDisplayLayouts();
    }

    private void _upgradeAssetDisplayLayouts() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement("select ctCollectionId, assetDisplayPageEntryId, layoutPageTemplateEntryId from AssetDisplayPageEntry where type_ = ? and (plid is null or plid = 0)");
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update AssetDisplayPageEntry set plid = ? where ctCollectionId = ? and assetDisplayPageEntryId = ?");){
            preparedStatement1.setInt(1, 2);
            try (ResultSet resultSet = preparedStatement1.executeQuery();){
                while (resultSet.next()) {
                    long plid;
                    long layoutPageTemplateEntryId = resultSet.getLong("layoutPageTemplateEntryId");
                    LayoutPageTemplateEntry layoutPageTemplateEntry = this._layoutPageTemplateEntryLocalService.fetchLayoutPageTemplateEntry(layoutPageTemplateEntryId);
                    if (layoutPageTemplateEntry == null || (plid = layoutPageTemplateEntry.getPlid()) == 0L) continue;
                    preparedStatement2.setLong(1, plid);
                    long ctCollectionId = resultSet.getLong("ctCollectionId");
                    preparedStatement2.setLong(2, ctCollectionId);
                    long assetDisplayPageEntryId = resultSet.getLong("assetDisplayPageEntryId");
                    preparedStatement2.setLong(3, assetDisplayPageEntryId);
                    preparedStatement2.addBatch();
                }
                preparedStatement2.executeBatch();
            }
        }
    }
}

