/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.display.page.internal.upgrade.v2_2_1;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class AssetDisplayLayoutFriendlyURLPrivateLayoutUpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(AssetDisplayLayoutFriendlyURLPrivateLayoutUpgradeProcess.class);

    protected void doUpgrade() throws Exception {
        this._upgradeAssetDisplayLayoutFriendlyURLs();
    }

    private String _getFriendlyURL(PreparedStatement preparedStatement, long groupId, String friendlyURL, String languageId) throws SQLException {
        String initialFriendlyURL = friendlyURL;
        preparedStatement.setLong(1, groupId);
        preparedStatement.setBoolean(2, false);
        preparedStatement.setString(3, (String)friendlyURL);
        preparedStatement.setString(4, languageId);
        int i = 0;
        while (true) {
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (!resultSet.next()) break;
                friendlyURL = initialFriendlyURL + "-" + i;
                preparedStatement.setString(3, (String)friendlyURL);
            }
            ++i;
        }
        return friendlyURL;
    }

    private void _upgradeAssetDisplayLayoutFriendlyURLs() throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select distinct LayoutFriendlyURL.plid, ", "LayoutFriendlyURL.groupId, ", "LayoutFriendlyURL.friendlyURL, ", "LayoutFriendlyURL.languageId from LayoutFriendlyURL ", "inner join Layout on Layout.plid = ", "LayoutFriendlyURL.plid where Layout.type_ = ? and ", "LayoutFriendlyURL.privateLayout = ?"}));
             PreparedStatement preparedStatement2 = this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select LayoutFriendlyURL.layoutFriendlyURLid from ", "LayoutFriendlyURL where LayoutFriendlyURL.groupId = ? ", "and LayoutFriendlyURL.privateLayout = ? and ", "LayoutFriendlyURL.friendlyURL = ? and ", "LayoutFriendlyURL.languageId = ?"}));
             PreparedStatement preparedStatement3 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update LayoutFriendlyURL set privateLayout = ?,friendlyURL = ? where plid = ?");){
            preparedStatement1.setString(1, "asset_display");
            preparedStatement1.setBoolean(2, true);
            try (ResultSet resultSet = preparedStatement1.executeQuery();){
                while (resultSet.next()) {
                    long groupId = resultSet.getLong("groupId");
                    String friendlyURL = resultSet.getString("friendlyURL");
                    String languageId = resultSet.getString("languageId");
                    long plid = resultSet.getLong("plid");
                    String newFriendlyURL = this._getFriendlyURL(preparedStatement2, groupId, friendlyURL, languageId);
                    if (!newFriendlyURL.equals(friendlyURL) && _log.isWarnEnabled()) {
                        _log.warn((Object)StringBundler.concat((Object[])new Object[]{"FriendlyURL for PLID ", plid, " in group ", groupId, " changed from ", friendlyURL, " to ", newFriendlyURL}));
                    }
                    preparedStatement3.setBoolean(1, false);
                    preparedStatement3.setString(2, newFriendlyURL);
                    preparedStatement3.setLong(3, plid);
                    preparedStatement3.addBatch();
                }
                preparedStatement3.executeBatch();
            }
        }
    }
}

