/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.display.page.internal.upgrade.v2_1_1;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class UpgradeAssetDisplayPrivateLayout
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(UpgradeAssetDisplayPrivateLayout.class);
    private final LayoutLocalService _layoutLocalService;
    private final ResourceLocalService _resourceLocalService;

    public UpgradeAssetDisplayPrivateLayout(LayoutLocalService layoutLocalService, ResourceLocalService resourceLocalService) {
        this._layoutLocalService = layoutLocalService;
        this._resourceLocalService = resourceLocalService;
    }

    protected void doUpgrade() throws Exception {
        this._upgradeAssetDisplayLayouts();
    }

    private void _addResources(long groupId, long plid) throws PortalException {
        Layout layout = this._layoutLocalService.fetchLayout(plid);
        this._resourceLocalService.addResources(layout.getCompanyId(), groupId, layout.getUserId(), Layout.class.getName(), layout.getPlid(), false, true, true);
    }

    private String _getFriendlyURL(PreparedStatement ps, long groupId, String friendlyURL) throws SQLException {
        String initialFriendlyURL = friendlyURL;
        ps.setLong(1, groupId);
        ps.setBoolean(2, false);
        ps.setString(3, friendlyURL);
        int i = 1;
        while (true) {
            try (ResultSet rs = ps.executeQuery();){
                if (!rs.next()) break;
                friendlyURL = initialFriendlyURL + "-" + i;
                ps.setString(3, friendlyURL);
            }
            ++i;
        }
        return friendlyURL;
    }

    private void _upgradeAssetDisplayLayouts() throws Exception {
        try (PreparedStatement ps1 = this.connection.prepareStatement("select groupId, friendlyURL, plid from  Layout where privateLayout = ? and type_ = ?");
             PreparedStatement ps2 = this.connection.prepareStatement("select plid from Layout where groupId = ? and privateLayout = ? and friendlyURL = ?");
             PreparedStatement ps3 = AutoBatchPreparedStatementUtil.autoBatch((PreparedStatement)this.connection.prepareStatement("update Layout set privateLayout = ?, layoutId = ?, friendlyURL = ? where plid = ?"));
             PreparedStatement ps4 = AutoBatchPreparedStatementUtil.autoBatch((PreparedStatement)this.connection.prepareStatement("update LayoutFriendlyURL set privateLayout = ?, friendlyURL = ? where plid = ?"));){
            ps1.setBoolean(1, true);
            ps1.setString(2, "asset_display");
            try (ResultSet rs = ps1.executeQuery();){
                while (rs.next()) {
                    long groupId = rs.getLong("groupId");
                    String friendlyURL = rs.getString("friendlyURL");
                    long plid = rs.getLong("plid");
                    this._addResources(groupId, plid);
                    String newFriendlyURL = this._getFriendlyURL(ps2, groupId, friendlyURL);
                    if (!newFriendlyURL.equals(friendlyURL) && _log.isWarnEnabled()) {
                        _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Friendly URL for PLID ", plid, " in group ", groupId, " changed from ", friendlyURL, " to ", newFriendlyURL}));
                    }
                    ps3.setBoolean(1, false);
                    ps3.setLong(2, this._layoutLocalService.getNextLayoutId(groupId, false));
                    ps3.setString(3, newFriendlyURL);
                    ps3.setLong(4, plid);
                    ps3.addBatch();
                    ps4.setBoolean(1, false);
                    ps4.setString(2, newFriendlyURL);
                    ps4.setLong(3, plid);
                    ps4.addBatch();
                }
                ps3.executeBatch();
                ps4.executeBatch();
            }
        }
    }
}

