/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.display.page.internal.upgrade.v2_1_0;

import com.liferay.asset.display.page.internal.upgrade.v2_1_0.util.AssetDisplayPageEntryTable;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryLocalService;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Optional;

public class UpgradeAssetDisplayLayout
extends UpgradeProcess {
    private final AssetEntryLocalService _assetEntryLocalService;
    private final LayoutLocalService _layoutLocalService;
    private final LayoutPageTemplateEntryLocalService _layoutPageTemplateEntryLocalService;
    private final LayoutPageTemplateEntryService _layoutPageTemplateEntryService;

    public UpgradeAssetDisplayLayout(AssetEntryLocalService assetEntryLocalService, LayoutLocalService layoutLocalService, LayoutPageTemplateEntryLocalService layoutPageTemplateEntryLocalService, LayoutPageTemplateEntryService layoutPageTemplateEntryService) {
        this._assetEntryLocalService = assetEntryLocalService;
        this._layoutLocalService = layoutLocalService;
        this._layoutPageTemplateEntryLocalService = layoutPageTemplateEntryLocalService;
        this._layoutPageTemplateEntryService = layoutPageTemplateEntryService;
    }

    protected void doUpgrade() throws Exception {
        this._upgradeAssetDisplayLayouts();
        this._upgradeSchema();
    }

    private long _getPlid(AssetEntry assetEntry, long userId, long groupId, long layoutPageTemplateEntryId, ServiceContext serviceContext) throws PortalException {
        LayoutPageTemplateEntry layoutPageTemplateEntry = Optional.ofNullable(this._layoutPageTemplateEntryLocalService.fetchLayoutPageTemplateEntry(layoutPageTemplateEntryId)).orElseGet(() -> this._layoutPageTemplateEntryService.fetchDefaultLayoutPageTemplateEntry(groupId, assetEntry.getClassNameId(), assetEntry.getClassTypeId()));
        if (layoutPageTemplateEntry == null) {
            return 0L;
        }
        if (layoutPageTemplateEntry.getPlid() > 0L) {
            return layoutPageTemplateEntry.getPlid();
        }
        serviceContext.setAttribute("layout.instanceable.allowed", (Serializable)Boolean.TRUE);
        Layout layout = this._layoutLocalService.addLayout(userId, groupId, false, 0L, assetEntry.getTitleMap(), assetEntry.getTitleMap(), assetEntry.getDescriptionMap(), null, null, "asset_display", "", true, true, new HashMap(), serviceContext);
        layoutPageTemplateEntry.setPlid(layout.getPlid());
        this._layoutPageTemplateEntryLocalService.updateLayoutPageTemplateEntry(layoutPageTemplateEntry);
        return layout.getPlid();
    }

    private void _upgradeAssetDisplayLayouts() throws Exception {
        ActionableDynamicQuery actionableDynamicQuery = this._layoutLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"type", (Object)"asset_display")));
        actionableDynamicQuery.setPerformActionMethod(layout -> {
            layout.setSystem(true);
            this._layoutLocalService.updateLayout(layout);
        });
        actionableDynamicQuery.performActions();
    }

    private void _upgradeSchema() throws Exception {
        this.alter(AssetDisplayPageEntryTable.class, new UpgradeProcess.Alterable[]{new UpgradeProcess.AlterTableAddColumn((UpgradeProcess)this, "plid LONG")});
        StringBundler sb = new StringBundler(3);
        sb.append("select assetDisplayPageEntryId, userId, groupId, ");
        sb.append("classNameId, classPK, layoutPageTemplateEntryId from ");
        sb.append("AssetDisplayPageEntry where plid is null or plid = 0");
        ServiceContext serviceContext = new ServiceContext();
        try (LoggingTimer loggingTimer = new LoggingTimer();
             Statement s = this.connection.createStatement();
             ResultSet rs = s.executeQuery(sb.toString());
             PreparedStatement ps = AutoBatchPreparedStatementUtil.autoBatch((PreparedStatement)this.connection.prepareStatement("update AssetDisplayPageEntry set plid = ? where assetDisplayPageEntryId = ?"));){
            while (rs.next()) {
                long classPK;
                long classNameId = rs.getLong("classNameId");
                AssetEntry assetEntry = this._assetEntryLocalService.fetchEntry(classNameId, classPK = rs.getLong("classPK"));
                if (assetEntry == null) continue;
                long userId = rs.getLong("userId");
                long groupId = rs.getLong("groupId");
                long layoutPageTemplateEntryId = rs.getLong("layoutPageTemplateEntryId");
                ps.setLong(1, this._getPlid(assetEntry, userId, groupId, layoutPageTemplateEntryId, serviceContext));
                long assetDisplayPageEntryId = rs.getLong("assetDisplayPageEntryId");
                ps.setLong(2, assetDisplayPageEntryId);
                ps.addBatch();
            }
            ps.executeBatch();
        }
    }
}

