/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.categories.internal.validator;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.exception.AssetCategoryException;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.asset.kernel.service.AssetVocabularyLocalService;
import com.liferay.asset.kernel.validator.AssetEntryValidator;
import com.liferay.depot.group.provider.SiteConnectedGroupGroupProvider;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=*"}, service={AssetEntryValidator.class})
public class CardinalityAssetEntryValidator
implements AssetEntryValidator {
    private static final Log _log = LogFactoryUtil.getLog((String)CardinalityAssetEntryValidator.class.getName());
    @Reference
    private AssetVocabularyLocalService _assetVocabularyLocalService;
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private SiteConnectedGroupGroupProvider _siteConnectedGroupGroupProvider;

    public void validate(long groupId, String className, long classPK, long classTypePK, long[] categoryIds, String[] tagNames) throws PortalException {
        if (!this._isCategorizable(groupId, className, classPK)) {
            return;
        }
        if (className.equals(Group.class.getName())) {
            groupId = classPK;
        }
        long classNameId = this._classNameLocalService.getClassNameId(className);
        for (AssetVocabulary assetVocabulary : this._assetVocabularyLocalService.getGroupsVocabularies(this._siteConnectedGroupGroupProvider.getCurrentAndAncestorSiteAndDepotGroupIds(groupId))) {
            this.validate(groupId, classNameId, classTypePK, categoryIds, assetVocabulary);
        }
    }

    protected void validate(long groupId, long classNameId, long classTypePK, long[] categoryIds, AssetVocabulary assetVocabulary) throws PortalException {
        if (!assetVocabulary.isAssociatedToClassNameIdAndClassTypePK(classNameId, classTypePK)) {
            return;
        }
        if (assetVocabulary.isMissingRequiredCategory(classNameId, classTypePK, categoryIds, groupId)) {
            throw new AssetCategoryException(assetVocabulary, 1);
        }
        if (!assetVocabulary.isMultiValued() && assetVocabulary.hasMoreThanOneCategorySelected(categoryIds)) {
            throw new AssetCategoryException(assetVocabulary, 2);
        }
    }

    private boolean _isCategorizable(long groupId, String className, long classPK) {
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)className);
        if (assetRendererFactory == null || !assetRendererFactory.isCategorizable()) {
            return false;
        }
        if (classPK != 0L) {
            try {
                AssetRenderer assetRenderer = assetRendererFactory.getAssetRenderer(classPK);
                if (assetRenderer == null || !assetRenderer.isCategorizable(groupId)) {
                    return false;
                }
            }
            catch (PortalException portalException) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Asset entry with class PK ", classPK, " and class name ", className, " is not categorizable"}), (Throwable)portalException);
                }
                return false;
            }
        }
        return true;
    }
}

