/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.categories.internal.search.spi.model.index.contributor;

import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.asset.kernel.model.AssetVocabularyGroupRelModel;
import com.liferay.asset.kernel.service.AssetVocabularyGroupRelLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Localization;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.search.localization.SearchLocalizationHelper;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import com.liferay.portlet.asset.util.AssetVocabularySettingsHelper;
import java.util.List;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"indexer.class.name=com.liferay.asset.kernel.model.AssetVocabulary"}, service={ModelDocumentContributor.class})
public class AssetVocabularyModelDocumentContributor
implements ModelDocumentContributor<AssetVocabulary> {
    @Reference
    private AssetVocabularyGroupRelLocalService _assetVocabularyGroupRelLocalService;
    @Reference
    private Localization _localization;
    @Reference
    private Portal _portal;
    @Reference
    private SearchLocalizationHelper _searchLocalizationHelper;

    public void contribute(Document document, AssetVocabulary assetVocabulary) {
        document.addKeyword("assetVocabularyId", assetVocabulary.getVocabularyId());
        Locale siteDefaultLocale = this._getSiteDefaultLocale(assetVocabulary.getGroupId());
        this._searchLocalizationHelper.addLocalizedField(document, "description", siteDefaultLocale, assetVocabulary.getDescriptionMap());
        document.addText("name", assetVocabulary.getName());
        this._searchLocalizationHelper.addLocalizedField(document, "title", siteDefaultLocale, assetVocabulary.getTitleMap());
        document.addNumber("visibilityType", assetVocabulary.getVisibilityType());
        document.addNumber("categoriesCount", assetVocabulary.getCategoriesCount());
        document.addKeyword("classNameIds", this._getClassNameIds(assetVocabulary));
        document.addKeyword("groupIds", this._getGroupIds(assetVocabulary.getVocabularyId()));
        document.addLocalizedKeyword("localized_title", this._localization.populateLocalizationMap(assetVocabulary.getTitleMap(), assetVocabulary.getDefaultLanguageId(), assetVocabulary.getGroupId()), true, true);
    }

    private long[] _getClassNameIds(AssetVocabulary assetVocabulary) {
        AssetVocabularySettingsHelper assetVocabularySettingsHelper = new AssetVocabularySettingsHelper(assetVocabulary.getSettings());
        return assetVocabularySettingsHelper.getClassNameIds();
    }

    private long[] _getGroupIds(long vocabularyId) {
        return ListUtil.toLongArray((List)this._assetVocabularyGroupRelLocalService.getAssetVocabularyGroupRelsByVocabularyId(vocabularyId), AssetVocabularyGroupRelModel::getGroupId);
    }

    private Locale _getSiteDefaultLocale(long groupId) {
        try {
            return this._portal.getSiteDefaultLocale(groupId);
        }
        catch (PortalException portalException) {
            throw new SystemException((Throwable)portalException);
        }
    }
}

