/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.categories.internal.layout.display.page;

import com.liferay.asset.categories.internal.layout.display.page.AssetCategoryLayoutDisplayPageObjectProvider;
import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.info.item.ClassPKInfoItemIdentifier;
import com.liferay.info.item.ERCInfoItemIdentifier;
import com.liferay.info.item.InfoItemIdentifier;
import com.liferay.info.item.InfoItemReference;
import com.liferay.layout.display.page.BaseLayoutDisplayPageProvider;
import com.liferay.layout.display.page.LayoutDisplayPageObjectProvider;
import com.liferay.layout.display.page.LayoutDisplayPageProvider;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Portal;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={LayoutDisplayPageProvider.class})
public class AssetCategoryLayoutDisplayPageProvider
extends BaseLayoutDisplayPageProvider<AssetCategory> {
    @Reference
    private AssetCategoryLocalService _assetCategoryLocalService;
    @Reference
    private Portal _portal;

    public String getClassName() {
        return AssetCategory.class.getName();
    }

    public String getDefaultURLSeparator() {
        return "/v/";
    }

    public LayoutDisplayPageObjectProvider<AssetCategory> getLayoutDisplayPageObjectProvider(AssetCategory assetCategory) {
        return new AssetCategoryLayoutDisplayPageObjectProvider(assetCategory, this._portal);
    }

    public LayoutDisplayPageObjectProvider<AssetCategory> getLayoutDisplayPageObjectProvider(long groupId, String urlTitle) {
        AssetCategory assetCategory = this._assetCategoryLocalService.fetchAssetCategory(GetterUtil.getLong((String)urlTitle));
        if (assetCategory == null) {
            return null;
        }
        return new AssetCategoryLayoutDisplayPageObjectProvider(assetCategory, this._portal);
    }

    public LayoutDisplayPageObjectProvider<AssetCategory> getParentLayoutDisplayPageObjectProvider(InfoItemReference infoItemReference) {
        InfoItemIdentifier infoItemIdentifier = infoItemReference.getInfoItemIdentifier();
        if (!(infoItemIdentifier instanceof ClassPKInfoItemIdentifier)) {
            return null;
        }
        ClassPKInfoItemIdentifier classPKInfoItemIdentifier = (ClassPKInfoItemIdentifier)infoItemIdentifier;
        AssetCategory assetCategory = this._assetCategoryLocalService.fetchAssetCategory(classPKInfoItemIdentifier.getClassPK());
        if (assetCategory == null) {
            return null;
        }
        AssetCategory parentCategory = assetCategory.getParentCategory();
        if (parentCategory == null) {
            return null;
        }
        return new AssetCategoryLayoutDisplayPageObjectProvider(parentCategory, this._portal);
    }

    public boolean inheritable() {
        return true;
    }

    protected AssetCategoryLayoutDisplayPageObjectProvider doGetLayoutDisplayPageObjectProvider(long groupId, InfoItemReference infoItemReference) {
        InfoItemIdentifier infoItemIdentifier = infoItemReference.getInfoItemIdentifier();
        if (!(infoItemIdentifier instanceof ClassPKInfoItemIdentifier) && !(infoItemIdentifier instanceof ERCInfoItemIdentifier)) {
            return null;
        }
        AssetCategory assetCategory = null;
        if (infoItemIdentifier instanceof ClassPKInfoItemIdentifier) {
            ClassPKInfoItemIdentifier classPKInfoItemIdentifier = (ClassPKInfoItemIdentifier)infoItemIdentifier;
            assetCategory = this._assetCategoryLocalService.fetchAssetCategory(classPKInfoItemIdentifier.getClassPK());
        } else {
            ERCInfoItemIdentifier ercInfoItemIdentifier = (ERCInfoItemIdentifier)infoItemIdentifier;
            assetCategory = this._assetCategoryLocalService.fetchAssetCategoryByExternalReferenceCode(ercInfoItemIdentifier.getExternalReferenceCode(), groupId);
        }
        if (assetCategory == null) {
            return null;
        }
        return new AssetCategoryLayoutDisplayPageObjectProvider(assetCategory, this._portal);
    }
}

