/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.categories.internal.layout.display.page;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.asset.kernel.service.AssetVocabularyLocalService;
import com.liferay.info.field.InfoField;
import com.liferay.info.field.InfoFieldValue;
import com.liferay.info.field.type.InfoFieldType;
import com.liferay.info.field.type.TextInfoFieldType;
import com.liferay.info.item.InfoItemFieldValues;
import com.liferay.info.item.InfoItemReference;
import com.liferay.info.localized.InfoLocalizedValue;
import com.liferay.layout.display.page.LayoutDisplayPageInfoItemFieldValuesProvider;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={LayoutDisplayPageInfoItemFieldValuesProvider.class})
public class AssetCategoryLayoutDisplayPageInfoItemFieldValuesProvider
implements LayoutDisplayPageInfoItemFieldValuesProvider<AssetCategory> {
    @Reference
    private AssetCategoryLocalService _assetCategoryLocalService;
    @Reference
    private AssetVocabularyLocalService _assetVocabularyLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private Language _language;

    public String getClassName() {
        return AssetCategory.class.getName();
    }

    public InfoItemFieldValues getInfoItemFieldValues(AssetCategory assetCategory) {
        Group group;
        if (assetCategory == null) {
            return InfoItemFieldValues.builder().build();
        }
        ArrayList<InfoFieldValue> assetCategoryInfoFieldValues = new ArrayList<InfoFieldValue>();
        AssetVocabulary assetVocabulary = this._assetVocabularyLocalService.fetchAssetVocabulary(assetCategory.getVocabularyId());
        if (assetVocabulary != null) {
            assetCategoryInfoFieldValues.add(new InfoFieldValue(InfoField.builder().infoFieldType((InfoFieldType)TextInfoFieldType.INSTANCE).namespace(AssetCategory.class.getSimpleName()).name("vocabulary").labelInfoLocalizedValue(InfoLocalizedValue.localize(AssetCategoryLayoutDisplayPageInfoItemFieldValuesProvider.class, (String)"vocabulary")).build(), (Object)InfoLocalizedValue.builder().defaultLocale(LocaleUtil.fromLanguageId((String)assetVocabulary.getDefaultLanguageId())).values(assetVocabulary.getTitleMap()).build()));
        }
        if ((group = this._groupLocalService.fetchGroup(assetCategory.getGroupId())) != null) {
            assetCategoryInfoFieldValues.add(new InfoFieldValue(InfoField.builder().infoFieldType((InfoFieldType)TextInfoFieldType.INSTANCE).namespace(AssetCategory.class.getSimpleName()).name("group").labelInfoLocalizedValue(InfoLocalizedValue.localize(AssetCategoryLayoutDisplayPageInfoItemFieldValuesProvider.class, (String)"site")).build(), (Object)InfoLocalizedValue.builder().defaultLocale(LocaleUtil.fromLanguageId((String)group.getDefaultLanguageId())).values((Map)HashMapBuilder.put((Collection)this._language.getAvailableLocales(), locale -> group.getDescriptiveName(locale)).build()).build()));
        }
        return InfoItemFieldValues.builder().infoFieldValues(assetCategoryInfoFieldValues).infoItemReference(new InfoItemReference(AssetCategory.class.getName(), assetCategory.getCategoryId())).build();
    }

    public InfoItemFieldValues getInfoItemFieldValues(long categoryId) {
        return this.getInfoItemFieldValues(this._assetCategoryLocalService.fetchAssetCategory(categoryId));
    }
}

