/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.categories.internal.search.spi.model.index.contributor;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.asset.kernel.service.AssetVocabularyLocalService;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentContributor;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={DocumentContributor.class})
public class AssetCategoryDocumentContributor
implements DocumentContributor<AssetCategory> {
    private static final String _DELIMITER = "&&";
    private static final Log _log = LogFactoryUtil.getLog(AssetCategoryDocumentContributor.class);
    @Reference
    private AssetCategoryLocalService _assetCategoryLocalService;
    @Reference
    private AssetVocabularyLocalService _assetVocabularyLocalService;
    @Reference
    private GroupLocalService _groupLocalService;

    public void contribute(Document document, BaseModel<AssetCategory> baseModel) {
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext != null && serviceContext.isStrictAdd()) {
            return;
        }
        String className = document.get("entryClassName");
        long classPK = GetterUtil.getLong((String)document.get("entryClassPK"));
        if (Validator.isNull((String)className) || classPK <= 0L) {
            return;
        }
        List assetCategories = this._assetCategoryLocalService.getCategories(className, classPK);
        Map<Integer, Map<Long, List<AssetCategory>>> assetVocabularyVisibilityTypeMap = this._getAssetVocabularyVisibilityTypeMap(assetCategories);
        this._addAssetCategoriesFields(document, "groupAssetCategoryExternalReferenceCodes", "assetCategoryIds", "assetCategoryTitles", "assetVocabularyIds", assetVocabularyVisibilityTypeMap.get(0));
        this._addAssetCategoriesFields(document, "groupAssetInternalCategoryExternalReferenceCodes", "assetInternalCategoryIds", "assetInternalCategoryTitles", "assetInternalVocabularyIds", assetVocabularyVisibilityTypeMap.get(1));
        this._addAssetVocabularyCategoriesFields(document, assetVocabularyVisibilityTypeMap.get(0));
    }

    private void _addAssetCategoriesFields(Document document, String assetCategoryExternalReferenceCodeFieldName, String assetCategoryIdsFieldName, String assetCategoryTitlesFieldName, String assetVocabularyIdsFieldName, Map<Long, List<AssetCategory>> assetVocabularyMap) {
        ArrayList<AssetCategory> assetCategories = new ArrayList<AssetCategory>();
        ArrayList<String> assetCategoryExternalReferenceCodes = new ArrayList<String>();
        long[] assetVocabularyIds = new long[]{};
        if (MapUtil.isNotEmpty(assetVocabularyMap)) {
            for (Map.Entry<Long, List<AssetCategory>> entry : assetVocabularyMap.entrySet()) {
                assetCategories.addAll((Collection)entry.getValue());
                for (AssetCategory assetCategory : entry.getValue()) {
                    assetCategoryExternalReferenceCodes.add(this._getGroupAssetCategoryExternalReferenceCode(assetCategory));
                }
                assetVocabularyIds = ArrayUtil.append((long[])assetVocabularyIds, (long)entry.getKey());
            }
        }
        document.addKeyword(assetCategoryExternalReferenceCodeFieldName, ArrayUtil.toStringArray(assetCategoryExternalReferenceCodes));
        long[] assetCategoryIds = ListUtil.toLongArray(assetCategories, (Accessor)AssetCategory.CATEGORY_ID_ACCESSOR);
        document.addKeyword(assetCategoryIdsFieldName, assetCategoryIds);
        document.addKeyword(assetVocabularyIdsFieldName, assetVocabularyIds);
        this._addAssetCategoryTitles(document, assetCategoryTitlesFieldName, assetCategories);
    }

    private void _addAssetCategoryTitles(Document document, String field, List<AssetCategory> assetCategories) {
        HashMap<Locale, List> assetCategoryTitles = new HashMap<Locale, List>();
        for (AssetCategory assetCategory : assetCategories) {
            Map titleMap = assetCategory.getTitleMap();
            for (Map.Entry entry : titleMap.entrySet()) {
                String title = (String)entry.getValue();
                if (Validator.isNull((String)title)) continue;
                Locale locale = (Locale)entry.getKey();
                List titles = assetCategoryTitles.computeIfAbsent(locale, k -> new ArrayList());
                titles.add(StringUtil.toLowerCase((String)title));
            }
        }
        for (Map.Entry entry : assetCategoryTitles.entrySet()) {
            Locale locale = (Locale)entry.getKey();
            List titles = (List)entry.getValue();
            String[] titlesArray = titles.toArray(new String[0]);
            document.addText(StringBundler.concat((Object[])new Object[]{field, "_", locale}), titlesArray);
        }
    }

    private void _addAssetVocabularyCategoriesFields(Document document, Map<Long, List<AssetCategory>> assetVocabularyMap) {
        Object[] assetVocabularyCategories = new String[]{};
        Object[] assetVocabularyCategoryExternalReferenceCodes = new String[]{};
        if (MapUtil.isNotEmpty(assetVocabularyMap)) {
            for (Map.Entry<Long, List<AssetCategory>> entry : assetVocabularyMap.entrySet()) {
                assetVocabularyCategories = (String[])ArrayUtil.append((Object[])assetVocabularyCategories, (Object[])((String[])TransformUtil.transformToArray((Collection)entry.getValue(), assetCategory -> assetCategory.getVocabularyId() + "-" + assetCategory.getCategoryId(), String.class)));
                assetVocabularyCategoryExternalReferenceCodes = (String[])ArrayUtil.append((Object[])assetVocabularyCategoryExternalReferenceCodes, (Object[])((String[])TransformUtil.transformToArray((Collection)entry.getValue(), assetCategory -> this._getGroupAssetVocabularyCategoryExternalReferenceCode((AssetCategory)assetCategory), String.class)));
            }
        }
        document.addKeyword("assetVocabularyCategoryIds", (String[])assetVocabularyCategories);
        document.addKeyword("groupAssetVocabularyCategoryExternalReferenceCodes", (String[])assetVocabularyCategoryExternalReferenceCodes);
    }

    private Map<Integer, Map<Long, List<AssetCategory>>> _getAssetVocabularyVisibilityTypeMap(List<AssetCategory> assetCategories) {
        HashMap<Integer, Map<Long, List<AssetCategory>>> assetVocabularyVisibilityTypeMap = new HashMap<Integer, Map<Long, List<AssetCategory>>>();
        HashMap<Long, Integer> assetVocabularyMap = new HashMap<Long, Integer>();
        for (AssetCategory assetCategory : assetCategories) {
            Integer visibilityType = assetVocabularyMap.computeIfAbsent(assetCategory.getVocabularyId(), vocabularyId -> {
                AssetVocabulary assetVocabulary = this._assetVocabularyLocalService.fetchAssetVocabulary(assetCategory.getVocabularyId());
                if (assetVocabulary == null) {
                    return -1;
                }
                return assetVocabulary.getVisibilityType();
            });
            Map assetVocabularyAssetCategoriesMap = assetVocabularyVisibilityTypeMap.computeIfAbsent(visibilityType, key -> new HashMap());
            List assetVocabularyAssetCategories = assetVocabularyAssetCategoriesMap.computeIfAbsent(assetCategory.getVocabularyId(), key -> new ArrayList());
            assetVocabularyAssetCategories.add(assetCategory);
        }
        return assetVocabularyVisibilityTypeMap;
    }

    private String _getGroupAssetCategoryExternalReferenceCode(AssetCategory assetCategory) {
        return StringBundler.concat((String[])new String[]{this._getGroupExternalReferenceCode(assetCategory.getGroupId()), _DELIMITER, assetCategory.getExternalReferenceCode()});
    }

    private String _getGroupAssetVocabularyCategoryExternalReferenceCode(AssetCategory assetCategory) {
        String assetVocabularyExternalReferenceCode;
        block2: {
            assetVocabularyExternalReferenceCode = "";
            try {
                AssetVocabulary assetVocabulary = this._assetVocabularyLocalService.getAssetVocabulary(assetCategory.getVocabularyId());
                assetVocabularyExternalReferenceCode = assetVocabulary.getExternalReferenceCode();
            }
            catch (PortalException portalException) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)("Unable to get asset vocabulary " + assetCategory.getVocabularyId() + " while indexing document"), (Throwable)portalException);
            }
        }
        return StringBundler.concat((String[])new String[]{this._getGroupExternalReferenceCode(assetCategory.getGroupId()), _DELIMITER, assetVocabularyExternalReferenceCode, _DELIMITER, assetCategory.getExternalReferenceCode()});
    }

    private String _getGroupExternalReferenceCode(long groupId) {
        String groupExternalReferenceCode;
        block2: {
            groupExternalReferenceCode = "";
            try {
                Group group = this._groupLocalService.getGroup(groupId);
                groupExternalReferenceCode = group.getExternalReferenceCode();
            }
            catch (PortalException portalException) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)("Unable to get group " + groupId + " while indexing document"), (Throwable)portalException);
            }
        }
        return groupExternalReferenceCode;
    }
}

