/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.categories.internal.layout.display.page;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.asset.kernel.service.AssetVocabularyLocalService;
import com.liferay.info.item.ClassPKInfoItemIdentifier;
import com.liferay.info.item.HierarchicalInfoItemReference;
import com.liferay.info.item.InfoItemReference;
import com.liferay.layout.display.page.LayoutDisplayPageMultiSelectionProvider;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.asset.util.comparator.AssetVocabularyGroupLocalizedTitleComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={LayoutDisplayPageMultiSelectionProvider.class})
public class AssetCategoryLayoutDisplayPageMultiSelectionProvider
implements LayoutDisplayPageMultiSelectionProvider<AssetCategory> {
    @Reference
    private AssetCategoryLocalService _assetCategoryLocalService;
    @Reference
    private AssetVocabularyLocalService _assetVocabularyLocalService;
    @Reference
    private Language _language;

    public String getClassName() {
        return AssetCategory.class.getName();
    }

    public String getPluralLabel(Locale locale) {
        return this._language.get(locale, "categories");
    }

    public List<InfoItemReference> process(List<InfoItemReference> infoItemReferences) {
        HashMap<Long, Map> vocabularyIdInfoItemReferencesMap = new HashMap<Long, Map>();
        for (InfoItemReference infoItemReference : infoItemReferences) {
            long classPK = this._getClassPK(infoItemReference);
            if (!Objects.equals(this.getClassName(), infoItemReference.getClassName()) || classPK <= 0L) continue;
            AssetCategory assetCategory = this._assetCategoryLocalService.fetchAssetCategory(classPK);
            Map categoryIdInfoItemReferencesMap = vocabularyIdInfoItemReferencesMap.computeIfAbsent(assetCategory.getVocabularyId(), key -> new HashMap());
            categoryIdInfoItemReferencesMap.put(classPK, infoItemReference);
        }
        ArrayList<InfoItemReference> hierarchicalInfoItemReferences = new ArrayList<InfoItemReference>();
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        ThemeDisplay themeDisplay = serviceContext.getThemeDisplay();
        for (long vocabularyId : this._getOrderedVocabularyIds(themeDisplay)) {
            Map categoryIdInfoItemReferences = (Map)vocabularyIdInfoItemReferencesMap.get(vocabularyId);
            if (MapUtil.isEmpty((Map)categoryIdInfoItemReferences)) continue;
            Set<Long> categoryIds = categoryIdInfoItemReferences.keySet();
            HashMap<Long, List<InfoItemReference>> parentCategoryIdInfoItemReferencesMap = new HashMap<Long, List<InfoItemReference>>();
            for (InfoItemReference infoItemReference : categoryIdInfoItemReferences.values()) {
                long parentCategoryId = this._getNearestAncestorCategoryId(this._assetCategoryLocalService.fetchAssetCategory(this._getClassPK(infoItemReference)), categoryIds);
                ArrayList<InfoItemReference> parentCategoryIdInfoItemReferences = (ArrayList<InfoItemReference>)parentCategoryIdInfoItemReferencesMap.get(parentCategoryId);
                if (parentCategoryIdInfoItemReferences == null) {
                    parentCategoryIdInfoItemReferences = new ArrayList<InfoItemReference>();
                    parentCategoryIdInfoItemReferencesMap.put(parentCategoryId, parentCategoryIdInfoItemReferences);
                }
                parentCategoryIdInfoItemReferences.add(infoItemReference);
            }
            hierarchicalInfoItemReferences.addAll(this._getHierarchicalInfoItemReferences(parentCategoryIdInfoItemReferencesMap, 0L));
        }
        return hierarchicalInfoItemReferences;
    }

    private long _getClassPK(InfoItemReference infoItemReference) {
        if (infoItemReference.getInfoItemIdentifier() instanceof ClassPKInfoItemIdentifier) {
            ClassPKInfoItemIdentifier classPKInfoItemIdentifier = (ClassPKInfoItemIdentifier)infoItemReference.getInfoItemIdentifier();
            return classPKInfoItemIdentifier.getClassPK();
        }
        return 0L;
    }

    private List<HierarchicalInfoItemReference> _getHierarchicalInfoItemReferences(Map<Long, List<InfoItemReference>> parentCategoryIdInfoItemReferencesMap, long parentCategoryId) {
        if (!parentCategoryIdInfoItemReferencesMap.containsKey(parentCategoryId)) {
            return Collections.emptyList();
        }
        List infoItemReferences = ListUtil.sort(parentCategoryIdInfoItemReferencesMap.get(parentCategoryId), Comparator.comparing(infoItemReference -> {
            AssetCategory assetCategory = this._assetCategoryLocalService.fetchAssetCategory(this._getClassPK((InfoItemReference)infoItemReference));
            return assetCategory.getName();
        }));
        return TransformUtil.transform((Collection)infoItemReferences, infoItemReference -> {
            HierarchicalInfoItemReference hierarchicalInfoItemReference = new HierarchicalInfoItemReference(infoItemReference.getClassName(), infoItemReference.getInfoItemIdentifier());
            hierarchicalInfoItemReference.setChildrenHierarchicalInfoItemReferences(this._getHierarchicalInfoItemReferences(parentCategoryIdInfoItemReferencesMap, this._getClassPK((InfoItemReference)infoItemReference)));
            return hierarchicalInfoItemReference;
        });
    }

    private long _getNearestAncestorCategoryId(AssetCategory assetCategory, Set<Long> availableCategoryIds) {
        List categoryIds = TransformUtil.transformToList((Object[])StringUtil.split((String)assetCategory.getTreePath(), (String)"/"), treePathPart -> {
            if (Validator.isNull((String)treePathPart)) {
                return null;
            }
            Long categoryId = Long.valueOf(treePathPart);
            if (Objects.equals(categoryId, assetCategory.getCategoryId()) || !availableCategoryIds.contains(categoryId)) {
                return null;
            }
            return categoryId;
        });
        if (categoryIds.isEmpty()) {
            return 0L;
        }
        categoryIds.sort(Collections.reverseOrder());
        return (Long)categoryIds.get(0);
    }

    private List<Long> _getOrderedVocabularyIds(ThemeDisplay themeDisplay) {
        List assetVocabularies = this._assetVocabularyLocalService.getGroupVocabularies(new long[]{themeDisplay.getCompanyGroupId(), themeDisplay.getScopeGroupId()}, new int[]{0});
        if (assetVocabularies.isEmpty()) {
            return Collections.emptyList();
        }
        ListUtil.sort((List)assetVocabularies, (Comparator)new AssetVocabularyGroupLocalizedTitleComparator(themeDisplay.getScopeGroupId(), themeDisplay.getLocale(), true));
        return ListUtil.toList((List)assetVocabularies, (Accessor)AssetVocabulary.VOCABULARY_ID_ACCESSOR);
    }
}

