/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.categories.internal.struts;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.service.AssetCategoryService;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.struts.StrutsAction;
import com.liferay.portal.kernel.util.ParamUtil;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"path=/asset/get_categories"}, service={StrutsAction.class})
public class GetCategoriesStrutsAction
implements StrutsAction {
    @Reference
    private AssetCategoryService _assetCategoryService;
    @Reference
    private JSONFactory _jsonFactory;

    public String execute(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        JSONArray jsonArray = this._jsonFactory.createJSONArray();
        List<AssetCategory> assetCategories = this.getCategories(httpServletRequest);
        for (AssetCategory assetCategory : assetCategories) {
            List childAssetCategories = this._assetCategoryService.getChildCategories(assetCategory.getCategoryId());
            jsonArray.put(JSONUtil.put((String)"categoryId", (Object)assetCategory.getCategoryId()).put("childrenCount", childAssetCategories.size()).put("hasChildren", !childAssetCategories.isEmpty()).put("name", assetCategory.getName()).put("parentCategoryId", assetCategory.getParentCategoryId()).put("titleCurrentValue", assetCategory.getTitleCurrentValue()));
        }
        ServletResponseUtil.write((HttpServletResponse)httpServletResponse, (String)jsonArray.toString());
        return null;
    }

    protected List<AssetCategory> getCategories(HttpServletRequest httpServletRequest) throws Exception {
        List assetCategories = Collections.emptyList();
        long scopeGroupId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"scopeGroupId");
        long categoryId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"categoryId");
        long vocabularyId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"vocabularyId");
        int start = ParamUtil.getInteger((HttpServletRequest)httpServletRequest, (String)"start", (int)-1);
        int end = ParamUtil.getInteger((HttpServletRequest)httpServletRequest, (String)"end", (int)-1);
        if (categoryId > 0L) {
            assetCategories = scopeGroupId > 0L ? this._assetCategoryService.getVocabularyCategories(scopeGroupId, categoryId, vocabularyId, start, end, null) : this._assetCategoryService.getChildCategories(categoryId, start, end, null);
        } else if (vocabularyId > 0L) {
            long parentCategoryId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"parentCategoryId", (long)0L);
            assetCategories = scopeGroupId > 0L ? this._assetCategoryService.getVocabularyCategories(scopeGroupId, parentCategoryId, vocabularyId, start, end, null) : this._assetCategoryService.getVocabularyCategories(parentCategoryId, vocabularyId, start, end, null);
        }
        return assetCategories;
    }
}

