/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.categories.internal.validator;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.exception.AssetCategoryException;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.asset.kernel.service.AssetVocabularyLocalService;
import com.liferay.asset.kernel.validator.AssetEntryValidator;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.util.Portal;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"model.class.name=*"}, service={AssetEntryValidator.class})
public class CardinalityAssetEntryValidator
implements AssetEntryValidator {
    private static final Log _log = LogFactoryUtil.getLog((String)CardinalityAssetEntryValidator.class.getName());
    @Reference
    private AssetVocabularyLocalService _assetVocabularyLocalService;
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private Portal _portal;

    public void validate(long groupId, String className, long classPK, long classTypePK, long[] categoryIds, String[] entryNames) throws PortalException {
        long classNameId = this._classNameLocalService.getClassNameId(className);
        if (!this.isCategorizable(groupId, classNameId, classPK)) {
            return;
        }
        if (className.equals(Group.class.getName())) {
            groupId = classPK;
        }
        for (AssetVocabulary assetVocabulary : this._assetVocabularyLocalService.getGroupsVocabularies(this._portal.getCurrentAndAncestorSiteGroupIds(groupId))) {
            this.validate(classNameId, classTypePK, categoryIds, assetVocabulary);
        }
    }

    @Deprecated
    public void validate(long groupId, String className, long classTypePK, long[] categoryIds, String[] entryNames) throws PortalException {
        this.validate(groupId, className, 0L, classTypePK, categoryIds, entryNames);
    }

    protected boolean isCategorizable(long groupId, long classNameId, long classPK) {
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)this._portal.getClassName(classNameId));
        if (assetRendererFactory == null || !assetRendererFactory.isCategorizable()) {
            return false;
        }
        if (classPK != 0L) {
            try {
                AssetRenderer assetRenderer = assetRendererFactory.getAssetRenderer(classPK);
                if (!assetRenderer.isCategorizable(groupId)) {
                    return false;
                }
            }
            catch (PortalException portalException) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Entity with ClassPK: ", classPK, " and ClassNameId: ", classNameId, " is not categorizable"}), (Throwable)portalException);
                }
                return false;
            }
        }
        return true;
    }

    protected void validate(long classNameId, long classTypePK, long[] categoryIds, AssetVocabulary assetVocabulary) throws PortalException {
        if (!assetVocabulary.isAssociatedToClassNameIdAndClassTypePK(classNameId, classTypePK)) {
            return;
        }
        if (assetVocabulary.isMissingRequiredCategory(classNameId, classTypePK, categoryIds)) {
            throw new AssetCategoryException(assetVocabulary, 1);
        }
        if (!assetVocabulary.isMultiValued() && assetVocabulary.hasMoreThanOneCategorySelected(categoryIds)) {
            throw new AssetCategoryException(assetVocabulary, 2);
        }
    }
}

