/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.categories.internal.search.spi.model.index.contributor;

import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.search.localization.SearchLocalizationHelper;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"indexer.class.name=com.liferay.asset.kernel.model.AssetVocabulary"}, service={ModelDocumentContributor.class})
public class AssetVocabularyModelDocumentContributor
implements ModelDocumentContributor<AssetVocabulary> {
    @Reference
    private Portal _portal;
    @Reference
    private SearchLocalizationHelper _searchLocalizationHelper;

    public void contribute(Document document, AssetVocabulary assetVocabulary) {
        document.addKeyword("assetVocabularyId", assetVocabulary.getVocabularyId());
        Locale siteDefaultLocale = this._getSiteDefaultLocale(assetVocabulary.getGroupId());
        this._searchLocalizationHelper.addLocalizedField(document, "description", siteDefaultLocale, assetVocabulary.getDescriptionMap());
        document.addText("name", assetVocabulary.getName());
        this._searchLocalizationHelper.addLocalizedField(document, "title", siteDefaultLocale, assetVocabulary.getTitleMap());
        document.addLocalizedKeyword("localized_title", LocalizationUtil.populateLocalizationMap((Map)assetVocabulary.getTitleMap(), (String)assetVocabulary.getDefaultLanguageId(), (long)assetVocabulary.getGroupId()), true, true);
    }

    private Locale _getSiteDefaultLocale(long groupId) {
        try {
            return this._portal.getSiteDefaultLocale(groupId);
        }
        catch (PortalException portalException) {
            throw new SystemException((Throwable)portalException);
        }
    }
}

