/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.categories.internal.search.spi.model.index.contributor;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.localization.SearchLocalizationHelper;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"indexer.class.name=com.liferay.asset.kernel.model.AssetCategory"}, service={ModelDocumentContributor.class})
public class AssetCategoryModelDocumentContributor
implements ModelDocumentContributor<AssetCategory> {
    @Reference
    protected Portal portal;
    @Reference
    private SearchLocalizationHelper _searchLocalizationHelper;

    public void contribute(Document document, AssetCategory assetCategory) {
        document.addKeyword("assetCategoryId", assetCategory.getCategoryId());
        this.addSearchAssetCategoryTitles(document, "assetCategoryTitle", Collections.singletonList(assetCategory));
        document.addKeyword("parentCategoryId", assetCategory.getParentCategoryId());
        document.addKeyword("assetVocabularyId", assetCategory.getVocabularyId());
        Locale siteDefaultLocale = this.getSiteDefaultLocale(assetCategory);
        this._searchLocalizationHelper.addLocalizedField(document, "description", siteDefaultLocale, assetCategory.getDescriptionMap());
        document.addText("name", assetCategory.getName());
        this._searchLocalizationHelper.addLocalizedField(document, "title", siteDefaultLocale, assetCategory.getTitleMap());
        document.addKeyword("treePath", assetCategory.getTreePath());
        document.addLocalizedKeyword("localized_title", LocalizationUtil.populateLocalizationMap((Map)assetCategory.getTitleMap(), (String)assetCategory.getDefaultLanguageId(), (long)assetCategory.getGroupId()), true, true);
    }

    protected void addSearchAssetCategoryTitles(Document document, String field, List<AssetCategory> assetCategories) {
        HashMap<Locale, ArrayList<String>> assetCategoryTitles = new HashMap<Locale, ArrayList<String>>();
        Locale defaultLocale = LocaleUtil.getDefault();
        for (AssetCategory assetCategory : assetCategories) {
            Map titleMap = assetCategory.getTitleMap();
            for (Map.Entry entry : titleMap.entrySet()) {
                String title = (String)entry.getValue();
                if (Validator.isBlank((String)title)) continue;
                Locale locale = (Locale)entry.getKey();
                ArrayList<String> titles = (ArrayList<String>)assetCategoryTitles.get(locale);
                if (titles == null) {
                    titles = new ArrayList<String>();
                    assetCategoryTitles.put(locale, titles);
                }
                titles.add(StringUtil.toLowerCase((String)title));
            }
        }
        for (Map.Entry entry : assetCategoryTitles.entrySet()) {
            Locale locale = (Locale)entry.getKey();
            List titles = (List)entry.getValue();
            String[] titlesArray = titles.toArray(new String[0]);
            if (locale.equals(defaultLocale)) {
                document.addText(field, titlesArray);
            }
            document.addText(StringBundler.concat((Object[])new Object[]{field, "_", locale}), titlesArray);
        }
    }

    protected Locale getSiteDefaultLocale(AssetCategory assetCategory) {
        try {
            return this.portal.getSiteDefaultLocale(assetCategory.getGroupId());
        }
        catch (PortalException portalException) {
            throw new SystemException((Throwable)portalException);
        }
    }
}

