/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.categories.internal.search.spi.model.index.contributor;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.asset.kernel.service.AssetVocabularyLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentContributor;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={DocumentContributor.class})
public class AssetCategoryDocumentContributor
implements DocumentContributor<AssetCategory> {
    @Reference
    private AssetCategoryLocalService _assetCategoryLocalService;
    @Reference
    private AssetVocabularyLocalService _assetVocabularyLocalService;

    public void contribute(Document document, BaseModel<AssetCategory> baseModel) {
        this._addAssetCategoriesFields(document, "assetCategoryIds", "assetCategoryTitles", 0);
        this._addAssetCategoriesFields(document, "assetInternalCategoryIds", "assetInternalCategoryTitles", 1);
    }

    private void _addAssetCategoriesFields(Document document, String assetCategoryIdsFieldName, String assetCategoryTitlesFieldName, int visibilityType) {
        HashMap<Long, AssetVocabulary> assetVocabulariesMap = new HashMap<Long, AssetVocabulary>();
        ArrayList<AssetCategory> filteredAssetCategories = new ArrayList<AssetCategory>();
        String className = document.get("entryClassName");
        long classPK = GetterUtil.getLong((String)document.get("entryClassPK"));
        List assetCategories = this._assetCategoryLocalService.getCategories(className, classPK);
        for (AssetCategory assetCategory : assetCategories) {
            AssetVocabulary assetVocabulary = assetVocabulariesMap.computeIfAbsent(assetCategory.getVocabularyId(), vocabularyId -> this._assetVocabularyLocalService.fetchAssetVocabulary(vocabularyId.longValue()));
            if (assetVocabulary == null || assetVocabulary.getVisibilityType() != visibilityType) continue;
            filteredAssetCategories.add(assetCategory);
        }
        long[] filteredAssetCategoryIds = ListUtil.toLongArray(filteredAssetCategories, (Accessor)AssetCategory.CATEGORY_ID_ACCESSOR);
        document.addKeyword(assetCategoryIdsFieldName, filteredAssetCategoryIds);
        this._addAssetCategoryTitles(document, assetCategoryTitlesFieldName, filteredAssetCategories);
    }

    private void _addAssetCategoryTitles(Document document, String field, List<AssetCategory> assetCategories) {
        HashMap<Locale, List> assetCategoryTitles = new HashMap<Locale, List>();
        for (AssetCategory assetCategory : assetCategories) {
            Map titleMap = assetCategory.getTitleMap();
            for (Map.Entry entry : titleMap.entrySet()) {
                String title = (String)entry.getValue();
                if (Validator.isNull((String)title)) continue;
                Locale locale = (Locale)entry.getKey();
                List titles = assetCategoryTitles.computeIfAbsent(locale, k -> new ArrayList());
                titles.add(StringUtil.toLowerCase((String)title));
            }
        }
        for (Map.Entry entry : assetCategoryTitles.entrySet()) {
            Locale locale = (Locale)entry.getKey();
            List titles = (List)entry.getValue();
            String[] titlesArray = titles.toArray(new String[0]);
            document.addText(StringBundler.concat((Object[])new Object[]{field, "_", locale}), titlesArray);
        }
    }
}

