/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.application.list.util;

import com.liferay.application.list.PanelCategory;
import com.liferay.application.list.PanelEntry;
import com.liferay.application.list.display.context.logic.PanelCategoryHelper;
import com.liferay.osgi.service.tracker.collections.map.PropertyServiceReferenceComparator;
import com.liferay.osgi.service.tracker.collections.map.PropertyServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapperFactory;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.Collections;
import java.util.List;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class PanelCategoryRegistryUtil {
    private static final Log _log = LogFactoryUtil.getLog(PanelCategoryRegistryUtil.class);
    private static final ServiceTrackerMap<String, List<PanelCategory>> _childPanelCategoriesServiceTrackerMap;
    private static final ServiceTrackerMap<String, PanelCategory> _panelCategoryServiceTrackerMap;

    public static List<PanelCategory> getChildPanelCategories(PanelCategory panelCategory) {
        return PanelCategoryRegistryUtil.getChildPanelCategories(panelCategory.getKey());
    }

    public static List<PanelCategory> getChildPanelCategories(PanelCategory panelCategory, PermissionChecker permissionChecker, Group group) {
        return PanelCategoryRegistryUtil.getChildPanelCategories(panelCategory.getKey(), permissionChecker, group);
    }

    public static List<PanelCategory> getChildPanelCategories(String panelCategoryKey) {
        List childPanelCategories = (List)_childPanelCategoriesServiceTrackerMap.getService((Object)panelCategoryKey);
        if (childPanelCategories == null) {
            return Collections.emptyList();
        }
        return childPanelCategories;
    }

    public static List<PanelCategory> getChildPanelCategories(String panelCategoryKey, PermissionChecker permissionChecker, Group group) {
        List<PanelCategory> panelCategories = PanelCategoryRegistryUtil.getChildPanelCategories(panelCategoryKey);
        if (panelCategories.isEmpty()) {
            return panelCategories;
        }
        return ListUtil.filter(panelCategories, panelCategory -> {
            try {
                return panelCategory.isShow(permissionChecker, group);
            }
            catch (PortalException portalException) {
                _log.error((Throwable)portalException);
                return false;
            }
        });
    }

    public static int getChildPanelCategoriesNotificationsCount(PanelCategoryHelper panelCategoryHelper, String panelCategoryKey, PermissionChecker permissionChecker, Group group, User user) {
        int count = 0;
        for (PanelCategory panelCategory : PanelCategoryRegistryUtil.getChildPanelCategories(panelCategoryKey)) {
            int notificationsCount = panelCategory.getNotificationsCount(panelCategoryHelper, permissionChecker, group, user);
            try {
                if (notificationsCount <= 0 || !panelCategory.isShow(permissionChecker, group)) continue;
                count += notificationsCount;
            }
            catch (PortalException portalException) {
                _log.error((Throwable)portalException);
            }
        }
        return count;
    }

    public static PanelCategory getFirstChildPanelCategory(String panelCategoryKey, PermissionChecker permissionChecker, Group group) {
        List<PanelCategory> panelCategories = PanelCategoryRegistryUtil.getChildPanelCategories(panelCategoryKey);
        for (PanelCategory panelCategory : panelCategories) {
            try {
                if (!panelCategory.isShow(permissionChecker, group)) continue;
                return panelCategory;
            }
            catch (PortalException portalException) {
                _log.error((Throwable)portalException);
            }
        }
        return null;
    }

    public static PanelCategory getPanelCategory(String panelCategoryKey) {
        PanelCategory panelCategory = (PanelCategory)_panelCategoryServiceTrackerMap.getService((Object)panelCategoryKey);
        if (panelCategory == null) {
            throw new IllegalArgumentException("No panel category found with key " + panelCategoryKey);
        }
        return panelCategory;
    }

    static {
        Bundle bundle = FrameworkUtil.getBundle(PanelCategoryRegistryUtil.class);
        BundleContext bundleContext = bundle.getBundleContext();
        _childPanelCategoriesServiceTrackerMap = ServiceTrackerMapFactory.openMultiValueMap((BundleContext)bundleContext, PanelCategory.class, null, (ServiceReferenceMapper)new PropertyServiceReferenceMapper("panel.category.key"), Collections.reverseOrder(new PropertyServiceReferenceComparator("panel.category.order")));
        _panelCategoryServiceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, PanelCategory.class, null, (ServiceReferenceMapper)ServiceReferenceMapperFactory.createFromFunction((BundleContext)bundleContext, PanelEntry::getKey));
    }
}

