/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.application.list.display.context.logic;

import com.liferay.application.list.PanelApp;
import com.liferay.application.list.PanelAppRegistry;
import com.liferay.application.list.PanelCategory;
import com.liferay.application.list.util.PanelCategoryRegistryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import java.util.ArrayList;
import java.util.List;

public class PanelCategoryHelper {
    private final PanelAppRegistry _panelAppRegistry;

    public PanelCategoryHelper(PanelAppRegistry panelAppRegistry) {
        this._panelAppRegistry = panelAppRegistry;
    }

    public boolean containsPortlet(String portletId, String panelCategoryKey) {
        for (PanelCategory curPanelCategory : PanelCategoryRegistryUtil.getChildPanelCategories(panelCategoryKey)) {
            if (!this.hasPortlet(portletId, curPanelCategory.getKey()) && !this.containsPortlet(portletId, curPanelCategory.getKey())) continue;
            return true;
        }
        return this.hasPortlet(portletId, panelCategoryKey);
    }

    public boolean containsPortlet(String portletId, String panelCategoryKey, PermissionChecker permissionChecker, Group group) {
        for (PanelCategory curPanelCategory : PanelCategoryRegistryUtil.getChildPanelCategories(panelCategoryKey, permissionChecker, group)) {
            if (!this.hasPortlet(portletId, curPanelCategory.getKey(), permissionChecker, group) && !this.containsPortlet(portletId, curPanelCategory.getKey(), permissionChecker, group)) continue;
            return true;
        }
        return this.hasPortlet(portletId, panelCategoryKey, permissionChecker, group);
    }

    public List<PanelApp> getAllPanelApps(String panelCategoryKey) {
        ArrayList<PanelApp> panelApps = new ArrayList<PanelApp>();
        panelApps.addAll(this._panelAppRegistry.getPanelApps(panelCategoryKey));
        for (PanelCategory childPanelCategory : PanelCategoryRegistryUtil.getChildPanelCategories(panelCategoryKey)) {
            panelApps.addAll(this.getAllPanelApps(childPanelCategory.getKey()));
        }
        return panelApps;
    }

    public List<PanelCategory> getChildPanelCategories(String panelKey, ThemeDisplay themeDisplay) {
        return PanelCategoryRegistryUtil.getChildPanelCategories(panelKey, themeDisplay.getPermissionChecker(), themeDisplay.getScopeGroup());
    }

    public String getFirstPortletId(String panelCategoryKey, PermissionChecker permissionChecker, Group group) {
        PanelApp panelApp = this._panelAppRegistry.getFirstPanelApp(panelCategoryKey, permissionChecker, group);
        if (panelApp != null) {
            return panelApp.getPortletId();
        }
        List<PanelCategory> panelCategories = PanelCategoryRegistryUtil.getChildPanelCategories(panelCategoryKey, permissionChecker, group);
        if (panelCategories.isEmpty()) {
            return null;
        }
        for (PanelCategory panelCategory : panelCategories) {
            panelApp = this._panelAppRegistry.getFirstPanelApp(panelCategory.getKey(), permissionChecker, group);
            if (panelApp == null) continue;
            return panelApp.getPortletId();
        }
        return null;
    }

    public int getNotificationsCount(String panelCategoryKey, PermissionChecker permissionChecker, Group group, User user) {
        int count = PanelCategoryRegistryUtil.getChildPanelCategoriesNotificationsCount(this, panelCategoryKey, permissionChecker, group, user);
        return count += this._panelAppRegistry.getPanelAppsNotificationsCount(panelCategoryKey, permissionChecker, group, user);
    }

    public boolean hasPanelApp(String portletId) {
        return this.containsPortlet(portletId, "applications_menu") || this.containsPortlet(portletId, "root");
    }

    public boolean isApplicationsMenuApp(String portletId) {
        return this.containsPortlet(portletId, "applications_menu");
    }

    public boolean isControlPanelApp(String portletId) {
        return this.containsPortlet(portletId, "control_panel");
    }

    protected boolean hasPortlet(String portletId, String panelCategoryKey) {
        List<PanelApp> panelApps = this._panelAppRegistry.getPanelApps(panelCategoryKey);
        for (PanelApp panelApp : panelApps) {
            if (!portletId.equals(panelApp.getPortletId())) continue;
            return true;
        }
        return false;
    }

    protected boolean hasPortlet(String portletId, String panelCategoryKey, PermissionChecker permissionChecker, Group group) {
        List<PanelApp> panelApps = this._panelAppRegistry.getPanelApps(panelCategoryKey, permissionChecker, group);
        for (PanelApp panelApp : panelApps) {
            if (!portletId.equals(panelApp.getPortletId())) continue;
            return true;
        }
        return false;
    }
}

