/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.application.list.adapter;

import com.liferay.application.list.PanelApp;
import com.liferay.application.list.adapter.PortletPanelAppAdapter;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PortletCategoryUtil;
import java.util.Dictionary;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class PortletPanelAppAdapterServiceTrackerCustomizer
implements ServiceTrackerCustomizer<Portlet, PanelApp> {
    private final BundleContext _bundleContext;
    private final Map<ServiceReference<Portlet>, ServiceRegistration<PanelApp>> _serviceRegistrations;

    public PortletPanelAppAdapterServiceTrackerCustomizer(BundleContext bundleContext, Map<ServiceReference<Portlet>, ServiceRegistration<PanelApp>> serviceRegistrations) {
        this._bundleContext = bundleContext;
        this._serviceRegistrations = serviceRegistrations;
    }

    public PanelApp addingService(ServiceReference<Portlet> serviceReference) {
        String portletId = (String)serviceReference.getProperty("javax.portlet.name");
        if (Validator.isNull((String)portletId)) {
            return null;
        }
        String controlPanelCategory = (String)serviceReference.getProperty("com.liferay.portlet.control-panel-entry-category");
        if (Validator.isNull((String)controlPanelCategory)) {
            return null;
        }
        PortletPanelAppAdapter portletPanelAppAdapter = new PortletPanelAppAdapter(portletId, () -> (Portlet)this._bundleContext.getService(serviceReference));
        ServiceRegistration serviceRegistration = this._bundleContext.registerService(PanelApp.class, (Object)portletPanelAppAdapter, (Dictionary)HashMapDictionaryBuilder.put((Object)"panel.category.key", (Object)PortletCategoryUtil.getPortletCategoryKey((String)controlPanelCategory)).put((Object)"service.ranking", () -> this.getServiceRanking(serviceReference)).build());
        this._serviceRegistrations.put(serviceReference, (ServiceRegistration<PanelApp>)serviceRegistration);
        return portletPanelAppAdapter;
    }

    public void modifiedService(ServiceReference<Portlet> serviceReference, PanelApp panelApp) {
        this.removedService(serviceReference, panelApp);
        this.addingService((ServiceReference)serviceReference);
    }

    public void removedService(ServiceReference<Portlet> serviceReference, PanelApp panelApp) {
        ServiceRegistration<PanelApp> serviceRegistration = this._serviceRegistrations.remove(serviceReference);
        serviceRegistration.unregister();
    }

    protected Integer getServiceRanking(ServiceReference<Portlet> serviceReference) {
        String controlPanelEntryWeight = (String)serviceReference.getProperty("com.liferay.portlet.control-panel-entry-weight");
        if (Validator.isNull((String)controlPanelEntryWeight)) {
            return null;
        }
        return (int)Math.ceil(GetterUtil.getDouble((String)controlPanelEntryWeight) * 100.0);
    }
}

