/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.application.list;

import com.liferay.application.list.BasePanelApp;
import com.liferay.application.list.GroupProvider;
import com.liferay.application.list.PanelApp;
import com.liferay.application.list.PanelAppShowFilter;
import com.liferay.application.list.PanelCategory;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerListFactory;
import com.liferay.osgi.service.tracker.collections.map.PropertyServiceReferenceComparator;
import com.liferay.osgi.service.tracker.collections.map.PropertyServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceReferenceMapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.PortletLocalService;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.Collections;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(service={PanelAppRegistry.class})
public class PanelAppRegistry {
    private static final Log _log = LogFactoryUtil.getLog(PanelAppRegistry.class);
    @Reference
    private GroupProvider _groupProvider;
    @Reference
    private PortletLocalService _portletLocalService;
    private ServiceTrackerList<PanelAppShowFilter> _serviceTrackerList;
    private ServiceTrackerMap<String, List<PanelApp>> _serviceTrackerMap;

    public PanelApp getFirstPanelApp(String parentPanelCategoryKey, PermissionChecker permissionChecker, Group group) {
        List<PanelApp> panelApps = this.getPanelApps(parentPanelCategoryKey, permissionChecker, group);
        if (panelApps.isEmpty()) {
            return null;
        }
        return panelApps.get(0);
    }

    public List<PanelApp> getPanelApps(PanelCategory parentPanelCategory) {
        return this.getPanelApps(parentPanelCategory.getKey());
    }

    public List<PanelApp> getPanelApps(PanelCategory parentPanelCategory, PermissionChecker permissionChecker, Group group) {
        return this.getPanelApps(parentPanelCategory.getKey(), permissionChecker, group);
    }

    public List<PanelApp> getPanelApps(String parentPanelCategoryKey) {
        List panelApps = (List)this._serviceTrackerMap.getService((Object)parentPanelCategoryKey);
        if (panelApps == null) {
            return Collections.emptyList();
        }
        long companyId = CompanyThreadLocal.getCompanyId();
        return ListUtil.filter((List)panelApps, panelApp -> {
            Portlet portlet = panelApp.getPortlet();
            if (portlet == null) {
                return false;
            }
            long portletCompanyId = portlet.getCompanyId();
            return portletCompanyId == 0L || portletCompanyId == companyId;
        });
    }

    public List<PanelApp> getPanelApps(String parentPanelCategoryKey, PermissionChecker permissionChecker, Group group) {
        List<PanelApp> panelApps = this.getPanelApps(parentPanelCategoryKey);
        if (panelApps.isEmpty()) {
            return panelApps;
        }
        return ListUtil.filter(panelApps, panelApp -> {
            try {
                for (PanelAppShowFilter panelAppShowFilter : this._serviceTrackerList) {
                    if (panelAppShowFilter.isShow((PanelApp)panelApp, permissionChecker, group)) continue;
                    return false;
                }
                return panelApp.isShow(permissionChecker, group);
            }
            catch (PortalException portalException) {
                _log.error((Throwable)portalException);
                return false;
            }
        });
    }

    public int getPanelAppsNotificationsCount(String parentPanelCategoryKey, PermissionChecker permissionChecker, Group group, User user) {
        int count = 0;
        for (PanelApp panelApp : this.getPanelApps(parentPanelCategoryKey, permissionChecker, group)) {
            count += panelApp.getNotificationsCount(user);
        }
        return count;
    }

    @Activate
    protected void activate(final BundleContext bundleContext) {
        this._serviceTrackerList = ServiceTrackerListFactory.open((BundleContext)bundleContext, PanelAppShowFilter.class);
        this._serviceTrackerMap = ServiceTrackerMapFactory.openMultiValueMap((BundleContext)bundleContext, PanelApp.class, (String)"(panel.category.key=*)", (ServiceReferenceMapper)new PropertyServiceReferenceMapper("panel.category.key"), (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<PanelApp, PanelApp>(){

            public PanelApp addingService(ServiceReference<PanelApp> serviceReference) {
                PanelApp panelApp = (PanelApp)bundleContext.getService(serviceReference);
                panelApp.setGroupProvider(PanelAppRegistry.this._groupProvider);
                Portlet portlet = PanelAppRegistry.this._portletLocalService.getPortletById(panelApp.getPortletId());
                if (portlet != null) {
                    portlet.setControlPanelEntryCategory(String.valueOf(serviceReference.getProperty("panel.category.key")));
                } else if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Unable to get portlet " + panelApp.getPortletId()));
                }
                if (panelApp instanceof BasePanelApp) {
                    BasePanelApp basePanelApp = (BasePanelApp)panelApp;
                    basePanelApp.setPortletLocalService(PanelAppRegistry.this._portletLocalService);
                }
                return panelApp;
            }

            public void modifiedService(ServiceReference<PanelApp> serviceReference, PanelApp panelApp) {
            }

            public void removedService(ServiceReference<PanelApp> serviceReference, PanelApp panelApp) {
                bundleContext.ungetService(serviceReference);
            }
        }, Collections.reverseOrder(new PropertyServiceReferenceComparator("panel.app.order")));
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerList.close();
        this._serviceTrackerMap.close();
    }
}

