/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.app.builder.model.impl;

import com.liferay.app.builder.model.AppBuilderAppDeployment;
import com.liferay.app.builder.model.AppBuilderAppDeploymentModel;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the AppBuilderAppDeployment service. Represents a row in the &quot;AppBuilderAppDeployment&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>AppBuilderAppDeploymentModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link AppBuilderAppDeploymentImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see AppBuilderAppDeploymentImpl
 * @generated
 */
public class AppBuilderAppDeploymentModelImpl
	extends BaseModelImpl<AppBuilderAppDeployment>
	implements AppBuilderAppDeploymentModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a app builder app deployment model instance should use the <code>AppBuilderAppDeployment</code> interface instead.
	 */
	public static final String TABLE_NAME = "AppBuilderAppDeployment";

	public static final Object[][] TABLE_COLUMNS = {
		{"appBuilderAppDeploymentId", Types.BIGINT},
		{"companyId", Types.BIGINT}, {"appBuilderAppId", Types.BIGINT},
		{"settings_", Types.CLOB}, {"type_", Types.VARCHAR}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("appBuilderAppDeploymentId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("appBuilderAppId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("settings_", Types.CLOB);
		TABLE_COLUMNS_MAP.put("type_", Types.VARCHAR);
	}

	public static final String TABLE_SQL_CREATE =
		"create table AppBuilderAppDeployment (appBuilderAppDeploymentId LONG not null primary key,companyId LONG,appBuilderAppId LONG,settings_ TEXT null,type_ VARCHAR(75) null)";

	public static final String TABLE_SQL_DROP =
		"drop table AppBuilderAppDeployment";

	public static final String ORDER_BY_JPQL =
		" ORDER BY appBuilderAppDeployment.appBuilderAppDeploymentId ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY AppBuilderAppDeployment.appBuilderAppDeploymentId ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long APPBUILDERAPPID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long TYPE_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long APPBUILDERAPPDEPLOYMENTID_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public AppBuilderAppDeploymentModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _appBuilderAppDeploymentId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setAppBuilderAppDeploymentId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _appBuilderAppDeploymentId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return AppBuilderAppDeployment.class;
	}

	@Override
	public String getModelClassName() {
		return AppBuilderAppDeployment.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<AppBuilderAppDeployment, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<AppBuilderAppDeployment, Object>>
				entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<AppBuilderAppDeployment, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((AppBuilderAppDeployment)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<AppBuilderAppDeployment, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<AppBuilderAppDeployment, Object>
				attributeSetterBiConsumer = attributeSetterBiConsumers.get(
					attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(AppBuilderAppDeployment)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<AppBuilderAppDeployment, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<AppBuilderAppDeployment, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static final Map<String, Function<AppBuilderAppDeployment, Object>>
		_attributeGetterFunctions;

	static {
		Map<String, Function<AppBuilderAppDeployment, Object>>
			attributeGetterFunctions =
				new LinkedHashMap
					<String, Function<AppBuilderAppDeployment, Object>>();

		attributeGetterFunctions.put(
			"appBuilderAppDeploymentId",
			AppBuilderAppDeployment::getAppBuilderAppDeploymentId);
		attributeGetterFunctions.put(
			"companyId", AppBuilderAppDeployment::getCompanyId);
		attributeGetterFunctions.put(
			"appBuilderAppId", AppBuilderAppDeployment::getAppBuilderAppId);
		attributeGetterFunctions.put(
			"settings", AppBuilderAppDeployment::getSettings);
		attributeGetterFunctions.put("type", AppBuilderAppDeployment::getType);

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
	}

	private static final Map
		<String, BiConsumer<AppBuilderAppDeployment, Object>>
			_attributeSetterBiConsumers;

	static {
		Map<String, BiConsumer<AppBuilderAppDeployment, ?>>
			attributeSetterBiConsumers =
				new LinkedHashMap
					<String, BiConsumer<AppBuilderAppDeployment, ?>>();

		attributeSetterBiConsumers.put(
			"appBuilderAppDeploymentId",
			(BiConsumer<AppBuilderAppDeployment, Long>)
				AppBuilderAppDeployment::setAppBuilderAppDeploymentId);
		attributeSetterBiConsumers.put(
			"companyId",
			(BiConsumer<AppBuilderAppDeployment, Long>)
				AppBuilderAppDeployment::setCompanyId);
		attributeSetterBiConsumers.put(
			"appBuilderAppId",
			(BiConsumer<AppBuilderAppDeployment, Long>)
				AppBuilderAppDeployment::setAppBuilderAppId);
		attributeSetterBiConsumers.put(
			"settings",
			(BiConsumer<AppBuilderAppDeployment, String>)
				AppBuilderAppDeployment::setSettings);
		attributeSetterBiConsumers.put(
			"type",
			(BiConsumer<AppBuilderAppDeployment, String>)
				AppBuilderAppDeployment::setType);

		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@Override
	public long getAppBuilderAppDeploymentId() {
		return _appBuilderAppDeploymentId;
	}

	@Override
	public void setAppBuilderAppDeploymentId(long appBuilderAppDeploymentId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_appBuilderAppDeploymentId = appBuilderAppDeploymentId;
	}

	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	@Override
	public long getAppBuilderAppId() {
		return _appBuilderAppId;
	}

	@Override
	public void setAppBuilderAppId(long appBuilderAppId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_appBuilderAppId = appBuilderAppId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalAppBuilderAppId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("appBuilderAppId"));
	}

	@Override
	public String getSettings() {
		if (_settings == null) {
			return "";
		}
		else {
			return _settings;
		}
	}

	@Override
	public void setSettings(String settings) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_settings = settings;
	}

	@Override
	public String getType() {
		if (_type == null) {
			return "";
		}
		else {
			return _type;
		}
	}

	@Override
	public void setType(String type) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_type = type;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalType() {
		return getColumnOriginalValue("type_");
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), AppBuilderAppDeployment.class.getName(),
			getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public AppBuilderAppDeployment toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, AppBuilderAppDeployment>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		AppBuilderAppDeploymentImpl appBuilderAppDeploymentImpl =
			new AppBuilderAppDeploymentImpl();

		appBuilderAppDeploymentImpl.setAppBuilderAppDeploymentId(
			getAppBuilderAppDeploymentId());
		appBuilderAppDeploymentImpl.setCompanyId(getCompanyId());
		appBuilderAppDeploymentImpl.setAppBuilderAppId(getAppBuilderAppId());
		appBuilderAppDeploymentImpl.setSettings(getSettings());
		appBuilderAppDeploymentImpl.setType(getType());

		appBuilderAppDeploymentImpl.resetOriginalValues();

		return appBuilderAppDeploymentImpl;
	}

	@Override
	public int compareTo(AppBuilderAppDeployment appBuilderAppDeployment) {
		long primaryKey = appBuilderAppDeployment.getPrimaryKey();

		if (getPrimaryKey() < primaryKey) {
			return -1;
		}
		else if (getPrimaryKey() > primaryKey) {
			return 1;
		}
		else {
			return 0;
		}
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof AppBuilderAppDeployment)) {
			return false;
		}

		AppBuilderAppDeployment appBuilderAppDeployment =
			(AppBuilderAppDeployment)object;

		long primaryKey = appBuilderAppDeployment.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<AppBuilderAppDeployment> toCacheModel() {
		AppBuilderAppDeploymentCacheModel appBuilderAppDeploymentCacheModel =
			new AppBuilderAppDeploymentCacheModel();

		appBuilderAppDeploymentCacheModel.appBuilderAppDeploymentId =
			getAppBuilderAppDeploymentId();

		appBuilderAppDeploymentCacheModel.companyId = getCompanyId();

		appBuilderAppDeploymentCacheModel.appBuilderAppId =
			getAppBuilderAppId();

		appBuilderAppDeploymentCacheModel.settings = getSettings();

		String settings = appBuilderAppDeploymentCacheModel.settings;

		if ((settings != null) && (settings.length() == 0)) {
			appBuilderAppDeploymentCacheModel.settings = null;
		}

		appBuilderAppDeploymentCacheModel.type = getType();

		String type = appBuilderAppDeploymentCacheModel.type;

		if ((type != null) && (type.length() == 0)) {
			appBuilderAppDeploymentCacheModel.type = null;
		}

		return appBuilderAppDeploymentCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<AppBuilderAppDeployment, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<AppBuilderAppDeployment, Object>>
				entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<AppBuilderAppDeployment, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply(
				(AppBuilderAppDeployment)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		Map<String, Function<AppBuilderAppDeployment, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 4);

		sb.append("<model><model-name>");
		sb.append(getModelClassName());
		sb.append("</model-name>");

		for (Map.Entry<String, Function<AppBuilderAppDeployment, Object>>
				entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<AppBuilderAppDeployment, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("<column><column-name>");
			sb.append(attributeName);
			sb.append("</column-name><column-value><![CDATA[");
			sb.append(
				attributeGetterFunction.apply((AppBuilderAppDeployment)this));
			sb.append("]]></column-value></column>");
		}

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function
			<InvocationHandler, AppBuilderAppDeployment>
				_escapedModelProxyProviderFunction =
					ProxyUtil.getProxyProviderFunction(
						AppBuilderAppDeployment.class, ModelWrapper.class);

	}

	private long _appBuilderAppDeploymentId;
	private long _companyId;
	private long _appBuilderAppId;
	private String _settings;
	private String _type;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<AppBuilderAppDeployment, Object> function =
			_attributeGetterFunctions.get(columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((AppBuilderAppDeployment)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put(
			"appBuilderAppDeploymentId", _appBuilderAppDeploymentId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("appBuilderAppId", _appBuilderAppId);
		_columnOriginalValues.put("settings_", _settings);
		_columnOriginalValues.put("type_", _type);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("settings_", "settings");
		attributeNames.put("type_", "type");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("appBuilderAppDeploymentId", 1L);

		columnBitmasks.put("companyId", 2L);

		columnBitmasks.put("appBuilderAppId", 4L);

		columnBitmasks.put("settings_", 8L);

		columnBitmasks.put("type_", 16L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private AppBuilderAppDeployment _escapedModel;

}