/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.adaptive.media.image.internal.exportimport.content.processor;

import com.liferay.adaptive.media.image.internal.exportimport.content.processor.AMEmbeddedReferenceSet;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import java.util.HashMap;
import java.util.List;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={AMEmbeddedReferenceSetFactory.class})
public class AMEmbeddedReferenceSetFactory {
    public AMEmbeddedReferenceSet create(PortletDataContext portletDataContext, StagedModel stagedModel) {
        HashMap<String, Long> embeddedReferences = new HashMap<String, Long>();
        List referenceElements = portletDataContext.getReferenceElements(stagedModel, DLFileEntry.class);
        for (Element referenceElement : referenceElements) {
            long classPK = GetterUtil.getLong((String)referenceElement.attributeValue("class-pk"));
            Element referenceDataElement = portletDataContext.getReferenceDataElement(stagedModel, DLFileEntry.class, classPK);
            String path = null;
            if (referenceDataElement != null) {
                path = referenceDataElement.attributeValue("path");
            }
            if (Validator.isNull(path)) {
                long groupId = GetterUtil.getLong((String)referenceElement.attributeValue("group-id"));
                String className = referenceElement.attributeValue("class-name");
                path = ExportImportPathUtil.getModelPath((long)groupId, (String)className, (long)classPK);
            }
            embeddedReferences.put(path, classPK);
        }
        return new AMEmbeddedReferenceSet(portletDataContext, stagedModel, embeddedReferences);
    }
}

