/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.adaptive.media.image.internal.storage;

import com.liferay.adaptive.media.exception.AMRuntimeException;
import com.liferay.adaptive.media.image.internal.storage.AMStoreUtil;
import com.liferay.document.library.kernel.store.DLStoreUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.model.FileVersion;
import java.io.InputStream;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={ImageStorage.class})
public class ImageStorage {
    public void delete(FileVersion fileVersion, String configurationUuid) {
        DLStoreUtil.deleteDirectory((long)fileVersion.getCompanyId(), (long)0L, (String)AMStoreUtil.getFileVersionPath(fileVersion, configurationUuid));
    }

    public void delete(long companyId, String configurationUuid) {
        DLStoreUtil.deleteDirectory((long)companyId, (long)0L, (String)this.getConfigurationEntryPath(configurationUuid));
    }

    public InputStream getContentStream(FileVersion fileVersion, String configurationUuid) {
        try {
            String fileVersionPath = AMStoreUtil.getFileVersionPath(fileVersion, configurationUuid);
            return DLStoreUtil.getFileAsStream((long)fileVersion.getCompanyId(), (long)0L, (String)fileVersionPath);
        }
        catch (PortalException portalException) {
            throw new AMRuntimeException.IOException((Throwable)portalException);
        }
    }

    public void save(FileVersion fileVersion, String configurationUuid, InputStream inputStream) {
        try {
            String fileVersionPath = AMStoreUtil.getFileVersionPath(fileVersion, configurationUuid);
            DLStoreUtil.addFile((long)fileVersion.getCompanyId(), (long)0L, (String)fileVersionPath, (boolean)false, (InputStream)inputStream);
        }
        catch (PortalException portalException) {
            throw new AMRuntimeException.IOException((Throwable)portalException);
        }
    }

    protected String getConfigurationEntryPath(String configurationUuid) {
        return String.format("adaptive/%s", configurationUuid);
    }
}

