/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.adaptive.media.image.internal.exportimport.content.processor;

import com.liferay.adaptive.media.image.html.AMImageHTMLTagFactory;
import com.liferay.adaptive.media.image.internal.exportimport.content.processor.AMEmbeddedReferenceSet;
import com.liferay.adaptive.media.image.internal.exportimport.content.processor.AMEmbeddedReferenceSetFactory;
import com.liferay.adaptive.media.image.internal.exportimport.content.processor.AMReferenceExporter;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.exportimport.content.processor.ExportImportContentProcessor;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.Objects;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"adaptive.media.format=html"}, service={ExportImportContentProcessor.class})
public class AMImageHTMLExportImportContentProcessor
implements ExportImportContentProcessor<String> {
    private static final String _ATTRIBUTE_NAME_EXPORT_IMPORT_PATH = "export-import-path";
    private static final Log _log = LogFactoryUtil.getLog(AMImageHTMLExportImportContentProcessor.class);
    @Reference
    private AMEmbeddedReferenceSetFactory _amEmbeddedReferenceSetFactory;
    @Reference
    private AMImageHTMLTagFactory _amImageHTMLTagFactory;
    @Reference
    private DLAppLocalService _dlAppLocalService;

    public String replaceExportContentReferences(PortletDataContext portletDataContext, StagedModel stagedModel, String content, boolean exportReferencedContent, boolean escapeContent) {
        AMReferenceExporter amReferenceExporter = new AMReferenceExporter(portletDataContext, stagedModel, exportReferencedContent);
        return this._replace(content, amReferenceExporter);
    }

    public String replaceImportContentReferences(PortletDataContext portletDataContext, StagedModel stagedModel, String content) throws Exception {
        AMEmbeddedReferenceSet amEmbeddedReferenceSet = this._amEmbeddedReferenceSetFactory.create(portletDataContext, stagedModel);
        return this._replace(content, amEmbeddedReferenceSet);
    }

    public void validateContentReferences(long groupId, String content) throws PortalException {
        Document document = this._parseDocument(content);
        String elementSelector = "[data-fileentryid]";
        for (Element element : document.select(elementSelector)) {
            long fileEntryId = Long.valueOf(element.attr("data-fileentryid"));
            this._dlAppLocalService.getFileEntry(fileEntryId);
        }
    }

    private FileEntry _getFileEntry(long fileEntryId) {
        try {
            return this._dlAppLocalService.getFileEntry(fileEntryId);
        }
        catch (PortalException portalException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)portalException, (Throwable)portalException);
            }
            return null;
        }
    }

    private Document _parseDocument(String html) {
        Document document = Jsoup.parseBodyFragment((String)html);
        Document.OutputSettings outputSettings = new Document.OutputSettings();
        outputSettings.prettyPrint(false);
        outputSettings.syntax(Document.OutputSettings.Syntax.xml);
        document.outputSettings(outputSettings);
        return document;
    }

    private Element _parseNode(String tag) {
        Document document = this._parseDocument(tag);
        Element bodyElement = document.body();
        return bodyElement.child(0);
    }

    private String _replace(String content, AMEmbeddedReferenceSet amEmbeddedReferenceSet) throws PortalException {
        Document document = this._parseDocument(content);
        Elements elements = document.getElementsByAttribute(_ATTRIBUTE_NAME_EXPORT_IMPORT_PATH);
        for (Element element : elements) {
            long fileEntryId;
            FileEntry fileEntry;
            String path = element.attr(_ATTRIBUTE_NAME_EXPORT_IMPORT_PATH);
            if (!amEmbeddedReferenceSet.containsReference(path) || (fileEntry = this._getFileEntry(fileEntryId = amEmbeddedReferenceSet.importReference(path))) == null) continue;
            element.attr("data-fileentryid", String.valueOf(fileEntryId));
            element.removeAttr(_ATTRIBUTE_NAME_EXPORT_IMPORT_PATH);
            if (!Objects.equals(element.tagName(), "picture")) continue;
            Elements imgElements = element.getElementsByTag("img");
            Element imgElement = imgElements.first();
            imgElement.removeAttr(_ATTRIBUTE_NAME_EXPORT_IMPORT_PATH);
            imgElement.attr("data-fileentryid", String.valueOf(fileEntryId));
            Element picture = this._parseNode(this._amImageHTMLTagFactory.create(imgElement.toString(), fileEntry));
            element.html(picture.html());
        }
        Element bodyElement = document.body();
        return bodyElement.html();
    }

    private String _replace(String content, AMReferenceExporter amReferenceExporter) {
        Document document = this._parseDocument(content);
        String elementSelector = "[data-fileentryid]";
        for (Element element : document.select(elementSelector)) {
            try {
                long fileEntryId = GetterUtil.getLong((String)element.attr("data-fileentryid"));
                if (fileEntryId == 0L) continue;
                FileEntry fileEntry = this._dlAppLocalService.getFileEntry(fileEntryId);
                amReferenceExporter.exportReference(fileEntry);
                element.removeAttr("data-fileentryid");
                element.attr(_ATTRIBUTE_NAME_EXPORT_IMPORT_PATH, ExportImportPathUtil.getModelPath((StagedModel)fileEntry));
            }
            catch (PortalException portalException) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)portalException, (Throwable)portalException);
                    continue;
                }
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)portalException.getMessage());
            }
        }
        Element bodyElement = document.body();
        return bodyElement.html();
    }
}

