/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.adaptive.media.document.library.thumbnails.internal.util;

import com.liferay.adaptive.media.exception.AMImageConfigurationException;
import com.liferay.adaptive.media.image.configuration.AMImageConfigurationHelper;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.PrefsProps;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={AMCompanyThumbnailConfigurationInitializer.class})
public class AMCompanyThumbnailConfigurationInitializer {
    private static final Pattern _pattern = Pattern.compile("[^\\w-]");
    @Reference
    private AMImageConfigurationHelper _amImageConfigurationHelper;
    @Reference
    private PrefsProps _prefsProps;

    public void initializeCompany(Company company) throws AMImageConfigurationException, IOException {
        int dlFileEntryPreviewMaxHeight = this._prefsProps.getInteger("dl.file.entry.preview.document.max.height");
        int dlFileEntryPreviewMaxWidth = this._prefsProps.getInteger("dl.file.entry.preview.document.max.width");
        if (dlFileEntryPreviewMaxHeight > 0 || dlFileEntryPreviewMaxWidth > 0) {
            this._createAMDocumentLibraryPreviewConfiguration(company, dlFileEntryPreviewMaxHeight, dlFileEntryPreviewMaxWidth);
        }
        int dlFileEntryThumbnailMaxHeight = this._prefsProps.getInteger("dl.file.entry.thumbnail.max.height");
        int dlFileEntryThumbnailMaxWidth = this._prefsProps.getInteger("dl.file.entry.thumbnail.max.width");
        if (dlFileEntryThumbnailMaxHeight > 0 && dlFileEntryThumbnailMaxWidth > 0) {
            this._createAMDocumentLibraryThumbnailConfiguration(company, dlFileEntryThumbnailMaxHeight, dlFileEntryThumbnailMaxWidth);
        }
        int dlFileEntryThumbnailCustom1MaxHeight = this._prefsProps.getInteger("dl.file.entry.thumbnail.custom1.max.height");
        int dlFileEntryThumbnailCustom1MaxWidth = this._prefsProps.getInteger("dl.file.entry.thumbnail.custom1.max.width");
        if (dlFileEntryThumbnailCustom1MaxHeight > 0 && dlFileEntryThumbnailCustom1MaxWidth > 0) {
            this._createAMDocumentLibraryThumbnailConfiguration(company, dlFileEntryThumbnailCustom1MaxHeight, dlFileEntryThumbnailCustom1MaxWidth);
        }
        int dlFileEntryThumbnailCustom2MaxHeight = this._prefsProps.getInteger("dl.file.entry.thumbnail.custom2.max.height");
        int dlFileEntryThumbnailCustom2MaxWidth = this._prefsProps.getInteger("dl.file.entry.thumbnail.custom2.max.width");
        if (dlFileEntryThumbnailCustom2MaxHeight > 0 && dlFileEntryThumbnailCustom2MaxWidth > 0) {
            this._createAMDocumentLibraryThumbnailConfiguration(company, dlFileEntryThumbnailCustom2MaxHeight, dlFileEntryThumbnailCustom2MaxWidth);
        }
    }

    private void _createAMDocumentLibraryConfiguration(Company company, String name, int maxHeight, int maxWidth) throws AMImageConfigurationException, IOException {
        String uuid = this._normalize(name);
        if (!this._hasConfiguration(company.getCompanyId(), name, uuid)) {
            this._amImageConfigurationHelper.addAMImageConfigurationEntry(company.getCompanyId(), name, "This image resolution was automatically added.", uuid, (Map)HashMapBuilder.put((Object)"max-height", (Object)String.valueOf(maxHeight)).put((Object)"max-width", (Object)String.valueOf(maxWidth)).build());
        }
    }

    private void _createAMDocumentLibraryPreviewConfiguration(Company company, int maxHeight, int maxWidth) throws AMImageConfigurationException, IOException {
        String name = String.format("%s %dx%d", "Preview", maxWidth, maxHeight);
        this._createAMDocumentLibraryConfiguration(company, name, maxHeight, maxWidth);
    }

    private void _createAMDocumentLibraryThumbnailConfiguration(Company company, int maxHeight, int maxWidth) throws AMImageConfigurationException, IOException {
        String name = String.format("%s %dx%d", "Thumbnail", maxWidth, maxHeight);
        this._createAMDocumentLibraryConfiguration(company, name, maxHeight, maxWidth);
    }

    private boolean _hasConfiguration(long companyId, String name, String uuid) {
        Collection amImageConfigurationEntries = this._amImageConfigurationHelper.getAMImageConfigurationEntries(companyId, amImageConfigurationEntry -> name.equals(amImageConfigurationEntry.getName()) || uuid.equals(amImageConfigurationEntry.getUUID()));
        return !amImageConfigurationEntries.isEmpty();
    }

    private String _normalize(String str) {
        Matcher matcher = _pattern.matcher(str);
        return matcher.replaceAll("-");
    }
}

