/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.service.impl;

import com.liferay.account.constants.AccountConstants;
import com.liferay.account.exception.AccountEntryDomainsException;
import com.liferay.account.exception.AccountEntryEmailAddressException;
import com.liferay.account.exception.AccountEntryNameException;
import com.liferay.account.exception.AccountEntryTypeException;
import com.liferay.account.model.AccountEntry;
import com.liferay.account.model.AccountEntryOrganizationRelTable;
import com.liferay.account.model.AccountEntryTable;
import com.liferay.account.model.AccountEntryUserRelTable;
import com.liferay.account.model.impl.AccountEntryImpl;
import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.account.service.base.AccountEntryLocalServiceBaseImpl;
import com.liferay.account.validator.AccountEntryEmailAddressValidator;
import com.liferay.account.validator.AccountEntryEmailAddressValidatorFactory;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.service.ExpandoRowLocalService;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.empty.model.EmptyModelManager;
import com.liferay.object.entry.util.ObjectEntryThreadLocal;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.sql.dsl.DSLFunctionFactoryUtil;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.sql.dsl.query.FromStep;
import com.liferay.petra.sql.dsl.query.GroupByStep;
import com.liferay.petra.sql.dsl.query.JoinStep;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.dao.orm.custom.sql.CustomSQL;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserTable;
import com.liferay.portal.kernel.model.WorkflowDefinitionLink;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.service.AddressLocalService;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.WorkflowDefinitionLinkLocalService;
import com.liferay.portal.kernel.service.WorkflowInstanceLinkLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.portal.kernel.workflow.WorkflowThreadLocal;
import com.liferay.portal.search.document.Document;
import com.liferay.portal.search.hits.SearchHits;
import com.liferay.portal.search.searcher.SearchRequest;
import com.liferay.portal.search.searcher.SearchRequestBuilder;
import com.liferay.portal.search.searcher.SearchRequestBuilderFactory;
import com.liferay.portal.search.searcher.SearchResponse;
import com.liferay.portal.search.searcher.Searcher;
import com.liferay.portal.search.sort.FieldSort;
import com.liferay.portal.search.sort.Sort;
import com.liferay.portal.search.sort.SortFieldBuilder;
import com.liferay.portal.search.sort.SortOrder;
import com.liferay.portal.search.sort.Sorts;
import com.liferay.portal.util.PortalInstances;
import com.liferay.users.admin.kernel.file.uploads.UserFileUploadsSettings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.account.model.AccountEntry"}, service={AopService.class})
public class AccountEntryLocalServiceImpl
extends AccountEntryLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(AccountEntryLocalServiceImpl.class);
    @Reference
    private AccountEntryEmailAddressValidatorFactory _accountEntryEmailAddressValidatorFactory;
    @Reference
    private AddressLocalService _addressLocalService;
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private CustomSQL _customSQL;
    @Reference
    private EmptyModelManager _emptyModelManager;
    @Reference
    private ExpandoRowLocalService _expandoRowLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private OrganizationLocalService _organizationLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private ResourceLocalService _resourceLocalService;
    @Reference
    private Searcher _searcher;
    @Reference
    private SearchRequestBuilderFactory _searchRequestBuilderFactory;
    @Reference
    private SortFieldBuilder _sortFieldBuilder;
    @Reference
    private Sorts _sorts;
    @Reference
    private UserFileUploadsSettings _userFileUploadsSettings;
    @Reference
    private UserLocalService _userLocalService;
    @Reference
    private WorkflowDefinitionLinkLocalService _workflowDefinitionLinkLocalService;
    @Reference
    private WorkflowInstanceLinkLocalService _workflowInstanceLinkLocalService;

    public void activateAccountEntries(long[] accountEntryIds) throws PortalException {
        this._performActions(accountEntryIds, (ActionableDynamicQuery.PerformActionMethod<AccountEntry>)((ActionableDynamicQuery.PerformActionMethod)this::activateAccountEntry));
    }

    public AccountEntry activateAccountEntry(AccountEntry accountEntry) throws PortalException {
        return this.updateStatus(accountEntry, 0);
    }

    public AccountEntry activateAccountEntry(long accountEntryId) throws PortalException {
        return this.activateAccountEntry(this.getAccountEntry(accountEntryId));
    }

    public AccountEntry addAccountEntry(String externalReferenceCode, long userId, long parentAccountEntryId, String name, String description, String[] domains, String emailAddress, byte[] logoBytes, String taxIdNumber, String type, int status, ServiceContext serviceContext) throws PortalException {
        long accountEntryId = this.counterLocalService.increment();
        AccountEntry accountEntry = this.accountEntryPersistence.create(accountEntryId);
        User user = this._userLocalService.getUser(userId);
        accountEntry.setExternalReferenceCode(externalReferenceCode);
        accountEntry.setCompanyId(user.getCompanyId());
        accountEntry.setUserId(user.getUserId());
        accountEntry.setUserName(user.getFullName());
        accountEntry.setParentAccountEntryId(parentAccountEntryId);
        this._validateName(name);
        accountEntry.setDescription(description);
        accountEntry.setName(name);
        AccountEntryEmailAddressValidator accountEntryEmailAddressValidator = this._accountEntryEmailAddressValidatorFactory.create(user.getCompanyId());
        this._validateEmailAddress(accountEntryEmailAddressValidator, emailAddress);
        accountEntry.setEmailAddress(emailAddress);
        this._portal.updateImageId((BaseModel)accountEntry, true, logoBytes, "logoId", this._userFileUploadsSettings.getImageMaxSize(), this._userFileUploadsSettings.getImageMaxHeight(), this._userFileUploadsSettings.getImageMaxWidth());
        accountEntry.setRestrictMembership(true);
        accountEntry.setTaxIdNumber(taxIdNumber);
        this._validateType(user.getCompanyId(), type);
        accountEntry.setType(type);
        accountEntry.setStatus(2);
        accountEntry.setExpandoBridgeAttributes(serviceContext);
        accountEntry = (AccountEntry)this.accountEntryPersistence.update((BaseModel)accountEntry);
        if (domains != null) {
            accountEntry = this.updateDomains(accountEntryId, domains);
        }
        this._groupLocalService.addGroup("", userId, 0L, AccountEntry.class.getName(), accountEntryId, 0L, this.getLocalizationMap(name), null, 3, null, false, 0, null, false, false, true, null);
        this._resourceLocalService.addResources(user.getCompanyId(), 0L, user.getUserId(), AccountEntry.class.getName(), accountEntryId, false, false, false);
        ServiceContext workflowServiceContext = new ServiceContext();
        if (serviceContext != null) {
            this._updateAsset(accountEntry, serviceContext);
            workflowServiceContext = (ServiceContext)serviceContext.clone();
        }
        if (!this._emptyModelManager.isEmptyModel() && this._isWorkflowEnabled(accountEntry.getCompanyId())) {
            this._checkStatus(accountEntry.getStatus(), status);
            accountEntry = this._startWorkflowInstance(userId, accountEntry, workflowServiceContext);
        } else {
            if (this._emptyModelManager.isEmptyModel()) {
                status = 9;
            }
            accountEntry = this.updateStatus(userId, accountEntryId, status, workflowServiceContext, Collections.emptyMap());
        }
        return accountEntry;
    }

    public AccountEntry addOrUpdateAccountEntry(String externalReferenceCode, long userId, long parentAccountEntryId, String name, String description, String[] domains, String emailAddress, byte[] logoBytes, String taxIdNumber, String type, int status, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        AccountEntry accountEntry = this.fetchAccountEntryByExternalReferenceCode(externalReferenceCode, user.getCompanyId());
        if (accountEntry != null) {
            return this.updateAccountEntry(externalReferenceCode, accountEntry.getAccountEntryId(), parentAccountEntryId, name, description, false, domains, emailAddress, logoBytes, taxIdNumber, status, serviceContext);
        }
        return this.addAccountEntry(externalReferenceCode, userId, parentAccountEntryId, name, description, domains, emailAddress, logoBytes, taxIdNumber, type, status, serviceContext);
    }

    public void deactivateAccountEntries(long[] accountEntryIds) throws PortalException {
        this._performActions(accountEntryIds, (ActionableDynamicQuery.PerformActionMethod<AccountEntry>)((ActionableDynamicQuery.PerformActionMethod)this::deactivateAccountEntry));
    }

    public AccountEntry deactivateAccountEntry(AccountEntry accountEntry) throws PortalException {
        return this.updateStatus(accountEntry, 5);
    }

    public AccountEntry deactivateAccountEntry(long accountEntryId) throws PortalException {
        return this.deactivateAccountEntry(this.getAccountEntry(accountEntryId));
    }

    public void deleteAccountEntries(long[] accountEntryIds) throws PortalException {
        this._performActions(accountEntryIds, (ActionableDynamicQuery.PerformActionMethod<AccountEntry>)((ActionableDynamicQuery.PerformActionMethod)arg_0 -> ((AccountEntryLocalService)this.accountEntryLocalService).deleteAccountEntry(arg_0)));
    }

    public void deleteAccountEntriesByCompanyId(long companyId) {
        if (!PortalInstances.isCurrentCompanyInDeletionProcess()) {
            throw new UnsupportedOperationException("Deleting account entries by company must be called when deleting a company");
        }
        for (AccountEntry accountRole : this.accountEntryPersistence.findByCompanyId(companyId)) {
            this.accountEntryPersistence.remove((BaseModel)accountRole);
        }
    }

    @Override
    @SystemEvent(type=1)
    public AccountEntry deleteAccountEntry(AccountEntry accountEntry) throws PortalException {
        accountEntry = super.deleteAccountEntry(accountEntry);
        this._resourceLocalService.deleteResource(accountEntry.getCompanyId(), AccountEntry.class.getName(), 4, accountEntry.getAccountEntryId());
        this._addressLocalService.deleteAddresses(accountEntry.getCompanyId(), AccountEntry.class.getName(), accountEntry.getAccountEntryId());
        this._groupLocalService.deleteGroup(accountEntry.getAccountEntryGroup());
        this._assetEntryLocalService.deleteEntry(AccountEntry.class.getName(), accountEntry.getAccountEntryId());
        this._expandoRowLocalService.deleteRows(accountEntry.getAccountEntryId());
        this._workflowInstanceLinkLocalService.deleteWorkflowInstanceLinks(accountEntry.getCompanyId(), 0L, AccountEntry.class.getName(), accountEntry.getAccountEntryId());
        return accountEntry;
    }

    @Override
    public AccountEntry deleteAccountEntry(long accountEntryId) throws PortalException {
        return this.accountEntryLocalService.deleteAccountEntry(this.getAccountEntry(accountEntryId));
    }

    public AccountEntry fetchPersonAccountEntry(long userId) {
        return this.accountEntryPersistence.fetchByU_T_First(userId, "person", null);
    }

    public AccountEntry fetchSupplierAccountEntry(long userId) {
        return this.accountEntryPersistence.fetchByU_T_First(userId, "supplier", null);
    }

    public AccountEntry fetchUserAccountEntry(long userId, long accountEntryId) {
        DSLQuery dslQuery;
        List accountEntries;
        JoinStep joinStep = DSLQueryFactoryUtil.selectDistinct((Table)AccountEntryTable.INSTANCE).from((Table)UserTable.INSTANCE).leftJoinOn((Table)AccountEntryUserRelTable.INSTANCE, AccountEntryUserRelTable.INSTANCE.accountUserId.eq((Expression)UserTable.INSTANCE.userId));
        Predicate accountEntryTablePredicate = AccountEntryTable.INSTANCE.accountEntryId.eq((Expression)AccountEntryUserRelTable.INSTANCE.accountEntryId).or((Expression)AccountEntryTable.INSTANCE.userId.eq((Expression)UserTable.INSTANCE.userId));
        Object[] organizationIds = this._getOrganizationIds(userId);
        if (ArrayUtil.isNotEmpty((Object[])organizationIds)) {
            joinStep = joinStep.leftJoinOn((Table)AccountEntryOrganizationRelTable.INSTANCE, AccountEntryOrganizationRelTable.INSTANCE.organizationId.in(organizationIds));
            accountEntryTablePredicate = accountEntryTablePredicate.or((Expression)AccountEntryTable.INSTANCE.accountEntryId.eq((Expression)AccountEntryOrganizationRelTable.INSTANCE.accountEntryId));
        }
        if ((accountEntries = (List)this.dslQuery(dslQuery = (joinStep = joinStep.leftJoinOn((Table)AccountEntryTable.INSTANCE, accountEntryTablePredicate)).where(UserTable.INSTANCE.userId.eq((Object)userId).and((Expression)AccountEntryTable.INSTANCE.type.neq((Object)"guest")).and((Expression)AccountEntryTable.INSTANCE.accountEntryId.eq((Object)accountEntryId))).limit(0, 1))).isEmpty()) {
            return null;
        }
        return (AccountEntry)accountEntries.get(0);
    }

    public List<AccountEntry> getAccountEntries(long companyId, int status, int start, int end, OrderByComparator<AccountEntry> orderByComparator) {
        return this.accountEntryPersistence.findByC_S(companyId, status, start, end, orderByComparator);
    }

    public int getAccountEntriesCount(long companyId, int status) {
        return this.accountEntryPersistence.countByC_S(companyId, status);
    }

    public AccountEntry getGuestAccountEntry(long companyId) throws PortalException {
        User guestUser = this._userLocalService.getGuestUser(companyId);
        AccountEntryImpl accountEntryImpl = new AccountEntryImpl();
        accountEntryImpl.setAccountEntryId(-1L);
        accountEntryImpl.setCompanyId(guestUser.getCompanyId());
        accountEntryImpl.setUserId(guestUser.getUserId());
        accountEntryImpl.setUserName(guestUser.getFullName());
        accountEntryImpl.setParentAccountEntryId(0L);
        accountEntryImpl.setEmailAddress(guestUser.getEmailAddress());
        accountEntryImpl.setName(guestUser.getFullName());
        accountEntryImpl.setType("guest");
        accountEntryImpl.setStatus(0);
        return accountEntryImpl;
    }

    @Indexable(type=IndexableType.REINDEX)
    public AccountEntry getOrAddEmptyAccountEntry(String externalReferenceCode, long companyId, long userId, String name, String type) throws PortalException {
        return (AccountEntry)this._emptyModelManager.getOrAddEmptyModel(AccountEntry.class, companyId, () -> this.accountEntryLocalService.addAccountEntry(externalReferenceCode, userId, 0L, GetterUtil.get((String)name, (String)externalReferenceCode), "", null, "", null, "", type, 9, null), externalReferenceCode, this::fetchAccountEntryByExternalReferenceCode, this::getAccountEntryByExternalReferenceCode);
    }

    public List<AccountEntry> getUserAccountEntries(long userId, Long parentAccountEntryId, String keywords, String[] types, int start, int end) throws PortalException {
        return this.getUserAccountEntries(userId, parentAccountEntryId, keywords, types, -1, start, end);
    }

    public List<AccountEntry> getUserAccountEntries(long userId, Long parentAccountEntryId, String keywords, String[] types, Integer status, int start, int end) throws PortalException {
        return this.getUserAccountEntries(userId, parentAccountEntryId, keywords, types, status, start, end, null);
    }

    public List<AccountEntry> getUserAccountEntries(long userId, Long parentAccountEntryId, String keywords, String[] types, Integer status, int start, int end, OrderByComparator<AccountEntry> orderByComparator) throws PortalException {
        if (start == -1 && end == -1 && orderByComparator == null) {
            Map accountEntriesMap = this.accountEntryPersistence.fetchByPrimaryKeys(this._getUserAccountEntryIds(userId, parentAccountEntryId, keywords, types, status));
            if (accountEntriesMap.isEmpty()) {
                return Collections.emptyList();
            }
            return new ArrayList<AccountEntry>(accountEntriesMap.values());
        }
        Table tempAccountEntryTable = this._getOrganizationsAccountEntriesGroupByStep(DSLQueryFactoryUtil.selectDistinct((Table)AccountEntryTable.INSTANCE), userId, parentAccountEntryId, keywords, types, status).union((DSLQuery)this._getOwnerAccountEntriesGroupByStep(DSLQueryFactoryUtil.selectDistinct((Table)AccountEntryTable.INSTANCE), userId, parentAccountEntryId, keywords, types, status)).union((DSLQuery)this._getUerAccountEntriesGroupByStep(DSLQueryFactoryUtil.selectDistinct((Table)AccountEntryTable.INSTANCE), userId, parentAccountEntryId, keywords, types, status)).as("tempAccountEntry", (Table)AccountEntryTable.INSTANCE);
        return (List)this.dslQuery(DSLQueryFactoryUtil.selectDistinct((Table)tempAccountEntryTable).from(tempAccountEntryTable).orderBy(tempAccountEntryTable, orderByComparator).limit(start, end));
    }

    public int getUserAccountEntriesCount(long userId, Long parentAccountEntryId, String keywords, String[] types) throws PortalException {
        return this.getUserAccountEntriesCount(userId, parentAccountEntryId, keywords, types, -1);
    }

    public int getUserAccountEntriesCount(long userId, Long parentAccountEntryId, String keywords, String[] types, Integer status) throws PortalException {
        Set<Serializable> accountEntryIds = this._getUserAccountEntryIds(userId, parentAccountEntryId, keywords, types, status);
        return accountEntryIds.size();
    }

    public BaseModelSearchResult<AccountEntry> searchAccountEntries(long companyId, String keywords, LinkedHashMap<String, Object> params, int cur, int delta, String orderByField, boolean reverse) {
        SearchResponse searchResponse = this._searcher.search(this._getSearchRequest(companyId, keywords, params, cur, delta, orderByField, reverse));
        SearchHits searchHits = searchResponse.getSearchHits();
        List accountEntries = TransformUtil.transform((Collection)searchHits.getSearchHits(), searchHit -> {
            Document document = searchHit.getDocument();
            long accountEntryId = document.getLong("entryClassPK");
            AccountEntry accountEntry = this.fetchAccountEntry(accountEntryId);
            if (accountEntry == null) {
                Indexer indexer = IndexerRegistryUtil.getIndexer(AccountEntry.class);
                indexer.delete(document.getLong("companyId").longValue(), document.getString("uid"));
            }
            return accountEntry;
        });
        return new BaseModelSearchResult(accountEntries, searchResponse.getTotalHits());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccountEntry updateAccountEntry(String externalReferenceCode, long accountEntryId, long parentAccountEntryId, String name, String description, boolean deleteLogo, String[] domains, String emailAddress, byte[] logoBytes, String taxIdNumber, int status, ServiceContext serviceContext) throws PortalException {
        AccountEntry accountEntry = this.accountEntryPersistence.findByPrimaryKey(accountEntryId);
        accountEntry.setExternalReferenceCode(externalReferenceCode);
        accountEntry.setParentAccountEntryId(parentAccountEntryId);
        this._validateName(name);
        accountEntry.setDescription(description);
        accountEntry.setName(name);
        AccountEntryEmailAddressValidator accountEntryEmailAddressValidator = this._accountEntryEmailAddressValidatorFactory.create(accountEntry.getCompanyId());
        this._validateEmailAddress(accountEntryEmailAddressValidator, emailAddress);
        accountEntry.setEmailAddress(emailAddress);
        this._portal.updateImageId((BaseModel)accountEntry, !deleteLogo, logoBytes, "logoId", this._userFileUploadsSettings.getImageMaxSize(), this._userFileUploadsSettings.getImageMaxHeight(), this._userFileUploadsSettings.getImageMaxWidth());
        accountEntry.setTaxIdNumber(taxIdNumber);
        accountEntry.setStatus(2);
        ExpandoBridge expandoBridge = ExpandoBridgeFactoryUtil.getExpandoBridge((long)accountEntry.getCompanyId(), (String)accountEntry.getModelClassName(), (long)accountEntryId);
        try {
            ObjectEntryThreadLocal.setExpandoBridgeAttributes((Map)expandoBridge.getAttributes());
            accountEntry.setExpandoBridgeAttributes(serviceContext);
            accountEntry = (AccountEntry)this.accountEntryPersistence.update((BaseModel)accountEntry);
            if (domains != null) {
                accountEntry = this.updateDomains(accountEntryId, domains);
            }
            if (status == 9) {
                status = 0;
            }
            ServiceContext workflowServiceContext = new ServiceContext();
            long workflowUserId = accountEntry.getUserId();
            if (serviceContext != null) {
                this._updateAsset(accountEntry, serviceContext);
                workflowServiceContext = (ServiceContext)serviceContext.clone();
                workflowUserId = serviceContext.getUserId();
            }
            if (this._isWorkflowEnabled(accountEntry.getCompanyId())) {
                this._checkStatus(accountEntry.getStatus(), status);
                accountEntry = this._startWorkflowInstance(workflowUserId, accountEntry, workflowServiceContext);
            } else {
                this.updateStatus(workflowUserId, accountEntryId, status, workflowServiceContext, Collections.emptyMap());
            }
            AccountEntry accountEntry2 = accountEntry;
            return accountEntry2;
        }
        finally {
            ObjectEntryThreadLocal.clearExpandoBridgeAttributes();
        }
    }

    @Indexable(type=IndexableType.REINDEX)
    public AccountEntry updateDefaultBillingAddressId(long accountEntryId, long addressId) throws PortalException {
        AccountEntry accountEntry = this.getAccountEntry(accountEntryId);
        accountEntry.setDefaultBillingAddressId(addressId);
        return this.updateAccountEntry(accountEntry);
    }

    @Indexable(type=IndexableType.REINDEX)
    public AccountEntry updateDefaultShippingAddressId(long accountEntryId, long addressId) throws PortalException {
        AccountEntry accountEntry = this.getAccountEntry(accountEntryId);
        accountEntry.setDefaultShippingAddressId(addressId);
        return this.updateAccountEntry(accountEntry);
    }

    @Indexable(type=IndexableType.REINDEX)
    public AccountEntry updateDomains(long accountEntryId, String[] domains) throws PortalException {
        AccountEntry accountEntry = this.getAccountEntry(accountEntryId);
        AccountEntryEmailAddressValidator accountEntryEmailAddressValidator = this._accountEntryEmailAddressValidatorFactory.create(accountEntry.getCompanyId());
        domains = this._validateDomains(accountEntryEmailAddressValidator, domains);
        accountEntry.setDomains(StringUtil.merge((Object[])domains, (String)","));
        return this.updateAccountEntry(accountEntry);
    }

    @Indexable(type=IndexableType.REINDEX)
    public AccountEntry updateExternalReferenceCode(AccountEntry accountEntry, String externalReferenceCode) throws PortalException {
        if (Objects.equals(accountEntry.getExternalReferenceCode(), externalReferenceCode)) {
            return accountEntry;
        }
        accountEntry.setExternalReferenceCode(externalReferenceCode);
        return this.updateAccountEntry(accountEntry);
    }

    @Indexable(type=IndexableType.REINDEX)
    public AccountEntry updateExternalReferenceCode(long accountEntryId, String externalReferenceCode) throws PortalException {
        return this.updateExternalReferenceCode(this.getAccountEntry(accountEntryId), externalReferenceCode);
    }

    public AccountEntry updateRestrictMembership(long accountEntryId, boolean restrictMembership) throws PortalException {
        AccountEntry accountEntry = this.getAccountEntry(accountEntryId);
        if (restrictMembership == accountEntry.isRestrictMembership()) {
            return accountEntry;
        }
        accountEntry.setRestrictMembership(restrictMembership);
        return this.updateAccountEntry(accountEntry);
    }

    @Indexable(type=IndexableType.REINDEX)
    public AccountEntry updateStatus(AccountEntry accountEntry, int status) throws PortalException {
        accountEntry.setStatus(status);
        ServiceContext workflowServiceContext = new ServiceContext();
        long workflowUserId = accountEntry.getUserId();
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext != null) {
            workflowServiceContext = (ServiceContext)serviceContext.clone();
            workflowUserId = serviceContext.getUserId();
        }
        return this.updateStatus(workflowUserId, accountEntry.getAccountEntryId(), status, workflowServiceContext, Collections.emptyMap());
    }

    @Indexable(type=IndexableType.REINDEX)
    public AccountEntry updateStatus(long accountEntryId, int status) throws PortalException {
        return this.updateStatus(this.getAccountEntry(accountEntryId), status);
    }

    @Indexable(type=IndexableType.REINDEX)
    public AccountEntry updateStatus(long userId, long accountEntryId, int status, ServiceContext serviceContext, Map<String, Serializable> workflowContext) throws PortalException {
        AccountEntry accountEntry = this.getAccountEntry(accountEntryId);
        if (accountEntry.getStatus() == status) {
            return accountEntry;
        }
        accountEntry.setStatus(status);
        User user = this._userLocalService.getUser(userId);
        accountEntry.setStatusByUserId(user.getUserId());
        accountEntry.setStatusByUserName(user.getFullName());
        if (serviceContext == null) {
            serviceContext = new ServiceContext();
        }
        accountEntry.setStatusDate(serviceContext.getModifiedDate(new Date()));
        return this.updateAccountEntry(accountEntry);
    }

    private void _checkStatus(int oldStatus, int newStatus) {
        if (oldStatus != newStatus && _log.isWarnEnabled()) {
            _log.warn((Object)"Workflow is enabled for account entry. The status will be ignored.");
        }
    }

    private Predicate _getAccountEntryWherePredicate(Long parentAccountId, String keywords, String[] types, Integer status) {
        Predicate predicate = null;
        if (parentAccountId != null) {
            predicate = Predicate.and(predicate, (Predicate)AccountEntryTable.INSTANCE.parentAccountEntryId.eq((Object)parentAccountId));
        }
        if (Validator.isNotNull((String)keywords)) {
            Predicate keywordsPredicate = this._customSQL.getKeywordsPredicate(DSLFunctionFactoryUtil.lower((Expression)AccountEntryTable.INSTANCE.name), this._customSQL.keywords(keywords, true));
            if (Validator.isDigit((String)keywords)) {
                keywordsPredicate = Predicate.or((Predicate)AccountEntryTable.INSTANCE.accountEntryId.eq((Object)Long.valueOf(keywords)), (Predicate)keywordsPredicate);
            }
            keywordsPredicate = Predicate.or((Predicate)AccountEntryTable.INSTANCE.externalReferenceCode.eq((Object)keywords), (Predicate)keywordsPredicate);
            predicate = Predicate.and((Predicate)predicate, (Predicate)Predicate.withParentheses((Predicate)keywordsPredicate));
        }
        if (types != null) {
            predicate = Predicate.and((Predicate)predicate, (Predicate)AccountEntryTable.INSTANCE.type.in((Object[])types));
        }
        if (status != null && status != -1) {
            predicate = Predicate.and((Predicate)predicate, (Predicate)AccountEntryTable.INSTANCE.status.eq((Object)status));
        }
        return predicate;
    }

    private Long[] _getOrganizationIds(long userId) {
        HashSet<Long> organizationIds = new HashSet<Long>();
        for (Organization organization : this._organizationLocalService.getUserOrganizations(userId)) {
            organizationIds.add(organization.getOrganizationId());
            for (Organization curOrganization : this._organizationLocalService.getOrganizations(organization.getCompanyId(), organization.getTreePath() + "%")) {
                organizationIds.add(curOrganization.getOrganizationId());
            }
        }
        return organizationIds.toArray(new Long[0]);
    }

    private GroupByStep _getOrganizationsAccountEntriesGroupByStep(FromStep fromStep, long userId, Long parentAccountId, String keywords, String[] types, Integer status) {
        JoinStep joinStep = fromStep.from((Table)AccountEntryTable.INSTANCE);
        Object[] organizationIds = this._getOrganizationIds(userId);
        if (ArrayUtil.isEmpty((Object[])organizationIds)) {
            return joinStep.where(AccountEntryTable.INSTANCE.accountEntryId.eq((Object)-1L));
        }
        return joinStep.innerJoinON((Table)AccountEntryOrganizationRelTable.INSTANCE, AccountEntryOrganizationRelTable.INSTANCE.accountEntryId.eq((Expression)AccountEntryTable.INSTANCE.accountEntryId)).where(AccountEntryOrganizationRelTable.INSTANCE.organizationId.in(organizationIds).and((Expression)this._getAccountEntryWherePredicate(parentAccountId, keywords, types, status)));
    }

    private GroupByStep _getOwnerAccountEntriesGroupByStep(FromStep fromStep, long userId, Long parentAccountId, String keywords, String[] types, Integer status) {
        return fromStep.from((Table)AccountEntryTable.INSTANCE).where(AccountEntryTable.INSTANCE.userId.eq((Object)userId).and((Expression)this._getAccountEntryWherePredicate(parentAccountId, keywords, types, status)));
    }

    private SearchRequest _getSearchRequest(long companyId, String keywords, LinkedHashMap<String, Object> params, int cur, int delta, String orderByField, boolean reverse) {
        SearchRequestBuilder searchRequestBuilder = this._searchRequestBuilderFactory.builder();
        searchRequestBuilder.entryClassNames(new String[]{AccountEntry.class.getName()}).emptySearchEnabled(true).highlightEnabled(false).withSearchContext(searchContext -> this._populateSearchContext((SearchContext)searchContext, companyId, keywords, params));
        if (cur != -1) {
            searchRequestBuilder.from(Integer.valueOf(cur));
            searchRequestBuilder.size(Integer.valueOf(delta));
        }
        if (Validator.isNotNull((String)orderByField)) {
            SortOrder sortOrder = SortOrder.ASC;
            if (reverse) {
                sortOrder = SortOrder.DESC;
            }
            FieldSort fieldSort = this._sorts.field(this._sortFieldBuilder.getSortField(AccountEntry.class, orderByField), sortOrder);
            searchRequestBuilder.sorts(new Sort[]{fieldSort});
        }
        return searchRequestBuilder.build();
    }

    private GroupByStep _getUerAccountEntriesGroupByStep(FromStep fromStep, long userId, Long parentAccountId, String keywords, String[] types, Integer status) {
        return fromStep.from((Table)AccountEntryTable.INSTANCE).innerJoinON((Table)AccountEntryUserRelTable.INSTANCE, AccountEntryUserRelTable.INSTANCE.accountEntryId.eq((Expression)AccountEntryTable.INSTANCE.accountEntryId)).where(AccountEntryUserRelTable.INSTANCE.accountUserId.eq((Object)userId).and((Expression)this._getAccountEntryWherePredicate(parentAccountId, keywords, types, status)));
    }

    private Set<Serializable> _getUserAccountEntryIds(long userId, Long parentAccountEntryId, String keywords, String[] types, Integer status) {
        HashSet<Serializable> accountEntryIds = new HashSet<Serializable>();
        accountEntryIds.addAll((Collection)this.dslQuery((DSLQuery)this._getOrganizationsAccountEntriesGroupByStep(DSLQueryFactoryUtil.selectDistinct((Expression[])new Expression[]{AccountEntryTable.INSTANCE.accountEntryId}), userId, parentAccountEntryId, keywords, types, status)));
        accountEntryIds.addAll((Collection)this.dslQuery((DSLQuery)this._getOwnerAccountEntriesGroupByStep(DSLQueryFactoryUtil.selectDistinct((Expression[])new Expression[]{AccountEntryTable.INSTANCE.accountEntryId}), userId, parentAccountEntryId, keywords, types, status)));
        accountEntryIds.addAll((Collection)this.dslQuery((DSLQuery)this._getUerAccountEntriesGroupByStep(DSLQueryFactoryUtil.selectDistinct((Expression[])new Expression[]{AccountEntryTable.INSTANCE.accountEntryId}), userId, parentAccountEntryId, keywords, types, status)));
        return accountEntryIds;
    }

    private boolean _isWorkflowEnabled(long companyId) {
        Supplier<WorkflowDefinitionLink> workflowDefinitionLinkSupplier = () -> this._workflowDefinitionLinkLocalService.fetchWorkflowDefinitionLink(companyId, 0L, AccountEntry.class.getName(), 0L, 0L);
        return WorkflowThreadLocal.isEnabled() && workflowDefinitionLinkSupplier.get() != null;
    }

    private void _performActions(long[] accountEntryIds, ActionableDynamicQuery.PerformActionMethod<AccountEntry> performActionMethod) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = this.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> dynamicQuery.add(RestrictionsFactoryUtil.in((String)"accountEntryId", (Object[])ArrayUtil.toArray((long[])accountEntryIds))));
        actionableDynamicQuery.setPerformActionMethod(performActionMethod);
        actionableDynamicQuery.performActions();
    }

    private void _populateSearchContext(SearchContext searchContext, long companyId, String keywords, LinkedHashMap<String, Object> params) {
        long permissionUserId;
        long parentAccountEntryId;
        long[] organizationIds;
        Boolean allowNewUserMembership;
        Object[] domains;
        long[] accountUserIds;
        searchContext.setCompanyId(companyId);
        if (Validator.isNotNull((String)keywords)) {
            searchContext.setKeywords(keywords);
        }
        if (MapUtil.isEmpty(params)) {
            return;
        }
        long[] accountGroupIds = (long[])params.get("accountGroupIds");
        if (ArrayUtil.isNotEmpty((long[])accountGroupIds)) {
            searchContext.setAttribute("accountGroupIds", (Serializable)accountGroupIds);
        }
        if (ArrayUtil.isNotEmpty((long[])(accountUserIds = (long[])params.get("accountUserIds")))) {
            searchContext.setAttribute("accountUserIds", (Serializable)accountUserIds);
        }
        if (ArrayUtil.isNotEmpty((Object[])(domains = (String[])params.get("domains")))) {
            searchContext.setAttribute("domains", (Serializable)domains);
        }
        if ((allowNewUserMembership = (Boolean)params.get("allowNewUserMembership")) != null) {
            searchContext.setAttribute("allowNewUserMembership", (Serializable)allowNewUserMembership);
        }
        if (ArrayUtil.isNotEmpty((long[])(organizationIds = (long[])params.get("organizationIds")))) {
            searchContext.setAttribute("organizationIds", (Serializable)organizationIds);
        }
        if ((parentAccountEntryId = GetterUtil.getLong((Object)params.get("parentAccountEntryId"), (long)-1L)) != -1L) {
            searchContext.setAttribute("parentAccountEntryId", (Serializable)Long.valueOf(parentAccountEntryId));
        }
        int status = GetterUtil.getInteger((Object)params.get("status"), (int)0);
        searchContext.setAttribute("status", (Serializable)Integer.valueOf(status));
        Object[] types = (String[])params.get("types");
        if (ArrayUtil.isNotEmpty((Object[])types)) {
            searchContext.setAttribute("types", (Serializable)types);
        }
        if ((permissionUserId = GetterUtil.getLong((Object)params.get("permissionUserId"))) != 0L) {
            searchContext.setUserId(permissionUserId);
        }
    }

    private AccountEntry _startWorkflowInstance(long workflowUserId, AccountEntry accountEntry, ServiceContext workflowServiceContext) throws PortalException {
        Map workflowContext = (Map)((Object)workflowServiceContext.removeAttribute("workflowContext"));
        if (workflowContext == null) {
            workflowContext = Collections.emptyMap();
        }
        return (AccountEntry)WorkflowHandlerRegistryUtil.startWorkflowInstance((long)accountEntry.getCompanyId(), (long)0L, (long)workflowUserId, (String)AccountEntry.class.getName(), (long)accountEntry.getAccountEntryId(), (Object)accountEntry, (ServiceContext)workflowServiceContext, workflowContext);
    }

    private void _updateAsset(AccountEntry accountEntry, ServiceContext serviceContext) throws PortalException {
        Company company = this._companyLocalService.getCompany(serviceContext.getCompanyId());
        this._assetEntryLocalService.updateEntry(serviceContext.getUserId(), company.getGroupId(), accountEntry.getCreateDate(), accountEntry.getModifiedDate(), AccountEntry.class.getName(), accountEntry.getAccountEntryId(), null, 0L, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), true, true, null, null, null, null, null, accountEntry.getName(), accountEntry.getDescription(), null, null, null, 0, 0, null);
    }

    private String[] _validateDomains(AccountEntryEmailAddressValidator accountEntryEmailAddressValidator, String[] domains) throws PortalException {
        if (ArrayUtil.isEmpty((Object[])domains)) {
            return domains;
        }
        Arrays.setAll(domains, i -> StringUtil.lowerCase((String)StringUtil.trim((String)domains[i])));
        for (String domain : domains) {
            if (accountEntryEmailAddressValidator.isValidDomainFormat(domain) && !accountEntryEmailAddressValidator.isBlockedDomain(domain)) continue;
            throw new AccountEntryDomainsException();
        }
        return ArrayUtil.distinct((String[])domains);
    }

    private void _validateEmailAddress(AccountEntryEmailAddressValidator accountEntryEmailAddressValidator, String emailAddress) throws AccountEntryEmailAddressException {
        if (Validator.isBlank((String)emailAddress)) {
            return;
        }
        if (!accountEntryEmailAddressValidator.isValidEmailAddressFormat(emailAddress)) {
            throw new AccountEntryEmailAddressException();
        }
    }

    private void _validateName(String name) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new AccountEntryNameException("Name is null");
        }
    }

    private void _validateType(long companyId, String type) throws PortalException {
        if (!ArrayUtil.contains((Object[])AccountConstants.getAccountEntryTypes((long)companyId), (Object)type)) {
            throw new AccountEntryTypeException(StringBundler.concat((String[])new String[]{"Type \"", type, "\" is not among allowed types: ", StringUtil.merge((Object[])AccountConstants.getAccountEntryTypes((long)companyId), (String)", ")}));
        }
    }
}

