/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.internal.validator;

import com.liferay.portal.kernel.util.ArrayUtil;
import java.util.Objects;
import org.apache.commons.validator.routines.DomainValidator;

public class AccountEntryDomainValidator {
    private final String[] _blockedDomains;
    private final DomainValidator _domainValidator;
    private final boolean _emailAddressDomainValidationEnabled;
    private final String[] _validDomains;

    public AccountEntryDomainValidator(String[] blockedDomains, DomainValidator domainValidator, boolean emailAddressDomainValidationEnabled, String[] validDomains) {
        Objects.requireNonNull(domainValidator);
        this._blockedDomains = blockedDomains;
        this._domainValidator = domainValidator;
        this._emailAddressDomainValidationEnabled = emailAddressDomainValidationEnabled;
        this._validDomains = validDomains;
    }

    public String[] getBlockedDomains() {
        return this._blockedDomains;
    }

    public String[] getValidDomains() {
        return this._validDomains;
    }

    public boolean isBlockedDomain(String domain) {
        return ArrayUtil.contains((Object[])this._blockedDomains, (Object)domain);
    }

    public boolean isEmailAddressDomainValidationEnabled() {
        return this._emailAddressDomainValidationEnabled;
    }

    public boolean isValidDomain(String domain) {
        return !this.isBlockedDomain(domain) && (!this._emailAddressDomainValidationEnabled || ArrayUtil.isEmpty((Object[])this._validDomains) || ArrayUtil.contains((Object[])this._validDomains, (Object)domain));
    }

    public boolean isValidDomainFormat(String domain) {
        return this._domainValidator.isValid(domain);
    }

    public boolean isValidDomainStrict(String domain) {
        return !this.isBlockedDomain(domain) && this._emailAddressDomainValidationEnabled && ArrayUtil.contains((Object[])this._validDomains, (Object)domain);
    }
}

