/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.internal.manager;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactory;
import com.liferay.portal.kernel.service.PortalPreferenceValueLocalService;
import com.liferay.portal.kernel.service.PortalPreferencesLocalService;
import com.liferay.portal.kernel.servlet.PortalSessionThreadLocal;
import com.liferay.portal.kernel.util.GetterUtil;
import jakarta.servlet.http.HttpSession;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CurrentAccountEntryManagerStore.class})
public class CurrentAccountEntryManagerStore {
    private static final Log _log = LogFactoryUtil.getLog(CurrentAccountEntryManagerStore.class);
    @Reference
    private AccountEntryLocalService _accountEntryLocalService;
    @Reference
    private PortalPreferencesLocalService _portalPreferencesLocalService;
    @Reference
    private PortalPreferenceValueLocalService _portalPreferenceValueLocalService;
    @Reference
    private PortletPreferencesFactory _portletPreferencesFactory;

    public AccountEntry getAccountEntryFromHttpSession(long groupId) {
        HttpSession httpSession = PortalSessionThreadLocal.getHttpSession();
        if (httpSession == null) {
            return null;
        }
        long currentAccountEntryId = GetterUtil.getLong((Object)httpSession.getAttribute(this._getKey(groupId)));
        if (currentAccountEntryId > 0L) {
            return this._accountEntryLocalService.fetchAccountEntry(currentAccountEntryId);
        }
        return null;
    }

    public AccountEntry getAccountEntryFromPortalPreferences(long groupId, long userId) {
        com.liferay.portal.kernel.model.PortalPreferences modelPortalPreferences = this._portalPreferencesLocalService.fetchPortalPreferences(userId, 4);
        if (modelPortalPreferences == null) {
            return null;
        }
        PortalPreferences portalPreferences = this._portalPreferenceValueLocalService.getPortalPreferences(modelPortalPreferences, false);
        long accountEntryId = GetterUtil.getLong((String)portalPreferences.getValue(AccountEntry.class.getName(), this._getKey(groupId)));
        if (accountEntryId > 0L) {
            return this._accountEntryLocalService.fetchAccountEntry(accountEntryId);
        }
        return null;
    }

    public AccountEntry getCurrentAccountEntry(long groupId, long userId) throws PortalException {
        AccountEntry accountEntry = this.getAccountEntryFromHttpSession(groupId);
        if (accountEntry == null) {
            accountEntry = this.getAccountEntryFromPortalPreferences(groupId, userId);
        }
        return accountEntry;
    }

    public void saveInHttpSession(long accountEntryId, long groupId) {
        HttpSession httpSession = PortalSessionThreadLocal.getHttpSession();
        if (httpSession == null) {
            return;
        }
        httpSession.setAttribute(this._getKey(groupId), (Object)accountEntryId);
    }

    public void saveInPortalPreferences(long accountEntryId, long groupId, long userId) {
        PortalPreferences portalPreferences = this._getPortalPreferences(userId);
        String key = this._getKey(groupId);
        long currentAccountEntryId = GetterUtil.getLong((String)portalPreferences.getValue(AccountEntry.class.getName(), key, String.valueOf(-1L)));
        if (currentAccountEntryId == accountEntryId) {
            return;
        }
        portalPreferences.setValue(AccountEntry.class.getName(), key, String.valueOf(accountEntryId));
        this._portalPreferencesLocalService.updatePreferences(userId, 4, portalPreferences);
    }

    public void setCurrentAccountEntry(long accountEntryId, long groupId, long userId) {
        this.saveInHttpSession(accountEntryId, groupId);
        this.saveInPortalPreferences(accountEntryId, groupId, userId);
    }

    private String _getKey(long groupId) {
        return "LIFERAY_SHARED_CURRENT_ACCOUNT_ENTRY_ID#" + groupId;
    }

    private PortalPreferences _getPortalPreferences(long userId) {
        try {
            return this._portletPreferencesFactory.getPortalPreferences(userId, true);
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return null;
        }
    }
}

