/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.account.model.impl;

import com.liferay.account.model.AccountRole;
import com.liferay.account.service.AccountRoleLocalServiceUtil;

/**
 * The extended model base implementation for the AccountRole service. Represents a row in the &quot;AccountRole&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link AccountRoleImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see AccountRoleImpl
 * @see AccountRole
 * @generated
 */
public abstract class AccountRoleBaseImpl
	extends AccountRoleModelImpl implements AccountRole {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a account role model instance should use the <code>AccountRole</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			AccountRoleLocalServiceUtil.addAccountRole(this);
		}
		else {
			AccountRoleLocalServiceUtil.updateAccountRole(this);
		}
	}

}