/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.internal.roles.admin.role.type.contributor;

import com.liferay.account.constants.AccountRoleConstants;
import com.liferay.account.model.AccountRole;
import com.liferay.account.service.AccountRoleService;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.roles.admin.role.type.contributor.RoleTypeContributor;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"service.ranking:Integer=500"}, service={RoleTypeContributor.class})
public class AccountRoleTypeContributor
implements RoleTypeContributor {
    private static final Log _log = LogFactoryUtil.getLog(AccountRoleTypeContributor.class);
    @Reference
    private AccountRoleService _accountRoleService;
    @Reference
    private Language _language;

    public String getClassName() {
        return AccountRole.class.getName();
    }

    public String getIcon() {
        return "briefcase";
    }

    public String getName() {
        return "account";
    }

    public String[] getSubtypes() {
        return new String[0];
    }

    public String getTabTitle(Locale locale) {
        return this._language.get(locale, "account-roles");
    }

    public String getTitle(Locale locale) {
        return this._language.get(locale, "account-role");
    }

    public int getType() {
        return 6;
    }

    public boolean isAllowAssignMembers(Role role) {
        return false;
    }

    public boolean isAllowDefinePermissions(Role role) {
        return true;
    }

    public boolean isAllowDelete(Role role) {
        return role != null && !AccountRoleConstants.isRequiredRole((Role)role);
    }

    public boolean isAutomaticallyAssigned(Role role) {
        return AccountRoleConstants.isImpliedRole((Role)role);
    }

    public BaseModelSearchResult<Role> searchRoles(long companyId, String keywords, int start, int end, OrderByComparator<Role> orderByComparator) {
        try {
            BaseModelSearchResult accountRoleBaseModelSearchResult = this._accountRoleService.searchAccountRoles(companyId, new long[]{0L}, keywords, null, start, end, orderByComparator);
            return new BaseModelSearchResult(TransformUtil.transform((Collection)accountRoleBaseModelSearchResult.getBaseModels(), AccountRole::getRole), accountRoleBaseModelSearchResult.getLength());
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            return new BaseModelSearchResult(Collections.emptyList(), 0);
        }
    }
}

