/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.internal.object.system;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.model.AccountEntryTable;
import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.account.service.AccountEntryService;
import com.liferay.headless.admin.user.dto.v1_0.Account;
import com.liferay.headless.admin.user.resource.v1_0.AccountResource;
import com.liferay.object.field.builder.TextObjectFieldBuilder;
import com.liferay.object.model.ObjectField;
import com.liferay.object.system.BaseSystemObjectDefinitionManager;
import com.liferay.object.system.JaxRsApplicationDescriptor;
import com.liferay.object.system.SystemObjectDefinitionManager;
import com.liferay.petra.sql.dsl.Column;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={SystemObjectDefinitionManager.class})
public class AccountEntrySystemObjectDefinitionManager
extends BaseSystemObjectDefinitionManager {
    @Reference
    private AccountEntryLocalService _accountEntryLocalService;
    @Reference
    private AccountEntryService _accountEntryService;
    @Reference
    private AccountResource.Factory _accountResourceFactory;

    public long addBaseModel(User user, Map<String, Object> values) throws Exception {
        AccountResource accountResource = this._buildAccountResource(false, user);
        Account account = accountResource.postAccount(this._toAccount(values));
        this.setExtendedProperties(Account.class.getName(), account, user, values);
        return account.getId();
    }

    public BaseModel<?> deleteBaseModel(BaseModel<?> baseModel) throws PortalException {
        return this._accountEntryLocalService.deleteAccountEntry((AccountEntry)baseModel);
    }

    public BaseModel<?> fetchBaseModelByExternalReferenceCode(String externalReferenceCode, long companyId) {
        return this._accountEntryLocalService.fetchAccountEntryByExternalReferenceCode(externalReferenceCode, companyId);
    }

    public BaseModel<?> getBaseModelByExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        return this._accountEntryLocalService.getAccountEntryByExternalReferenceCode(externalReferenceCode, companyId);
    }

    public String getBaseModelExternalReferenceCode(long primaryKey) throws PortalException {
        AccountEntry accountEntry = this._accountEntryLocalService.getAccountEntry(primaryKey);
        return accountEntry.getExternalReferenceCode();
    }

    public String getExternalReferenceCode() {
        return "L_ACCOUNT";
    }

    public JaxRsApplicationDescriptor getJaxRsApplicationDescriptor() {
        return new JaxRsApplicationDescriptor("Liferay.Headless.Admin.User", "headless-admin-user", "accounts", "v1.0");
    }

    public Map<String, String> getLabelKeys() {
        return HashMapBuilder.put((Object)"label", (Object)"account").put((Object)"pluralLabel", (Object)"accounts").build();
    }

    public Class<?> getModelClass() {
        return AccountEntry.class;
    }

    public List<ObjectField> getObjectFields() {
        return Arrays.asList(new TextObjectFieldBuilder().labelMap(this.createLabelMap("description")).name("description").system(true).build(), new TextObjectFieldBuilder().labelMap(this.createLabelMap("name")).name("name").required(true).system(true).build(), new TextObjectFieldBuilder().labelMap(this.createLabelMap("type")).name("type").required(true).system(true).build());
    }

    public BaseModel<?> getOrAddEmptyBaseModel(String externalReferenceCode, User user) throws PortalException {
        return this._accountEntryService.getOrAddEmptyAccountEntry(externalReferenceCode, externalReferenceCode, "business");
    }

    public Page<?> getPage(User user, String search, Filter filter, Pagination pagination, Sort[] sorts) throws Exception {
        AccountResource accountResource = this._buildAccountResource(true, user);
        return accountResource.getAccountsPage(search, filter, pagination, sorts);
    }

    public Column<?, Long> getPrimaryKeyColumn() {
        return AccountEntryTable.INSTANCE.accountEntryId;
    }

    public String getScope() {
        return "company";
    }

    public Table getTable() {
        return AccountEntryTable.INSTANCE;
    }

    public String getTitleObjectFieldName() {
        return "name";
    }

    public int getVersion() {
        return 2;
    }

    public void updateBaseModel(long primaryKey, User user, Map<String, Object> values) throws Exception {
        AccountResource accountResource = this._buildAccountResource(false, user);
        Account account = accountResource.patchAccount(Long.valueOf(primaryKey), this._toAccount(values));
        this.setExtendedProperties(Account.class.getName(), account, user, values);
    }

    private AccountResource _buildAccountResource(boolean checkPermissions, User user) {
        AccountResource.Builder builder = this._accountResourceFactory.create();
        return builder.checkPermissions(checkPermissions).preferredLocale(user.getLocale()).user(user).build();
    }

    private Account _toAccount(final Map<String, Object> values) {
        return new Account(){
            {
                this.setDescription(() -> GetterUtil.getString(values.get("description")));
                this.setExternalReferenceCode(() -> GetterUtil.getString(values.get("externalReferenceCode")));
                this.setName(() -> GetterUtil.getString(values.get("name")));
                this.setType(() -> Account.Type.create((String)StringUtil.toLowerCase((String)GetterUtil.getString(values.get("type")))));
            }
        };
    }
}

