/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.service.impl;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.model.AccountEntryUserRel;
import com.liferay.account.service.base.AccountEntryUserRelServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import java.util.List;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(property={"json.web.service.context.name=account", "json.web.service.context.path=AccountEntryUserRel"}, service={AopService.class})
public class AccountEntryUserRelServiceImpl
extends AccountEntryUserRelServiceBaseImpl {
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(model.class.name=com.liferay.account.model.AccountEntry)")
    private volatile ModelResourcePermission<AccountEntry> _modelResourcePermission;

    public AccountEntryUserRel addAccountEntryUserRel(long accountEntryId, long creatorUserId, String screenName, String emailAddress, Locale locale, String firstName, String middleName, String lastName, long prefixListTypeId, long suffixListTypeId, String jobTitle, ServiceContext serviceContext) throws PortalException {
        this._modelResourcePermission.check(this.getPermissionChecker(), accountEntryId, "MANAGE_USERS");
        return this.accountEntryUserRelLocalService.addAccountEntryUserRel(accountEntryId, creatorUserId, screenName, emailAddress, locale, firstName, middleName, lastName, prefixListTypeId, suffixListTypeId, jobTitle, serviceContext);
    }

    public AccountEntryUserRel addAccountEntryUserRelByEmailAddress(long accountEntryId, String emailAddress, long[] accountRoleIds, String userExternalReferenceCode, ServiceContext serviceContext) throws PortalException {
        this._modelResourcePermission.check(this.getPermissionChecker(), accountEntryId, "MANAGE_USERS");
        return this.accountEntryUserRelLocalService.addAccountEntryUserRelByEmailAddress(accountEntryId, emailAddress, accountRoleIds, userExternalReferenceCode, serviceContext);
    }

    public void addAccountEntryUserRels(long accountEntryId, long[] accountUserIds) throws PortalException {
        this._modelResourcePermission.check(this.getPermissionChecker(), accountEntryId, "MANAGE_USERS");
        this.accountEntryUserRelLocalService.addAccountEntryUserRels(accountEntryId, accountUserIds);
    }

    public AccountEntryUserRel addPersonTypeAccountEntryUserRel(long accountEntryId, long creatorUserId, String screenName, String emailAddress, Locale locale, String firstName, String middleName, String lastName, long prefixListTypeId, long suffixListTypeId, String jobTitle, ServiceContext serviceContext) throws PortalException {
        this._modelResourcePermission.check(this.getPermissionChecker(), accountEntryId, "MANAGE_USERS");
        return this.accountEntryUserRelLocalService.addPersonTypeAccountEntryUserRel(accountEntryId, creatorUserId, screenName, emailAddress, locale, firstName, middleName, lastName, prefixListTypeId, suffixListTypeId, jobTitle, serviceContext);
    }

    public void deleteAccountEntryUserRelByEmailAddress(long accountEntryId, String emailAddress) throws PortalException {
        this._modelResourcePermission.check(this.getPermissionChecker(), accountEntryId, "MANAGE_USERS");
        this.accountEntryUserRelLocalService.deleteAccountEntryUserRelByEmailAddress(accountEntryId, emailAddress);
    }

    public void deleteAccountEntryUserRels(long accountEntryId, long[] accountUserIds) throws PortalException {
        this._modelResourcePermission.check(this.getPermissionChecker(), accountEntryId, "MANAGE_USERS");
        this.accountEntryUserRelLocalService.deleteAccountEntryUserRels(accountEntryId, accountUserIds);
    }

    public AccountEntryUserRel fetchAccountEntryUserRel(long accountEntryUserRelId) throws PortalException {
        AccountEntryUserRel accountEntryUserRel = this.accountEntryUserRelLocalService.fetchAccountEntryUserRel(accountEntryUserRelId);
        if (accountEntryUserRel != null) {
            this._modelResourcePermission.check(this.getPermissionChecker(), accountEntryUserRel.getAccountEntryId(), "VIEW_USERS");
        }
        return accountEntryUserRel;
    }

    public AccountEntryUserRel fetchAccountEntryUserRel(long accountEntryId, long accountUserId) throws PortalException {
        this._modelResourcePermission.check(this.getPermissionChecker(), accountEntryId, "VIEW_USERS");
        return this.accountEntryUserRelLocalService.fetchAccountEntryUserRel(accountEntryId, accountUserId);
    }

    public AccountEntryUserRel getAccountEntryUserRel(long accountEntryId, long accountUserId) throws PortalException {
        this._modelResourcePermission.check(this.getPermissionChecker(), accountEntryId, "VIEW_USERS");
        return this.accountEntryUserRelLocalService.getAccountEntryUserRel(accountEntryId, accountUserId);
    }

    public List<AccountEntryUserRel> getAccountEntryUserRelsByAccountEntryId(long accountEntryId) throws PortalException {
        this._modelResourcePermission.check(this.getPermissionChecker(), accountEntryId, "VIEW_USERS");
        return this.accountEntryUserRelLocalService.getAccountEntryUserRelsByAccountEntryId(accountEntryId);
    }

    public List<AccountEntryUserRel> getAccountEntryUserRelsByAccountEntryId(long accountEntryId, int start, int end) throws PortalException {
        this._modelResourcePermission.check(this.getPermissionChecker(), accountEntryId, "VIEW_USERS");
        return this.accountEntryUserRelLocalService.getAccountEntryUserRelsByAccountEntryId(accountEntryId, start, end);
    }

    public List<AccountEntryUserRel> getAccountEntryUserRelsByAccountUserId(long accountUserId) throws PortalException {
        this._modelResourcePermission.check(this.getPermissionChecker(), accountUserId, "VIEW_USERS");
        return this.accountEntryUserRelLocalService.getAccountEntryUserRelsByAccountUserId(accountUserId);
    }

    public long getAccountEntryUserRelsCountByAccountEntryId(long accountEntryId) throws PortalException {
        this._modelResourcePermission.check(this.getPermissionChecker(), accountEntryId, "VIEW_USERS");
        return this.accountEntryUserRelLocalService.getAccountEntryUserRelsCountByAccountEntryId(accountEntryId);
    }

    public void inviteUser(long accountEntryId, long[] accountRoleIds, String emailAddress, User inviter, ServiceContext serviceContext) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (!this._modelResourcePermission.contains(permissionChecker, accountEntryId, "INVITE_USER") && !this._modelResourcePermission.contains(permissionChecker, accountEntryId, "MANAGE_USERS")) {
            throw new PrincipalException.MustHavePermission(permissionChecker, AccountEntry.class.getName(), accountEntryId, new String[]{"INVITE_USER", "MANAGE_USERS"});
        }
        this.accountEntryUserRelLocalService.inviteUser(accountEntryId, accountRoleIds, emailAddress, inviter, serviceContext);
    }

    public void setPersonTypeAccountEntryUser(long accountEntryId, long userId) throws PortalException {
        this._modelResourcePermission.check(this.getPermissionChecker(), accountEntryId, "MANAGE_USERS");
        this.accountEntryUserRelLocalService.setPersonTypeAccountEntryUser(accountEntryId, userId);
    }
}

