/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.internal.security.permission.resource;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.model.AccountGroup;
import com.liferay.account.model.AccountGroupRel;
import com.liferay.account.service.AccountGroupLocalService;
import com.liferay.account.service.AccountGroupRelLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(property={"model.class.name=com.liferay.account.model.AccountGroup"}, service={ModelResourcePermission.class})
public class AccountGroupModelResourcePermission
implements ModelResourcePermission<AccountGroup> {
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(model.class.name=com.liferay.account.model.AccountEntry)")
    private volatile ModelResourcePermission<AccountEntry> _accountEntryModelResourcePermission;
    @Reference
    private AccountGroupLocalService _accountGroupLocalService;
    @Reference
    private AccountGroupRelLocalService _accountGroupRelLocalService;
    @Reference(target="(resource.name=com.liferay.account)")
    private PortletResourcePermission _portletResourcePermission;

    public void check(PermissionChecker permissionChecker, AccountGroup accountGroup, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, accountGroup, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, AccountEntry.class.getName(), accountGroup.getAccountGroupId(), new String[]{actionId});
        }
    }

    public void check(PermissionChecker permissionChecker, long accountGroupId, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, accountGroupId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, AccountEntry.class.getName(), accountGroupId, new String[]{actionId});
        }
    }

    public boolean contains(PermissionChecker permissionChecker, AccountGroup accountGroup, String actionId) throws PortalException {
        return this.contains(permissionChecker, accountGroup.getAccountGroupId(), actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, long accountGroupId, String actionId) throws PortalException {
        AccountGroup accountGroup = this._accountGroupLocalService.fetchAccountGroup(accountGroupId);
        if (accountGroup != null && permissionChecker.hasOwnerPermission(permissionChecker.getCompanyId(), AccountGroup.class.getName(), accountGroupId, accountGroup.getUserId(), actionId)) {
            return true;
        }
        if (Objects.equals(actionId, "VIEW")) {
            for (AccountGroupRel accountGroupRel : this._accountGroupRelLocalService.getAccountGroupRelsByAccountGroupId(accountGroupId)) {
                if (!Objects.equals(accountGroupRel.getClassName(), AccountEntry.class.getName()) || !this._accountEntryModelResourcePermission.contains(permissionChecker, accountGroupRel.getClassPK(), "VIEW_ACCOUNT_GROUPS")) continue;
                return true;
            }
        }
        return permissionChecker.hasPermission(null, AccountGroup.class.getName(), accountGroupId, actionId);
    }

    public String getModelName() {
        return AccountGroup.class.getName();
    }

    public PortletResourcePermission getPortletResourcePermission() {
        return this._portletResourcePermission;
    }
}

