/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.internal.search.spi.model.permission;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.model.AccountEntryOrganizationRel;
import com.liferay.account.model.AccountEntryUserRel;
import com.liferay.account.service.AccountEntryOrganizationRelLocalService;
import com.liferay.account.service.AccountEntryUserRelLocalService;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermsFilter;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.UserBag;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.permission.OrganizationPermissionUtil;
import com.liferay.portal.search.spi.model.permission.contributor.SearchPermissionFilterContributor;
import java.util.HashSet;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(property={"indexer.class.name=com.liferay.portal.kernel.model.User"}, service={SearchPermissionFilterContributor.class})
public class UserSearchPermissionFilterContributor
implements SearchPermissionFilterContributor {
    @Reference
    protected RoleLocalService roleLocalService;
    private static final Log _log = LogFactoryUtil.getLog(UserSearchPermissionFilterContributor.class);
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(model.class.name=com.liferay.account.model.AccountEntry)")
    private volatile ModelResourcePermission<AccountEntry> _accountEntryModelResourcePermission;
    @Reference
    private AccountEntryOrganizationRelLocalService _accountEntryOrganizationRelLocalService;
    @Reference
    private AccountEntryUserRelLocalService _accountEntryUserRelLocalService;
    @Reference
    private OrganizationLocalService _organizationLocalService;

    public void contribute(BooleanFilter booleanFilter, long companyId, long[] groupIds, long userId, PermissionChecker permissionChecker, String className) {
        block11: {
            if (!className.equals(User.class.getName())) {
                return;
            }
            try {
                long[] userOrgIds;
                TermsFilter termsFilter = new TermsFilter("accountEntryIds");
                List accountEntryUserRels = this._accountEntryUserRelLocalService.getAccountEntryUserRelsByAccountUserId(permissionChecker.getUserId());
                for (AccountEntryUserRel accountEntryUserRel : accountEntryUserRels) {
                    if (!this._accountEntryModelResourcePermission.contains(permissionChecker, accountEntryUserRel.getAccountEntryId(), "VIEW_USERS")) continue;
                    termsFilter.addValue(String.valueOf(accountEntryUserRel.getAccountEntryId()));
                }
                UserBag userBag = permissionChecker.getUserBag();
                for (long userOrgId : userOrgIds = userBag.getUserOrgIds()) {
                    if (OrganizationPermissionUtil.contains((PermissionChecker)permissionChecker, (long)userOrgId, (String)"MANAGE_ACCOUNTS")) {
                        List accountEntryOrganizationRels = this._accountEntryOrganizationRelLocalService.getAccountEntryOrganizationRelsByOrganizationId(userOrgId);
                        for (AccountEntryOrganizationRel accountEntryOrganizationRel : accountEntryOrganizationRels) {
                            termsFilter.addValue(String.valueOf(accountEntryOrganizationRel.getAccountEntryId()));
                        }
                    }
                    if (!OrganizationPermissionUtil.contains((PermissionChecker)permissionChecker, (long)userOrgId, (String)"MANAGE_SUBORGANIZATIONS_ACCOUNTS")) continue;
                    HashSet organizations = new HashSet();
                    List suborganizations = this._organizationLocalService.getSuborganizations(companyId, userOrgId);
                    while (!suborganizations.isEmpty()) {
                        organizations.addAll(suborganizations);
                        suborganizations = this._organizationLocalService.getSuborganizations(suborganizations);
                    }
                    for (Organization organization : organizations) {
                        List accountEntryOrganizationRels = this._accountEntryOrganizationRelLocalService.getAccountEntryOrganizationRelsByOrganizationId(organization.getOrganizationId());
                        for (AccountEntryOrganizationRel accountEntryOrganizationRel : accountEntryOrganizationRels) {
                            termsFilter.addValue(String.valueOf(accountEntryOrganizationRel.getAccountEntryId()));
                        }
                    }
                }
                if (!termsFilter.isEmpty()) {
                    booleanFilter.add((Filter)termsFilter);
                }
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block11;
                _log.warn((Throwable)exception);
            }
        }
    }
}

