/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.service.impl;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.model.AccountRole;
import com.liferay.account.role.AccountRolePermissionThreadLocal;
import com.liferay.account.service.base.AccountRoleServiceBaseImpl;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.permission.PortalPermissionUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(property={"json.web.service.context.name=account", "json.web.service.context.path=AccountRole"}, service={AopService.class})
public class AccountRoleServiceImpl
extends AccountRoleServiceBaseImpl {
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(model.class.name=com.liferay.account.model.AccountEntry)")
    private volatile ModelResourcePermission<AccountEntry> _accountEntryModelResourcePermission;
    @Reference(target="(model.class.name=com.liferay.account.model.AccountRole)")
    private ModelResourcePermission<AccountRole> _accountRoleModelResourcePermission;

    public AccountRole addAccountRole(String externalReferenceCode, long accountEntryId, String name, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (accountEntryId > 0L) {
            this._accountEntryModelResourcePermission.check(permissionChecker, accountEntryId, "ADD_ACCOUNT_ROLE");
        } else {
            PortalPermissionUtil.check((PermissionChecker)permissionChecker, (String)"ADD_ROLE");
        }
        return this.accountRoleLocalService.addAccountRole(externalReferenceCode, permissionChecker.getUserId(), accountEntryId, name, titleMap, descriptionMap);
    }

    public void associateUser(long accountEntryId, long accountRoleId, long userId) throws PortalException {
        try (SafeCloseable safeCloseable = AccountRolePermissionThreadLocal.setAccountEntryIdWithSafeCloseable((long)accountEntryId);){
            this._accountRoleModelResourcePermission.check(this.getPermissionChecker(), accountRoleId, "ASSIGN_USERS");
        }
        this.accountRoleLocalService.associateUser(accountEntryId, accountRoleId, userId);
    }

    public void associateUser(long accountEntryId, long[] accountRoleIds, long userId) throws PortalException {
        for (long accountRoleId : accountRoleIds) {
            this.associateUser(accountEntryId, accountRoleId, userId);
        }
    }

    public AccountRole deleteAccountRole(AccountRole accountRole) throws PortalException {
        this._accountRoleModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)accountRole, "DELETE");
        return this.accountRoleLocalService.deleteAccountRole(accountRole);
    }

    public AccountRole deleteAccountRole(long accountRoleId) throws PortalException {
        this._accountRoleModelResourcePermission.check(this.getPermissionChecker(), accountRoleId, "DELETE");
        return this.accountRoleLocalService.deleteAccountRole(accountRoleId);
    }

    public AccountRole getAccountRoleByRoleId(long roleId) throws PortalException {
        AccountRole accountRole = this.accountRoleLocalService.getAccountRoleByRoleId(roleId);
        this._accountRoleModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)accountRole, "VIEW");
        return accountRole;
    }

    public BaseModelSearchResult<AccountRole> searchAccountRoles(long companyId, long[] accountEntryIds, String keywords, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator<?> orderByComparator) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (params == null) {
            params = new LinkedHashMap();
        }
        params.put("permissionUserId", permissionChecker.getUserId());
        return this.accountRoleLocalService.searchAccountRoles(companyId, accountEntryIds, keywords, params, start, end, orderByComparator);
    }

    public void setUserAccountRoles(long accountEntryId, long[] accountRoleIds, long userId) throws PortalException {
        try (SafeCloseable safeCloseable = AccountRolePermissionThreadLocal.setAccountEntryIdWithSafeCloseable((long)accountEntryId);){
            for (long accountRoleId : accountRoleIds) {
                this._accountRoleModelResourcePermission.check(this.getPermissionChecker(), accountRoleId, "ASSIGN_USERS");
            }
        }
        this._accountEntryModelResourcePermission.check(this.getPermissionChecker(), accountEntryId, "MANAGE_USERS");
        this.accountRoleLocalService.setUserAccountRoles(accountEntryId, accountRoleIds, userId);
    }

    public void unassociateUser(long accountEntryId, long accountRoleId, long userId) throws PortalException {
        try (SafeCloseable safeCloseable = AccountRolePermissionThreadLocal.setAccountEntryIdWithSafeCloseable((long)accountEntryId);){
            this._accountRoleModelResourcePermission.check(this.getPermissionChecker(), accountRoleId, "ASSIGN_USERS");
        }
        this.accountRoleLocalService.unassociateUser(accountEntryId, accountRoleId, userId);
    }
}

