/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.service.http;

import com.liferay.account.model.AccountRole;
import com.liferay.account.service.AccountRoleServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.security.auth.HttpPrincipal;
import com.liferay.portal.kernel.service.http.TunnelUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

public class AccountRoleServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(AccountRoleServiceHttp.class);
    private static final Class<?>[] _addAccountRoleParameterTypes0 = new Class[]{String.class, Long.TYPE, String.class, Map.class, Map.class};
    private static final Class<?>[] _associateUserParameterTypes1 = new Class[]{Long.TYPE, Long.TYPE, Long.TYPE};
    private static final Class<?>[] _associateUserParameterTypes2 = new Class[]{Long.TYPE, long[].class, Long.TYPE};
    private static final Class<?>[] _deleteAccountRoleParameterTypes3 = new Class[]{AccountRole.class};
    private static final Class<?>[] _deleteAccountRoleParameterTypes4 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getAccountRoleByRoleIdParameterTypes5 = new Class[]{Long.TYPE};
    private static final Class<?>[] _searchAccountRolesParameterTypes6 = new Class[]{Long.TYPE, long[].class, String.class, LinkedHashMap.class, Integer.TYPE, Integer.TYPE, OrderByComparator.class};
    private static final Class<?>[] _setUserAccountRolesParameterTypes7 = new Class[]{Long.TYPE, long[].class, Long.TYPE};
    private static final Class<?>[] _unassociateUserParameterTypes8 = new Class[]{Long.TYPE, Long.TYPE, Long.TYPE};

    public static AccountRole addAccountRole(HttpPrincipal httpPrincipal, String externalReferenceCode, long accountEntryId, String name, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(AccountRoleServiceUtil.class, "addAccountRole", (Class[])_addAccountRoleParameterTypes0);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{externalReferenceCode, accountEntryId, name, titleMap, descriptionMap});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (AccountRole)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static void associateUser(HttpPrincipal httpPrincipal, long accountEntryId, long accountRoleId, long userId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(AccountRoleServiceUtil.class, "associateUser", (Class[])_associateUserParameterTypes1);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{accountEntryId, accountRoleId, userId});
            try {
                TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static void associateUser(HttpPrincipal httpPrincipal, long accountEntryId, long[] accountRoleIds, long userId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(AccountRoleServiceUtil.class, "associateUser", (Class[])_associateUserParameterTypes2);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{accountEntryId, accountRoleIds, userId});
            try {
                TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static AccountRole deleteAccountRole(HttpPrincipal httpPrincipal, AccountRole accountRole) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(AccountRoleServiceUtil.class, "deleteAccountRole", (Class[])_deleteAccountRoleParameterTypes3);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{accountRole});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (AccountRole)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static AccountRole deleteAccountRole(HttpPrincipal httpPrincipal, long accountRoleId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(AccountRoleServiceUtil.class, "deleteAccountRole", (Class[])_deleteAccountRoleParameterTypes4);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{accountRoleId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (AccountRole)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static AccountRole getAccountRoleByRoleId(HttpPrincipal httpPrincipal, long roleId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(AccountRoleServiceUtil.class, "getAccountRoleByRoleId", (Class[])_getAccountRoleByRoleIdParameterTypes5);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{roleId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (AccountRole)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static BaseModelSearchResult<AccountRole> searchAccountRoles(HttpPrincipal httpPrincipal, long companyId, long[] accountEntryIds, String keywords, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator<?> orderByComparator) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(AccountRoleServiceUtil.class, "searchAccountRoles", (Class[])_searchAccountRolesParameterTypes6);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, accountEntryIds, keywords, params, start, end, orderByComparator});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (BaseModelSearchResult)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static void setUserAccountRoles(HttpPrincipal httpPrincipal, long accountEntryId, long[] accountRoleIds, long userId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(AccountRoleServiceUtil.class, "setUserAccountRoles", (Class[])_setUserAccountRolesParameterTypes7);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{accountEntryId, accountRoleIds, userId});
            try {
                TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static void unassociateUser(HttpPrincipal httpPrincipal, long accountEntryId, long accountRoleId, long userId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(AccountRoleServiceUtil.class, "unassociateUser", (Class[])_unassociateUserParameterTypes8);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{accountEntryId, accountRoleId, userId});
            try {
                TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }
}

