/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.account.internal.validator;

import com.liferay.account.internal.validator.AccountEntryDomainValidator;
import com.liferay.account.validator.AccountEntryEmailAddressValidator;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.EmailAddressValidator;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import org.apache.commons.validator.routines.EmailValidator;

public class AccountEntryEmailAddressValidatorImpl
implements AccountEntryEmailAddressValidator {
    private final AccountEntryDomainValidator _accountEntryDomainValidator;
    private final long _companyId;
    private final EmailAddressValidator _emailAddressValidator;
    private final EmailValidator _emailValidator;
    private final UserLocalService _userLocalService;

    public AccountEntryEmailAddressValidatorImpl(AccountEntryDomainValidator accountEntryDomainValidator, long companyId, EmailAddressValidator emailAddressValidator, EmailValidator emailValidator, UserLocalService userLocalService) {
        this._accountEntryDomainValidator = accountEntryDomainValidator;
        this._companyId = companyId;
        this._emailAddressValidator = emailAddressValidator;
        this._emailValidator = emailValidator;
        this._userLocalService = userLocalService;
    }

    public String[] getBlockedDomains() {
        return this._accountEntryDomainValidator.getBlockedDomains();
    }

    public String[] getValidDomains() {
        return this._accountEntryDomainValidator.getValidDomains();
    }

    public boolean isBlockedDomain(String domainOrEmailAddress) {
        return this._accountEntryDomainValidator.isBlockedDomain(this._toDomain(domainOrEmailAddress));
    }

    public boolean isEmailAddressAlreadyUsed(String emailAddress) {
        User user = this._userLocalService.fetchUserByEmailAddress(this._companyId, emailAddress);
        return user != null;
    }

    public boolean isEmailAddressDomainValidationEnabled() {
        return this._accountEntryDomainValidator.isEmailAddressDomainValidationEnabled();
    }

    public boolean isValidDomain(String domainOrEmailAddress) {
        return this._accountEntryDomainValidator.isValidDomain(this._toDomain(domainOrEmailAddress));
    }

    public boolean isValidDomainFormat(String domain) {
        return this._accountEntryDomainValidator.isValidDomainFormat(domain);
    }

    public boolean isValidDomainStrict(String domainOrEmailAddress) {
        return this._accountEntryDomainValidator.isValidDomainStrict(this._toDomain(domainOrEmailAddress));
    }

    public boolean isValidEmailAddressFormat(String emailAddress) {
        return this._emailValidator.isValid(emailAddress) && this._emailAddressValidator.validate(this._companyId, emailAddress);
    }

    private String _toDomain(String emailAddress) {
        if (Validator.isDomain((String)emailAddress)) {
            return emailAddress;
        }
        String normalized = StringUtil.toLowerCase((String)StringUtil.trim((String)emailAddress));
        int index = normalized.indexOf(64);
        if (index <= 0) {
            return emailAddress;
        }
        return normalized.substring(index + 1);
    }
}

